/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.loader.criteria.CriteriaInfoProvider;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

class ComponentCollectionCriteriaInfoProvider
implements CriteriaInfoProvider {
    QueryableCollection persister;
    Map subTypes = new HashMap();

    ComponentCollectionCriteriaInfoProvider(QueryableCollection queryableCollection) {
        this.persister = queryableCollection;
        if (!queryableCollection.getElementType().isComponentType()) {
            throw new IllegalArgumentException("persister for role " + queryableCollection.getRole() + " is not a collection-of-component");
        }
        ComponentType componentType = (ComponentType)queryableCollection.getElementType();
        String[] stringArray = componentType.getPropertyNames();
        Type[] typeArray = componentType.getSubtypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.subTypes.put(stringArray[i], typeArray[i]);
        }
    }

    public String getName() {
        return this.persister.getRole();
    }

    public Serializable[] getSpaces() {
        return this.persister.getCollectionSpaces();
    }

    public PropertyMapping getPropertyMapping() {
        return this.persister;
    }

    public Type getType(String string) {
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("dotted paths not handled (yet?!) for collection-of-component");
        }
        Type type = (Type)this.subTypes.get(string);
        if (type == null) {
            throw new IllegalArgumentException("property " + string + " not found in component of collection " + this.getName());
        }
        return type;
    }
}

