/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubselectCollectionLoader
extends BasicCollectionLoader {
    private final Serializable[] keys;
    private final Type[] types;
    private final Object[] values;
    private final Map<String, TypedValue> namedParameters;
    private final Map<String, int[]> namedParameterLocMap;

    public SubselectCollectionLoader(QueryableCollection queryableCollection, String string, Collection collection, QueryParameters queryParameters, Map<String, int[]> map, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(queryableCollection, 1, string, sessionFactoryImplementor, loadQueryInfluencers);
        this.keys = new Serializable[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.keys[n++] = ((EntityKey)iterator.next()).getIdentifier();
        }
        this.namedParameters = queryParameters.getNamedParameters();
        this.types = queryParameters.getFilteredPositionalParameterTypes();
        this.values = queryParameters.getFilteredPositionalParameterValues();
        this.namedParameterLocMap = map;
    }

    @Override
    public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        this.loadCollectionSubselect(sessionImplementor, this.keys, this.values, this.types, this.namedParameters, this.getKeyType());
    }

    @Override
    public int[] getNamedParameterLocs(String string) {
        return this.namedParameterLocMap.get(string);
    }
}

