/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.BatchingCollectionInitializerBuilder;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.OneToManyLoader;
import org.hibernate.persister.collection.QueryableCollection;

public class PaddedBatchingCollectionInitializerBuilder
extends BatchingCollectionInitializerBuilder {
    public static final PaddedBatchingCollectionInitializerBuilder INSTANCE = new PaddedBatchingCollectionInitializerBuilder();

    public CollectionInitializer createRealBatchingCollectionInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        int[] nArray = ArrayHelper.getBatchSizes(n);
        Loader[] loaderArray = new Loader[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            loaderArray[i] = new BasicCollectionLoader(queryableCollection, nArray[i], sessionFactoryImplementor, loadQueryInfluencers);
        }
        return new PaddedBatchingCollectionInitializer(queryableCollection, nArray, loaderArray);
    }

    public CollectionInitializer createRealBatchingOneToManyInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        int[] nArray = ArrayHelper.getBatchSizes(n);
        Loader[] loaderArray = new Loader[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            loaderArray[i] = new OneToManyLoader(queryableCollection, nArray[i], sessionFactoryImplementor, loadQueryInfluencers);
        }
        return new PaddedBatchingCollectionInitializer(queryableCollection, nArray, loaderArray);
    }

    private static class PaddedBatchingCollectionInitializer
    extends BatchingCollectionInitializer {
        private final int[] batchSizes;
        private final Loader[] loaders;

        public PaddedBatchingCollectionInitializer(QueryableCollection queryableCollection, int[] nArray, Loader[] loaderArray) {
            super(queryableCollection);
            this.batchSizes = nArray;
            this.loaders = loaderArray;
        }

        public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
            Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getCollectionBatch(this.collectionPersister(), serializable, this.batchSizes[0]);
            int n = ArrayHelper.countNonNull(serializableArray);
            if (n <= 1) {
                this.loaders[this.batchSizes.length - 1].loadCollection(sessionImplementor, serializable, this.collectionPersister().getKeyType());
                return;
            }
            int n2 = this.batchSizes.length - 1;
            int n3 = 0;
            while (n3 < this.batchSizes.length - 1 && this.batchSizes[n3] >= n) {
                n2 = n3++;
            }
            Serializable[] serializableArray2 = new Serializable[this.batchSizes[n2]];
            System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
            for (int i = n; i < this.batchSizes[n2]; ++i) {
                serializableArray2[i] = serializable;
            }
            this.loaders[n2].loadCollectionBatch(sessionImplementor, serializableArray2, this.collectionPersister().getKeyType());
        }
    }
}

