/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.loader.collection.OneToManyJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.jboss.logging.Logger;

public class OneToManyLoader
extends CollectionLoader {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, OneToManyLoader.class.getName());

    public OneToManyLoader(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, 1, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public OneToManyLoader(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, n, null, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public OneToManyLoader(QueryableCollection queryableCollection, int n, String string, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
        OneToManyJoinWalker oneToManyJoinWalker = new OneToManyJoinWalker(queryableCollection, n, string, sessionFactoryImplementor, loadQueryInfluencers);
        this.initFromWalker(oneToManyJoinWalker);
        this.postInstantiate();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static select for one-to-many %s: %s", (Object)queryableCollection.getRole(), (Object)this.getSQLString());
        }
    }
}

