/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.BatchingCollectionInitializerBuilder;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.OneToManyLoader;
import org.hibernate.persister.collection.QueryableCollection;

public class LegacyBatchingCollectionInitializerBuilder
extends BatchingCollectionInitializerBuilder {
    public static final LegacyBatchingCollectionInitializerBuilder INSTANCE = new LegacyBatchingCollectionInitializerBuilder();

    public CollectionInitializer createRealBatchingCollectionInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        int[] nArray = ArrayHelper.getBatchSizes(n);
        Loader[] loaderArray = new Loader[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            loaderArray[i] = new BasicCollectionLoader(queryableCollection, nArray[i], sessionFactoryImplementor, loadQueryInfluencers);
        }
        return new LegacyBatchingCollectionInitializer(queryableCollection, nArray, loaderArray);
    }

    public CollectionInitializer createRealBatchingOneToManyInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        int[] nArray = ArrayHelper.getBatchSizes(n);
        Loader[] loaderArray = new Loader[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            loaderArray[i] = new OneToManyLoader(queryableCollection, nArray[i], sessionFactoryImplementor, loadQueryInfluencers);
        }
        return new LegacyBatchingCollectionInitializer(queryableCollection, nArray, loaderArray);
    }

    public static class LegacyBatchingCollectionInitializer
    extends BatchingCollectionInitializer {
        private final int[] batchSizes;
        private final Loader[] loaders;

        public LegacyBatchingCollectionInitializer(QueryableCollection queryableCollection, int[] nArray, Loader[] loaderArray) {
            super(queryableCollection);
            this.batchSizes = nArray;
            this.loaders = loaderArray;
        }

        public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
            Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getCollectionBatch(this.collectionPersister(), serializable, this.batchSizes[0]);
            for (int i = 0; i < this.batchSizes.length - 1; ++i) {
                int n = this.batchSizes[i];
                if (serializableArray[n - 1] == null) continue;
                Serializable[] serializableArray2 = new Serializable[n];
                System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
                this.loaders[i].loadCollectionBatch(sessionImplementor, serializableArray2, this.collectionPersister().getKeyType());
                return;
            }
            this.loaders[this.batchSizes.length - 1].loadCollection(sessionImplementor, serializable, this.collectionPersister().getKeyType());
        }
    }
}

