/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.Loader;
import org.hibernate.loader.collection.BasicCollectionJoinWalker;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.BatchingCollectionInitializerBuilder;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.loader.collection.OneToManyJoinWalker;
import org.hibernate.loader.collection.OneToManyLoader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public class DynamicBatchingCollectionInitializerBuilder
extends BatchingCollectionInitializerBuilder {
    public static final DynamicBatchingCollectionInitializerBuilder INSTANCE = new DynamicBatchingCollectionInitializerBuilder();

    protected CollectionInitializer createRealBatchingCollectionInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new DynamicBatchingCollectionInitializer(queryableCollection, n, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected CollectionInitializer createRealBatchingOneToManyInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new DynamicBatchingCollectionInitializer(queryableCollection, n, sessionFactoryImplementor, loadQueryInfluencers);
    }

    private static class DynamicBatchingCollectionLoader
    extends CollectionLoader {
        private final String sqlTemplate;
        private final String alias;

        public DynamicBatchingCollectionLoader(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
            JoinWalker joinWalker = this.buildJoinWalker(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
            this.initFromWalker(joinWalker);
            this.sqlTemplate = joinWalker.getSQLString();
            this.alias = StringHelper.generateAlias(queryableCollection.getRole(), 0);
            this.postInstantiate();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("SQL-template for dynamic collection [%s] batch-fetching : %s", (Object)queryableCollection.getRole(), (Object)this.sqlTemplate);
            }
        }

        private JoinWalker buildJoinWalker(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            if (queryableCollection.isOneToMany()) {
                return new OneToManyJoinWalker(queryableCollection, -1, null, sessionFactoryImplementor, loadQueryInfluencers){

                    protected StringBuilder whereString(String string, String[] stringArray, String string2, int n) {
                        if (string2 != null) {
                            return super.whereString(string, stringArray, string2, n);
                        }
                        return StringHelper.buildBatchFetchRestrictionFragment(string, stringArray, this.getFactory().getDialect());
                    }
                };
            }
            return new BasicCollectionJoinWalker(queryableCollection, -1, null, sessionFactoryImplementor, loadQueryInfluencers){

                protected StringBuilder whereString(String string, String[] stringArray, String string2, int n) {
                    if (string2 != null) {
                        return super.whereString(string, stringArray, string2, n);
                    }
                    return StringHelper.buildBatchFetchRestrictionFragment(string, stringArray, this.getFactory().getDialect());
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doBatchedCollectionLoad(SessionImplementor sessionImplementor, Serializable[] serializableArray, Type type) throws HibernateException {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Batch loading collection: %s", (Object)MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializableArray, this.getFactory()));
            }
            Object[] objectArray = new Type[serializableArray.length];
            Arrays.fill(objectArray, type);
            QueryParameters queryParameters = new QueryParameters((Type[])objectArray, serializableArray, serializableArray);
            String string = StringHelper.expandBatchIdPlaceholder(this.sqlTemplate, serializableArray, this.alias, this.collectionPersister().getKeyColumnNames(), this.getFactory().getDialect());
            try {
                PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
                boolean bl = persistenceContext.isDefaultReadOnly();
                if (queryParameters.isReadOnlyInitialized()) {
                    persistenceContext.setDefaultReadOnly(queryParameters.isReadOnly());
                } else {
                    queryParameters.setReadOnly(persistenceContext.isDefaultReadOnly());
                }
                persistenceContext.beforeLoad();
                try {
                    try {
                        this.doTheLoad(string, queryParameters, sessionImplementor);
                    }
                    finally {
                        persistenceContext.afterLoad();
                    }
                    persistenceContext.initializeNonLazyCollections();
                }
                finally {
                    persistenceContext.setDefaultReadOnly(bl);
                }
            }
            catch (SQLException sQLException) {
                throw this.getFactory().getSQLExceptionHelper().convert(sQLException, "could not initialize a collection batch: " + MessageHelper.collectionInfoString((CollectionPersister)this.collectionPersister(), serializableArray, this.getFactory()), string);
            }
            LOG.debug("Done batch load");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTheLoad(String string, QueryParameters queryParameters, SessionImplementor sessionImplementor) throws SQLException {
            RowSelection rowSelection = queryParameters.getRowSelection();
            int n = LimitHelper.hasMaxRows(rowSelection) ? rowSelection.getMaxRows() : Integer.MAX_VALUE;
            List<Loader.AfterLoadAction> list = Collections.emptyList();
            Loader.SqlStatementWrapper sqlStatementWrapper = this.executeQueryStatement(string, queryParameters, false, list, sessionImplementor);
            ResultSet resultSet = sqlStatementWrapper.getResultSet();
            Statement statement = sqlStatementWrapper.getStatement();
            try {
                this.processResultSet(resultSet, queryParameters, sessionImplementor, true, null, n, list);
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(statement);
            }
        }
    }

    public static class DynamicBatchingCollectionInitializer
    extends BatchingCollectionInitializer {
        private final int maxBatchSize;
        private final Loader singleKeyLoader;
        private final DynamicBatchingCollectionLoader batchLoader;

        public DynamicBatchingCollectionInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(queryableCollection);
            this.maxBatchSize = n;
            this.singleKeyLoader = queryableCollection.isOneToMany() ? new OneToManyLoader(queryableCollection, 1, sessionFactoryImplementor, loadQueryInfluencers) : new BasicCollectionLoader(queryableCollection, 1, sessionFactoryImplementor, loadQueryInfluencers);
            this.batchLoader = new DynamicBatchingCollectionLoader(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
        }

        public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
            Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getCollectionBatch(this.collectionPersister(), serializable, this.maxBatchSize);
            int n = ArrayHelper.countNonNull(serializableArray);
            if (n <= 1) {
                this.singleKeyLoader.loadCollection(sessionImplementor, serializable, this.collectionPersister().getKeyType());
                return;
            }
            Serializable[] serializableArray2 = new Serializable[n];
            System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
            this.batchLoader.doBatchedCollectionLoad(sessionImplementor, serializableArray2, this.collectionPersister().getKeyType());
        }
    }
}

