/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.DynamicBatchingCollectionInitializerBuilder;
import org.hibernate.loader.collection.LegacyBatchingCollectionInitializerBuilder;
import org.hibernate.loader.collection.OneToManyLoader;
import org.hibernate.loader.collection.PaddedBatchingCollectionInitializerBuilder;
import org.hibernate.persister.collection.QueryableCollection;

public abstract class BatchingCollectionInitializerBuilder {
    public static BatchingCollectionInitializerBuilder getBuilder(SessionFactoryImplementor sessionFactoryImplementor) {
        switch (sessionFactoryImplementor.getSettings().getBatchFetchStyle()) {
            case PADDED: {
                return PaddedBatchingCollectionInitializerBuilder.INSTANCE;
            }
            case DYNAMIC: {
                return DynamicBatchingCollectionInitializerBuilder.INSTANCE;
            }
        }
        return LegacyBatchingCollectionInitializerBuilder.INSTANCE;
    }

    public CollectionInitializer createBatchingCollectionInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        if (n <= 1) {
            return new BasicCollectionLoader(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
        }
        return this.createRealBatchingCollectionInitializer(queryableCollection, n, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected abstract CollectionInitializer createRealBatchingCollectionInitializer(QueryableCollection var1, int var2, SessionFactoryImplementor var3, LoadQueryInfluencers var4);

    public CollectionInitializer createBatchingOneToManyInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        if (n <= 1) {
            return new OneToManyLoader(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
        }
        return this.createRealBatchingOneToManyInitializer(queryableCollection, n, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected abstract CollectionInitializer createRealBatchingOneToManyInitializer(QueryableCollection var1, int var2, SessionFactoryImplementor var3, LoadQueryInfluencers var4);
}

