/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.collection.BasicCollectionJoinWalker;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.persister.collection.QueryableCollection;
import org.jboss.logging.Logger;

public class BasicCollectionLoader
extends CollectionLoader {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BasicCollectionLoader.class.getName());

    public BasicCollectionLoader(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, 1, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public BasicCollectionLoader(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, n, null, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected BasicCollectionLoader(QueryableCollection queryableCollection, int n, String string, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
        BasicCollectionJoinWalker basicCollectionJoinWalker = new BasicCollectionJoinWalker(queryableCollection, n, string, sessionFactoryImplementor, loadQueryInfluencers);
        this.initFromWalker(basicCollectionJoinWalker);
        this.postInstantiate();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static select for collection %s: %s", (Object)queryableCollection.getRole(), (Object)this.getSQLString());
        }
    }
}

