/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.JoinHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;

public final class OuterJoinableAssociation {
    private final PropertyPath propertyPath;
    private final AssociationType joinableType;
    private final Joinable joinable;
    private final String lhsAlias;
    private final String[] lhsColumns;
    private final String rhsAlias;
    private final String[] rhsColumns;
    private final JoinType joinType;
    private final String on;
    private final Map enabledFilters;
    private final boolean hasRestriction;

    public static OuterJoinableAssociation createRoot(AssociationType associationType, String string, SessionFactoryImplementor sessionFactoryImplementor) {
        return new OuterJoinableAssociation(new PropertyPath(), associationType, null, null, string, JoinType.LEFT_OUTER_JOIN, null, false, sessionFactoryImplementor, Collections.EMPTY_MAP);
    }

    public OuterJoinableAssociation(PropertyPath propertyPath, AssociationType associationType, String string, String[] stringArray, String string2, JoinType joinType, String string3, boolean bl, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        this.propertyPath = propertyPath;
        this.joinableType = associationType;
        this.lhsAlias = string;
        this.lhsColumns = stringArray;
        this.rhsAlias = string2;
        this.joinType = joinType;
        this.joinable = associationType.getAssociatedJoinable(sessionFactoryImplementor);
        this.rhsColumns = JoinHelper.getRHSColumnNames(associationType, sessionFactoryImplementor);
        this.on = associationType.getOnCondition(string2, sessionFactoryImplementor, map) + (string3 == null || string3.trim().length() == 0 ? "" : " and ( " + string3 + " )");
        this.hasRestriction = bl;
        this.enabledFilters = map;
    }

    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public String getLhsAlias() {
        return this.lhsAlias;
    }

    public String getRHSAlias() {
        return this.rhsAlias;
    }

    public String getRhsAlias() {
        return this.rhsAlias;
    }

    private boolean isOneToOne() {
        if (this.joinableType.isEntityType()) {
            EntityType entityType = (EntityType)this.joinableType;
            return entityType.isOneToOne();
        }
        return false;
    }

    public AssociationType getJoinableType() {
        return this.joinableType;
    }

    public String getRHSUniqueKeyName() {
        return this.joinableType.getRHSUniqueKeyPropertyName();
    }

    public boolean isCollection() {
        return this.joinableType.isCollectionType();
    }

    public Joinable getJoinable() {
        return this.joinable;
    }

    public boolean hasRestriction() {
        return this.hasRestriction;
    }

    public int getOwner(List list) {
        if (this.isOneToOne() || this.isCollection()) {
            return OuterJoinableAssociation.getPosition(this.lhsAlias, list);
        }
        return -1;
    }

    private static int getPosition(String string, List list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            OuterJoinableAssociation outerJoinableAssociation = (OuterJoinableAssociation)list.get(i);
            if (!outerJoinableAssociation.getJoinable().consumesEntityAlias()) continue;
            if (outerJoinableAssociation.rhsAlias.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void addJoins(JoinFragment joinFragment) throws MappingException {
        joinFragment.addJoin(this.joinable.getTableName(), this.rhsAlias, this.lhsColumns, this.rhsColumns, this.joinType, this.on);
        joinFragment.addJoins(this.joinable.fromJoinFragment(this.rhsAlias, false, true), this.joinable.whereJoinFragment(this.rhsAlias, false, true));
    }

    public void validateJoin(String string) throws MappingException {
        if (this.rhsColumns == null || this.lhsColumns == null || this.lhsColumns.length != this.rhsColumns.length || this.lhsColumns.length == 0) {
            throw new MappingException("invalid join columns for association: " + string);
        }
    }

    public boolean isManyToManyWith(OuterJoinableAssociation outerJoinableAssociation) {
        QueryableCollection queryableCollection;
        if (this.joinable.isCollection() && (queryableCollection = (QueryableCollection)this.joinable).isManyToMany()) {
            return queryableCollection.getElementType() == outerJoinableAssociation.getJoinableType();
        }
        return false;
    }

    public void addManyToManyJoin(JoinFragment joinFragment, QueryableCollection queryableCollection) throws MappingException {
        String string = queryableCollection.getManyToManyFilterFragment(this.rhsAlias, this.enabledFilters);
        String string2 = "".equals(string) ? this.on : ("".equals(this.on) ? string : this.on + " and " + string);
        joinFragment.addJoin(this.joinable.getTableName(), this.rhsAlias, this.lhsColumns, this.rhsColumns, this.joinType, string2);
        joinFragment.addJoins(this.joinable.fromJoinFragment(this.rhsAlias, false, true), this.joinable.whereJoinFragment(this.rhsAlias, false, true));
    }
}

