/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.cache.spi.FilterKey;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.dialect.pagination.NoopLimitHandler;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.jdbc.ColumnNameCache;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.hql.internal.HolderInstantiator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FetchingScrollableResultsImpl;
import org.hibernate.internal.ScrollableResultsImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transform.CacheableResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Loader {
    protected static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Loader.class.getName());
    protected static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private final SessionFactoryImplementor factory;
    private ColumnNameCache columnNameCache;

    public Loader(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    public abstract String getSQLString();

    protected abstract Loadable[] getEntityPersisters();

    protected boolean[] getEntityEagerPropertyFetches() {
        return null;
    }

    protected int[] getOwners() {
        return null;
    }

    protected EntityType[] getOwnerAssociationTypes() {
        return null;
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return null;
    }

    protected int[] getCollectionOwners() {
        return null;
    }

    protected int[][] getCompositeKeyManyToOneTargetIndices() {
        return null;
    }

    protected abstract LockMode[] getLockModes(LockOptions var1);

    protected String applyLocks(String string, QueryParameters queryParameters, Dialect dialect, List<AfterLoadAction> list) throws HibernateException {
        return string;
    }

    protected boolean upgradeLocks() {
        return false;
    }

    protected boolean isSingleRowLoader() {
        return false;
    }

    protected String[] getAliases() {
        return null;
    }

    protected String preprocessSQL(String string, QueryParameters queryParameters, Dialect dialect, List<AfterLoadAction> list) throws HibernateException {
        string = this.applyLocks(string, queryParameters, dialect, list);
        return this.getFactory().getSettings().isCommentsEnabled() ? this.prependComment(string, queryParameters) : string;
    }

    protected boolean shouldUseFollowOnLocking(QueryParameters queryParameters, Dialect dialect, List<AfterLoadAction> list) {
        if (dialect.useFollowOnLocking()) {
            LOG.usingFollowOnLocking();
            LockMode lockMode = this.determineFollowOnLockMode(queryParameters.getLockOptions());
            final LockOptions lockOptions = new LockOptions(lockMode);
            lockOptions.setTimeOut(queryParameters.getLockOptions().getTimeOut());
            lockOptions.setScope(queryParameters.getLockOptions().getScope());
            list.add(new AfterLoadAction(){

                public void afterLoad(SessionImplementor sessionImplementor, Object object, Loadable loadable) {
                    ((Session)((Object)sessionImplementor)).buildLockRequest(lockOptions).lock(loadable.getEntityName(), object);
                }
            });
            queryParameters.setLockOptions(new LockOptions());
            return true;
        }
        return false;
    }

    protected LockMode determineFollowOnLockMode(LockOptions lockOptions) {
        LockMode lockMode = lockOptions.findGreatestLockMode();
        if (lockOptions.hasAliasSpecificLockModes()) {
            LOG.aliasSpecificLockingWithFollowOnLocking(lockMode);
        }
        return lockMode;
    }

    private String prependComment(String string, QueryParameters queryParameters) {
        String string2 = queryParameters.getComment();
        if (string2 == null) {
            return string;
        }
        return new StringBuilder(string2.length() + string.length() + 5).append("/* ").append(string2).append(" */ ").append(string).toString();
    }

    public List doQueryAndInitializeNonLazyCollections(SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl) throws HibernateException, SQLException {
        return this.doQueryAndInitializeNonLazyCollections(sessionImplementor, queryParameters, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List doQueryAndInitializeNonLazyCollections(SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl, ResultTransformer resultTransformer) throws HibernateException, SQLException {
        List list;
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        boolean bl2 = persistenceContext.isDefaultReadOnly();
        if (queryParameters.isReadOnlyInitialized()) {
            persistenceContext.setDefaultReadOnly(queryParameters.isReadOnly());
        } else {
            queryParameters.setReadOnly(persistenceContext.isDefaultReadOnly());
        }
        persistenceContext.beforeLoad();
        try {
            try {
                list = this.doQuery(sessionImplementor, queryParameters, bl, resultTransformer);
            }
            finally {
                persistenceContext.afterLoad();
            }
            persistenceContext.initializeNonLazyCollections();
        }
        finally {
            persistenceContext.setDefaultReadOnly(bl2);
        }
        return list;
    }

    public Object loadSingleRow(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl) throws HibernateException {
        Object object;
        int n = this.getEntityPersisters().length;
        ArrayList arrayList = n == 0 ? null : new ArrayList(n);
        try {
            object = this.getRowFromResultSet(resultSet, sessionImplementor, queryParameters, this.getLockModes(queryParameters.getLockOptions()), null, arrayList, new EntityKey[n], bl);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not read next row of results", this.getSQLString());
        }
        this.initializeEntitiesAndCollections(arrayList, resultSet, sessionImplementor, queryParameters.isReadOnly(sessionImplementor));
        sessionImplementor.getPersistenceContext().initializeNonLazyCollections();
        return object;
    }

    private Object sequentialLoad(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl, EntityKey entityKey) throws HibernateException {
        int n = this.getEntityPersisters().length;
        ArrayList arrayList = n == 0 ? null : new ArrayList(n);
        Object object = null;
        EntityKey[] entityKeyArray = new EntityKey[n];
        try {
            do {
                Object object2 = this.getRowFromResultSet(resultSet, sessionImplementor, queryParameters, this.getLockModes(queryParameters.getLockOptions()), null, arrayList, entityKeyArray, bl);
                if (!entityKey.equals(entityKeyArray[0])) {
                    throw new AssertionFailure(String.format("Unexpected key read for row; expected [%s]; actual [%s]", entityKey, entityKeyArray[0]));
                }
                if (object != null) continue;
                object = object2;
            } while (resultSet.next() && this.isCurrentRowForSameEntity(entityKey, 0, resultSet, sessionImplementor));
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not doAfterTransactionCompletion sequential read of results (forward)", this.getSQLString());
        }
        this.initializeEntitiesAndCollections(arrayList, resultSet, sessionImplementor, queryParameters.isReadOnly(sessionImplementor));
        sessionImplementor.getPersistenceContext().initializeNonLazyCollections();
        return object;
    }

    private boolean isCurrentRowForSameEntity(EntityKey entityKey, int n, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException {
        EntityKey entityKey2 = this.getKeyFromResultSet(n, this.getEntityPersisters()[n], null, resultSet, sessionImplementor);
        return entityKey.equals(entityKey2);
    }

    public Object loadSequentialRowsForward(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl) throws HibernateException {
        try {
            if (resultSet.isAfterLast()) {
                return null;
            }
            if (resultSet.isBeforeFirst()) {
                resultSet.next();
            }
            EntityKey entityKey = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
            return this.sequentialLoad(resultSet, sessionImplementor, queryParameters, bl, entityKey);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not doAfterTransactionCompletion sequential read of results (forward)", this.getSQLString());
        }
    }

    public Object loadSequentialRowsReverse(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl, boolean bl2) throws HibernateException {
        try {
            EntityKey entityKey;
            if (resultSet.isFirst()) {
                return null;
            }
            EntityKey entityKey2 = null;
            if (resultSet.isAfterLast() && bl2) {
                resultSet.last();
                entityKey2 = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
            } else {
                resultSet.previous();
                boolean bl3 = true;
                EntityKey entityKey3 = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
                while (resultSet.previous()) {
                    EntityKey entityKey4 = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor);
                    if (bl3) {
                        bl3 = false;
                        entityKey2 = entityKey4;
                    }
                    if (entityKey3.equals(entityKey4)) continue;
                }
            }
            while (resultSet.previous() && entityKey2.equals(entityKey = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, sessionImplementor))) {
            }
            resultSet.next();
            return this.sequentialLoad(resultSet, sessionImplementor, queryParameters, bl, entityKey2);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not doAfterTransactionCompletion sequential read of results (forward)", this.getSQLString());
        }
    }

    private static EntityKey getOptionalObjectKey(QueryParameters queryParameters, SessionImplementor sessionImplementor) {
        Object object = queryParameters.getOptionalObject();
        Serializable serializable = queryParameters.getOptionalId();
        String string = queryParameters.getOptionalEntityName();
        if (object != null && string != null) {
            return sessionImplementor.generateEntityKey(serializable, sessionImplementor.getEntityPersister(string, object));
        }
        return null;
    }

    private Object getRowFromResultSet(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, LockMode[] lockModeArray, EntityKey entityKey, List list, EntityKey[] entityKeyArray, boolean bl) throws SQLException, HibernateException {
        return this.getRowFromResultSet(resultSet, sessionImplementor, queryParameters, lockModeArray, entityKey, list, entityKeyArray, bl, null);
    }

    private Object getRowFromResultSet(ResultSet resultSet, SessionImplementor sessionImplementor, QueryParameters queryParameters, LockMode[] lockModeArray, EntityKey entityKey, List list, EntityKey[] entityKeyArray, boolean bl, ResultTransformer resultTransformer) throws SQLException, HibernateException {
        Loadable[] loadableArray = this.getEntityPersisters();
        int n = loadableArray.length;
        this.extractKeysFromResultSet(loadableArray, queryParameters, resultSet, sessionImplementor, entityKeyArray, lockModeArray, list);
        this.registerNonExists(entityKeyArray, loadableArray, sessionImplementor);
        Object[] objectArray = this.getRow(resultSet, loadableArray, entityKeyArray, queryParameters.getOptionalObject(), entityKey, lockModeArray, list, sessionImplementor);
        this.readCollectionElements(objectArray, resultSet, sessionImplementor);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                Object object2 = sessionImplementor.getPersistenceContext().proxyFor(loadableArray[i], entityKeyArray[i], object);
                if (object == object2) continue;
                ((HibernateProxy)object2).getHibernateLazyInitializer().setImplementation(object);
                objectArray[i] = object2;
            }
        }
        this.applyPostLoadLocks(objectArray, lockModeArray, sessionImplementor);
        return resultTransformer == null ? this.getResultColumnOrRow(objectArray, queryParameters.getResultTransformer(), resultSet, sessionImplementor) : resultTransformer.transformTuple(this.getResultRow(objectArray, resultSet, sessionImplementor), this.getResultRowAliases());
    }

    protected void extractKeysFromResultSet(Loadable[] loadableArray, QueryParameters queryParameters, ResultSet resultSet, SessionImplementor sessionImplementor, EntityKey[] entityKeyArray, LockMode[] lockModeArray, List list) throws SQLException {
        Type type;
        int n;
        int n2;
        int n3 = loadableArray.length;
        Serializable serializable = queryParameters.getOptionalId();
        if (this.isSingleRowLoader() && serializable != null) {
            entityKeyArray[n3 - 1] = sessionImplementor.generateEntityKey(serializable, loadableArray[n3 - 1]);
            n2 = n3 - 1;
        } else {
            n2 = n3;
        }
        Object[] objectArray = new Object[n2];
        for (n = 0; n < n2; ++n) {
            type = loadableArray[n].getIdentifierType();
            objectArray[n] = type.hydrate(resultSet, this.getEntityAliases()[n].getSuffixedKeyAliases(), sessionImplementor, null);
        }
        for (n = 0; n < n2; ++n) {
            Object object;
            type = loadableArray[n].getIdentifierType();
            if (type.isComponentType() && this.getCompositeKeyManyToOneTargetIndices() != null && (object = this.getCompositeKeyManyToOneTargetIndices()[n]) != null) {
                for (int n4 : object) {
                    Object object2;
                    if (n4 < n2) {
                        object2 = loadableArray[n4].getIdentifierType();
                        Serializable serializable2 = (Serializable)object2.resolve(objectArray[n4], sessionImplementor, null);
                        entityKeyArray[n4] = sessionImplementor.generateEntityKey(serializable2, loadableArray[n4]);
                    }
                    if ((object2 = sessionImplementor.getEntityUsingInterceptor(entityKeyArray[n4])) != null) {
                        this.instanceAlreadyLoaded(resultSet, n4, loadableArray[n4], entityKeyArray[n4], object2, lockModeArray[n4], sessionImplementor);
                        continue;
                    }
                    this.instanceNotYetLoaded(resultSet, n4, loadableArray[n4], this.getEntityAliases()[n4].getRowIdAlias(), entityKeyArray[n4], lockModeArray[n4], Loader.getOptionalObjectKey(queryParameters, sessionImplementor), queryParameters.getOptionalObject(), list, sessionImplementor);
                }
            }
            entityKeyArray[n] = (object = (Object)((Serializable)type.resolve(objectArray[n], sessionImplementor, null))) == null ? null : sessionImplementor.generateEntityKey((Serializable)object, loadableArray[n]);
        }
    }

    protected void applyPostLoadLocks(Object[] objectArray, LockMode[] lockModeArray, SessionImplementor sessionImplementor) {
    }

    private void readCollectionElements(Object[] objectArray, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        CollectionPersister[] collectionPersisterArray = this.getCollectionPersisters();
        if (collectionPersisterArray != null) {
            CollectionAliases[] collectionAliasesArray = this.getCollectionAliases();
            int[] nArray = this.getCollectionOwners();
            for (int i = 0; i < collectionPersisterArray.length; ++i) {
                boolean bl = nArray != null && nArray[i] > -1;
                Object object = bl ? objectArray[nArray[i]] : null;
                CollectionPersister collectionPersister = collectionPersisterArray[i];
                Serializable serializable = object == null ? null : collectionPersister.getCollectionType().getKeyOfOwner(object, sessionImplementor);
                this.readCollectionElement(object, serializable, collectionPersister, collectionAliasesArray[i], resultSet, sessionImplementor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doQuery(SessionImplementor sessionImplementor, QueryParameters queryParameters, boolean bl, ResultTransformer resultTransformer) throws SQLException, HibernateException {
        RowSelection rowSelection = queryParameters.getRowSelection();
        int n = LimitHelper.hasMaxRows(rowSelection) ? rowSelection.getMaxRows() : Integer.MAX_VALUE;
        ArrayList<AfterLoadAction> arrayList = new ArrayList<AfterLoadAction>();
        SqlStatementWrapper sqlStatementWrapper = this.executeQueryStatement(queryParameters, false, arrayList, sessionImplementor);
        ResultSet resultSet = sqlStatementWrapper.getResultSet();
        Statement statement = sqlStatementWrapper.getStatement();
        try {
            List list = this.processResultSet(resultSet, queryParameters, sessionImplementor, bl, resultTransformer, n, arrayList);
            return list;
        }
        finally {
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(statement);
        }
    }

    protected List processResultSet(ResultSet resultSet, QueryParameters queryParameters, SessionImplementor sessionImplementor, boolean bl, ResultTransformer resultTransformer, int n, List<AfterLoadAction> list) throws SQLException {
        int n2;
        int n3 = this.getEntityPersisters().length;
        EntityKey entityKey = Loader.getOptionalObjectKey(queryParameters, sessionImplementor);
        LockMode[] lockModeArray = this.getLockModes(queryParameters.getLockOptions());
        boolean bl2 = this.isSubselectLoadingEnabled();
        ArrayList<EntityKey[]> arrayList = bl2 ? new ArrayList<EntityKey[]>() : null;
        ArrayList arrayList2 = n3 == 0 ? null : new ArrayList(n3 * 10);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        this.handleEmptyCollections(queryParameters.getCollectionKeys(), resultSet, sessionImplementor);
        EntityKey[] entityKeyArray = new EntityKey[n3];
        LOG.trace("Processing result set");
        for (n2 = 0; n2 < n && resultSet.next(); ++n2) {
            if (DEBUG_ENABLED) {
                LOG.debugf("Result set row: %s", (Object)n2);
            }
            Object object = this.getRowFromResultSet(resultSet, sessionImplementor, queryParameters, lockModeArray, entityKey, arrayList2, entityKeyArray, bl, resultTransformer);
            arrayList3.add(object);
            if (!bl2) continue;
            arrayList.add(entityKeyArray);
            entityKeyArray = new EntityKey[n3];
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Done processing result set ({0} rows)", (Object)n2);
        }
        this.initializeEntitiesAndCollections(arrayList2, resultSet, sessionImplementor, queryParameters.isReadOnly(sessionImplementor), list);
        if (bl2) {
            this.createSubselects(arrayList, queryParameters, sessionImplementor);
        }
        return arrayList3;
    }

    protected boolean isSubselectLoadingEnabled() {
        return false;
    }

    protected boolean hasSubselectLoadableCollections() {
        Loadable[] loadableArray;
        for (Loadable loadable : loadableArray = this.getEntityPersisters()) {
            if (!loadable.hasSubselectLoadableCollections()) continue;
            return true;
        }
        return false;
    }

    private static Set[] transpose(List list) {
        Set[] setArray = new Set[((EntityKey[])list.get(0)).length];
        for (int i = 0; i < setArray.length; ++i) {
            setArray[i] = new HashSet(list.size());
            for (Object e : list) {
                setArray[i].add(((EntityKey[])e)[i]);
            }
        }
        return setArray;
    }

    private void createSubselects(List list, QueryParameters queryParameters, SessionImplementor sessionImplementor) {
        if (list.size() > 1) {
            Set[] setArray = Loader.transpose(list);
            Map map = this.buildNamedParameterLocMap(queryParameters);
            Loadable[] loadableArray = this.getEntityPersisters();
            String[] stringArray = this.getAliases();
            for (EntityKey[] entityKeyArray : list) {
                for (int i = 0; i < entityKeyArray.length; ++i) {
                    if (entityKeyArray[i] == null || !loadableArray[i].hasSubselectLoadableCollections()) continue;
                    SubselectFetch subselectFetch = new SubselectFetch(stringArray[i], loadableArray[i], queryParameters, setArray[i], map);
                    sessionImplementor.getPersistenceContext().getBatchFetchQueue().addSubselect(entityKeyArray[i], subselectFetch);
                }
            }
        }
    }

    private Map buildNamedParameterLocMap(QueryParameters queryParameters) {
        if (queryParameters.getNamedParameters() != null) {
            HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
            for (String string : queryParameters.getNamedParameters().keySet()) {
                hashMap.put(string, this.getNamedParameterLocs(string));
            }
            return hashMap;
        }
        return null;
    }

    private void initializeEntitiesAndCollections(List list, Object object, SessionImplementor sessionImplementor, boolean bl) throws HibernateException {
        this.initializeEntitiesAndCollections(list, object, sessionImplementor, bl, Collections.<AfterLoadAction>emptyList());
    }

    private void initializeEntitiesAndCollections(List list, Object object, SessionImplementor sessionImplementor, boolean bl, List<AfterLoadAction> list2) throws HibernateException {
        int n;
        PostLoadEvent postLoadEvent;
        PreLoadEvent preLoadEvent;
        CollectionPersister[] collectionPersisterArray = this.getCollectionPersisters();
        if (collectionPersisterArray != null) {
            for (int i = 0; i < collectionPersisterArray.length; ++i) {
                if (!collectionPersisterArray[i].isArray()) continue;
                this.endCollectionLoad(object, sessionImplementor, collectionPersisterArray[i]);
            }
        }
        if (sessionImplementor.isEventSource()) {
            preLoadEvent = new PreLoadEvent((EventSource)sessionImplementor);
            postLoadEvent = new PostLoadEvent((EventSource)sessionImplementor);
        } else {
            preLoadEvent = null;
            postLoadEvent = null;
        }
        if (list != null) {
            n = list.size();
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Total objects hydrated: {0}", (Object)n);
            }
            for (int i = 0; i < n; ++i) {
                TwoPhaseLoad.initializeEntity(list.get(i), bl, sessionImplementor, preLoadEvent, postLoadEvent);
            }
        }
        if (collectionPersisterArray != null) {
            for (n = 0; n < collectionPersisterArray.length; ++n) {
                if (collectionPersisterArray[n].isArray()) continue;
                this.endCollectionLoad(object, sessionImplementor, collectionPersisterArray[n]);
            }
        }
        if (list != null) {
            for (Object e : list) {
                TwoPhaseLoad.postLoad(e, sessionImplementor, postLoadEvent);
                if (list2 == null) continue;
                for (AfterLoadAction afterLoadAction : list2) {
                    EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(e);
                    if (entityEntry == null) {
                        throw new HibernateException("Could not locate EntityEntry immediately after two-phase load");
                    }
                    afterLoadAction.afterLoad(sessionImplementor, e, (Loadable)entityEntry.getPersister());
                }
            }
        }
    }

    private void endCollectionLoad(Object object, SessionImplementor sessionImplementor, CollectionPersister collectionPersister) {
        sessionImplementor.getPersistenceContext().getLoadContexts().getCollectionLoadContext((ResultSet)object).endLoadingCollections(collectionPersister);
    }

    protected ResultTransformer resolveResultTransformer(ResultTransformer resultTransformer) {
        return resultTransformer;
    }

    protected List getResultList(List list, ResultTransformer resultTransformer) throws QueryException {
        return list;
    }

    protected boolean areResultSetRowsTransformedImmediately() {
        return false;
    }

    protected String[] getResultRowAliases() {
        return null;
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return objectArray;
    }

    protected boolean[] includeInResultRow() {
        return null;
    }

    protected Object[] getResultRow(Object[] objectArray, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return objectArray;
    }

    private void registerNonExists(EntityKey[] entityKeyArray, Loadable[] loadableArray, SessionImplementor sessionImplementor) {
        int[] nArray = this.getOwners();
        if (nArray != null) {
            EntityType[] entityTypeArray = this.getOwnerAssociationTypes();
            for (int i = 0; i < entityKeyArray.length; ++i) {
                boolean bl;
                int n = nArray[i];
                if (n <= -1) continue;
                EntityKey entityKey = entityKeyArray[n];
                if (entityKeyArray[i] != null || entityKey == null) continue;
                PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
                boolean bl2 = bl = entityTypeArray != null && entityTypeArray[i] != null && entityTypeArray[i].isOneToOne();
                if (!bl) continue;
                persistenceContext.addNullProperty(entityKey, entityTypeArray[i].getPropertyName());
            }
        }
    }

    private void readCollectionElement(Object object, Serializable serializable, CollectionPersister collectionPersister, CollectionAliases collectionAliases, ResultSet resultSet, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        Serializable serializable2 = (Serializable)collectionPersister.readKey(resultSet, collectionAliases.getSuffixedKeyAliases(), sessionImplementor);
        if (serializable2 != null) {
            PersistentCollection persistentCollection;
            Object object2;
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Found row of collection: %s", (Object)MessageHelper.collectionInfoString(collectionPersister, serializable2, this.getFactory()));
            }
            if ((object2 = object) != null || (object2 = persistenceContext.getCollectionOwner(serializable2, collectionPersister)) == null) {
                // empty if block
            }
            if ((persistentCollection = persistenceContext.getLoadContexts().getCollectionLoadContext(resultSet).getLoadingCollection(collectionPersister, serializable2)) != null) {
                persistentCollection.readFrom(resultSet, collectionPersister, collectionAliases, object2);
            }
        } else if (serializable != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Result set contains (possibly empty) collection: %s", (Object)MessageHelper.collectionInfoString(collectionPersister, serializable, this.getFactory()));
            }
            persistenceContext.getLoadContexts().getCollectionLoadContext(resultSet).getLoadingCollection(collectionPersister, serializable);
        }
    }

    private void handleEmptyCollections(Serializable[] serializableArray, Object object, SessionImplementor sessionImplementor) {
        if (serializableArray != null) {
            boolean bl = LOG.isDebugEnabled();
            CollectionPersister[] collectionPersisterArray = this.getCollectionPersisters();
            for (int i = 0; i < collectionPersisterArray.length; ++i) {
                for (int j = 0; j < serializableArray.length; ++j) {
                    if (bl) {
                        LOG.debugf("Result set contains (possibly empty) collection: %s", (Object)MessageHelper.collectionInfoString(collectionPersisterArray[i], serializableArray[j], this.getFactory()));
                    }
                    sessionImplementor.getPersistenceContext().getLoadContexts().getCollectionLoadContext((ResultSet)object).getLoadingCollection(collectionPersisterArray[i], serializableArray[j]);
                }
            }
        }
    }

    private EntityKey getKeyFromResultSet(int n, Loadable loadable, Serializable serializable, ResultSet resultSet, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Serializable serializable2;
        if (this.isSingleRowLoader() && serializable != null) {
            serializable2 = serializable;
        } else {
            boolean bl;
            Type type = loadable.getIdentifierType();
            serializable2 = (Serializable)type.nullSafeGet(resultSet, this.getEntityAliases()[n].getSuffixedKeyAliases(), sessionImplementor, null);
            boolean bl2 = bl = serializable != null && serializable2 != null && type.isEqual(serializable, serializable2, this.factory);
            if (bl) {
                serializable2 = serializable;
            }
        }
        return serializable2 == null ? null : sessionImplementor.generateEntityKey(serializable2, loadable);
    }

    private void checkVersion(int n, Loadable loadable, Serializable serializable, Object object, ResultSet resultSet, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Object object2;
        VersionType versionType;
        Object object3 = sessionImplementor.getPersistenceContext().getEntry(object).getVersion();
        if (object3 != null && !(versionType = loadable.getVersionType()).isEqual(object3, object2 = versionType.nullSafeGet(resultSet, this.getEntityAliases()[n].getSuffixedVersionAliases(), sessionImplementor, null))) {
            if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled()) {
                sessionImplementor.getFactory().getStatisticsImplementor().optimisticFailure(loadable.getEntityName());
            }
            throw new StaleObjectStateException(loadable.getEntityName(), serializable);
        }
    }

    private Object[] getRow(ResultSet resultSet, Loadable[] loadableArray, EntityKey[] entityKeyArray, Object object, EntityKey entityKey, LockMode[] lockModeArray, List list, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        int n = loadableArray.length;
        EntityAliases[] entityAliasesArray = this.getEntityAliases();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Result row: %s", (Object)StringHelper.toString(entityKeyArray));
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object2 = null;
            EntityKey entityKey2 = entityKeyArray[i];
            if (entityKeyArray[i] != null) {
                object2 = sessionImplementor.getEntityUsingInterceptor(entityKey2);
                if (object2 != null) {
                    this.instanceAlreadyLoaded(resultSet, i, loadableArray[i], entityKey2, object2, lockModeArray[i], sessionImplementor);
                } else {
                    object2 = this.instanceNotYetLoaded(resultSet, i, loadableArray[i], entityAliasesArray[i].getRowIdAlias(), entityKey2, lockModeArray[i], entityKey, object, list, sessionImplementor);
                }
            }
            objectArray[i] = object2;
        }
        return objectArray;
    }

    private void instanceAlreadyLoaded(ResultSet resultSet, int n, Loadable loadable, EntityKey entityKey, Object object, LockMode lockMode, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (!loadable.isInstance(object)) {
            throw new WrongClassException("loaded object was of wrong class " + object.getClass(), entityKey.getIdentifier(), loadable.getEntityName());
        }
        if (LockMode.NONE != lockMode && this.upgradeLocks()) {
            boolean bl;
            boolean bl2 = bl = loadable.isVersioned() && sessionImplementor.getPersistenceContext().getEntry(object).getLockMode().lessThan(lockMode);
            if (bl) {
                this.checkVersion(n, loadable, entityKey.getIdentifier(), object, resultSet, sessionImplementor);
                sessionImplementor.getPersistenceContext().getEntry(object).setLockMode(lockMode);
            }
        }
    }

    private Object instanceNotYetLoaded(ResultSet resultSet, int n, Loadable loadable, String string, EntityKey entityKey, LockMode lockMode, EntityKey entityKey2, Object object, List list, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        String string2 = this.getInstanceClass(resultSet, n, loadable, entityKey.getIdentifier(), sessionImplementor);
        Object object2 = entityKey2 != null && entityKey.equals(entityKey2) ? object : sessionImplementor.instantiate(string2, entityKey.getIdentifier());
        LockMode lockMode2 = lockMode == LockMode.NONE ? LockMode.READ : lockMode;
        this.loadFromResultSet(resultSet, n, object2, string2, entityKey, string, lockMode2, loadable, sessionImplementor);
        list.add(object2);
        return object2;
    }

    private boolean isEagerPropertyFetchEnabled(int n) {
        boolean[] blArray = this.getEntityEagerPropertyFetches();
        return blArray != null && blArray[n];
    }

    private void loadFromResultSet(ResultSet resultSet, int n, Object object, String string, EntityKey entityKey, String string2, LockMode lockMode, Loadable loadable, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        String string3;
        boolean bl;
        Serializable serializable = entityKey.getIdentifier();
        Loadable loadable2 = (Loadable)this.getFactory().getEntityPersister(string);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Initializing object from ResultSet: {0}", (Object)MessageHelper.infoString((EntityPersister)loadable2, serializable, this.getFactory()));
        }
        TwoPhaseLoad.addUninitializedEntity(entityKey, object, loadable2, lockMode, !(bl = this.isEagerPropertyFetchEnabled(n)), sessionImplementor);
        String[][] stringArray = loadable2 == loadable ? this.getEntityAliases()[n].getSuffixedPropertyAliases() : this.getEntityAliases()[n].getSuffixedPropertyAliases(loadable2);
        Object[] objectArray = loadable2.hydrate(resultSet, serializable, object, loadable, stringArray, bl, sessionImplementor);
        Object object2 = loadable2.hasRowId() ? resultSet.getObject(string2) : null;
        EntityType[] entityTypeArray = this.getOwnerAssociationTypes();
        if (entityTypeArray != null && entityTypeArray[n] != null && (string3 = entityTypeArray[n].getRHSUniqueKeyPropertyName()) != null) {
            int n2 = ((UniqueKeyLoadable)loadable2).getPropertyIndex(string3);
            Type type = loadable2.getPropertyTypes()[n2];
            EntityUniqueKey entityUniqueKey = new EntityUniqueKey(loadable.getEntityName(), string3, type.semiResolve(objectArray[n2], sessionImplementor, object), type, loadable2.getEntityMode(), sessionImplementor.getFactory());
            sessionImplementor.getPersistenceContext().addEntity(entityUniqueKey, object);
        }
        TwoPhaseLoad.postHydrate(loadable2, serializable, objectArray, object2, object, lockMode, !bl, sessionImplementor);
    }

    private String getInstanceClass(ResultSet resultSet, int n, Loadable loadable, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (loadable.hasSubclasses()) {
            Object object = loadable.getDiscriminatorType().nullSafeGet(resultSet, this.getEntityAliases()[n].getSuffixedDiscriminatorAlias(), sessionImplementor, null);
            String string = loadable.getSubclassForDiscriminatorValue(object);
            if (string == null) {
                throw new WrongClassException("Discriminator: " + object, serializable, loadable.getEntityName());
            }
            return string;
        }
        return loadable.getEntityName();
    }

    private void advance(ResultSet resultSet, RowSelection rowSelection) throws SQLException {
        int n = LimitHelper.getFirstRow(rowSelection);
        if (n != 0) {
            if (this.getFactory().getSettings().isScrollableResultSetsEnabled()) {
                resultSet.absolute(n);
            } else {
                for (int i = 0; i < n; ++i) {
                    resultSet.next();
                }
            }
        }
    }

    protected LimitHandler getLimitHandler(String string, RowSelection rowSelection) {
        LimitHandler limitHandler = this.getFactory().getDialect().buildLimitHandler(string, rowSelection);
        return LimitHelper.useLimit(limitHandler, rowSelection) ? limitHandler : new NoopLimitHandler(string, rowSelection);
    }

    private ScrollMode getScrollMode(boolean bl, boolean bl2, boolean bl3, QueryParameters queryParameters) {
        boolean bl4 = this.getFactory().getSettings().isScrollableResultSetsEnabled();
        if (bl4) {
            if (bl) {
                return queryParameters.getScrollMode();
            }
            if (bl2 && !bl3) {
                return ScrollMode.SCROLL_INSENSITIVE;
            }
        }
        return null;
    }

    protected SqlStatementWrapper executeQueryStatement(QueryParameters queryParameters, boolean bl, List<AfterLoadAction> list, SessionImplementor sessionImplementor) throws SQLException {
        return this.executeQueryStatement(this.getSQLString(), queryParameters, bl, list, sessionImplementor);
    }

    protected SqlStatementWrapper executeQueryStatement(String string, QueryParameters queryParameters, boolean bl, List<AfterLoadAction> list, SessionImplementor sessionImplementor) throws SQLException {
        queryParameters.processFilters(string, sessionImplementor);
        LimitHandler limitHandler = this.getLimitHandler(queryParameters.getFilteredSQL(), queryParameters.getRowSelection());
        String string2 = limitHandler.getProcessedSql();
        string2 = this.preprocessSQL(string2, queryParameters, this.getFactory().getDialect(), list);
        PreparedStatement preparedStatement = this.prepareQueryStatement(string2, queryParameters, limitHandler, bl, sessionImplementor);
        return new SqlStatementWrapper(preparedStatement, this.getResultSet(preparedStatement, queryParameters.getRowSelection(), limitHandler, queryParameters.hasAutoDiscoverScalarTypes(), sessionImplementor));
    }

    protected final PreparedStatement prepareQueryStatement(String string, QueryParameters queryParameters, LimitHandler limitHandler, boolean bl, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Dialect dialect = this.getFactory().getDialect();
        RowSelection rowSelection = queryParameters.getRowSelection();
        boolean bl2 = LimitHelper.useLimit(limitHandler, rowSelection);
        boolean bl3 = LimitHelper.hasFirstRow(rowSelection);
        boolean bl4 = bl3 && bl2 && limitHandler.supportsLimitOffset();
        boolean bl5 = queryParameters.isCallable();
        ScrollMode scrollMode = this.getScrollMode(bl, bl3, bl4, queryParameters);
        PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement(string, bl5, scrollMode);
        try {
            LockOptions lockOptions;
            int n = 1;
            n += limitHandler.bindLimitParametersAtStartOfQuery(preparedStatement, n);
            if (bl5) {
                n = dialect.registerResultSetOutParameter((CallableStatement)preparedStatement, n);
            }
            n += this.bindParameterValues(preparedStatement, queryParameters, n, sessionImplementor);
            n += limitHandler.bindLimitParametersAtEndOfQuery(preparedStatement, n);
            limitHandler.setMaxRows(preparedStatement);
            if (rowSelection != null) {
                if (rowSelection.getTimeout() != null) {
                    preparedStatement.setQueryTimeout(rowSelection.getTimeout());
                }
                if (rowSelection.getFetchSize() != null) {
                    preparedStatement.setFetchSize(rowSelection.getFetchSize());
                }
            }
            if ((lockOptions = queryParameters.getLockOptions()) != null && lockOptions.getTimeOut() != -1) {
                if (!dialect.supportsLockTimeouts()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debugf("Lock timeout [%s] requested but dialect reported to not support lock timeouts", (Object)lockOptions.getTimeOut());
                    }
                } else if (dialect.isLockTimeoutParameterized()) {
                    preparedStatement.setInt(n++, lockOptions.getTimeOut());
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Bound [{0}] parameters total", (Object)n);
            }
        }
        catch (SQLException sQLException) {
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            throw sQLException;
        }
        catch (HibernateException hibernateException) {
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            throw hibernateException;
        }
        return preparedStatement;
    }

    protected int bindParameterValues(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException {
        int n2 = 0;
        n2 += this.bindPositionalParameters(preparedStatement, queryParameters, n, sessionImplementor);
        n2 += this.bindNamedParameters(preparedStatement, queryParameters.getNamedParameters(), n + n2, sessionImplementor);
        return n2;
    }

    protected int bindPositionalParameters(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Object[] objectArray = queryParameters.getFilteredPositionalParameterValues();
        Type[] typeArray = queryParameters.getFilteredPositionalParameterTypes();
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            typeArray[i].nullSafeSet(preparedStatement, objectArray[i], n + n2, sessionImplementor);
            n2 += typeArray[i].getColumnSpan(this.getFactory());
        }
        return n2;
    }

    protected int bindNamedParameters(PreparedStatement preparedStatement, Map<String, TypedValue> map, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        int n2 = 0;
        if (CollectionHelper.isEmpty(map)) {
            return n2;
        }
        for (String string : map.keySet()) {
            int[] nArray;
            TypedValue typedValue = map.get(string);
            int n3 = typedValue.getType().getColumnSpan(this.getFactory());
            for (int n4 : nArray = this.getNamedParameterLocs(string)) {
                if (DEBUG_ENABLED) {
                    LOG.debugf("bindNamedParameters() %s -> %s [%s]", typedValue.getValue(), (Object)string, (Object)(n4 + n));
                }
                int n5 = n4 * n3 + n;
                typedValue.getType().nullSafeSet(preparedStatement, typedValue.getValue(), n5, sessionImplementor);
            }
            n2 += nArray.length;
        }
        return n2;
    }

    public int[] getNamedParameterLocs(String string) {
        throw new AssertionFailure("no named parameters");
    }

    protected final ResultSet getResultSet(PreparedStatement preparedStatement, RowSelection rowSelection, LimitHandler limitHandler, boolean bl, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        try {
            ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
            resultSet = this.wrapResultSetIfEnabled(resultSet, sessionImplementor);
            if (!limitHandler.supportsLimitOffset() || !LimitHelper.useLimit(limitHandler, rowSelection)) {
                this.advance(resultSet, rowSelection);
            }
            if (bl) {
                this.autoDiscoverTypes(resultSet);
            }
            return resultSet;
        }
        catch (SQLException sQLException) {
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            throw sQLException;
        }
    }

    protected void autoDiscoverTypes(ResultSet resultSet) {
        throw new AssertionFailure("Auto discover types not supported in this loader");
    }

    private synchronized ResultSet wrapResultSetIfEnabled(ResultSet resultSet, SessionImplementor sessionImplementor) {
        if (sessionImplementor.getFactory().getSettings().isWrapResultSetsEnabled()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Wrapping result set [%s]", (Object)resultSet);
                }
                return sessionImplementor.getFactory().getJdbcServices().getResultSetWrapper().wrap(resultSet, this.retreiveColumnNameToIndexCache(resultSet));
            }
            catch (SQLException sQLException) {
                LOG.unableToWrapResultSet(sQLException);
                return resultSet;
            }
        }
        return resultSet;
    }

    private ColumnNameCache retreiveColumnNameToIndexCache(ResultSet resultSet) throws SQLException {
        if (this.columnNameCache == null) {
            LOG.trace("Building columnName -> columnIndex cache");
            this.columnNameCache = new ColumnNameCache(resultSet.getMetaData().getColumnCount());
        }
        return this.columnNameCache;
    }

    protected final List loadEntity(SessionImplementor sessionImplementor, Object object, Type type, Object object2, String string, Serializable serializable, EntityPersister entityPersister, LockOptions lockOptions) throws HibernateException {
        List list;
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Loading entity: %s", (Object)MessageHelper.infoString(entityPersister, object, type, this.getFactory()));
        }
        try {
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.setPositionalParameterTypes(new Type[]{type});
            queryParameters.setPositionalParameterValues(new Object[]{object});
            queryParameters.setOptionalObject(object2);
            queryParameters.setOptionalEntityName(string);
            queryParameters.setOptionalId(serializable);
            queryParameters.setLockOptions(lockOptions);
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, queryParameters, false);
        }
        catch (SQLException sQLException) {
            Loadable[] loadableArray = this.getEntityPersisters();
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not load an entity: " + MessageHelper.infoString(loadableArray[loadableArray.length - 1], object, type, this.getFactory()), this.getSQLString());
        }
        LOG.debug("Done entity load");
        return list;
    }

    protected final List loadEntity(SessionImplementor sessionImplementor, Object object, Object object2, Type type, Type type2, EntityPersister entityPersister) throws HibernateException {
        List list;
        LOG.debug("Loading collection element by index");
        try {
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters(new Type[]{type, type2}, new Object[]{object, object2}), false);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not collection element by index", this.getSQLString());
        }
        LOG.debug("Done entity load");
        return list;
    }

    public final List loadEntityBatch(SessionImplementor sessionImplementor, Serializable[] serializableArray, Type type, Object object, String string, Serializable serializable, EntityPersister entityPersister, LockOptions lockOptions) throws HibernateException {
        List list;
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Batch loading entity: %s", (Object)MessageHelper.infoString(entityPersister, serializableArray, this.getFactory()));
        }
        Object[] objectArray = new Type[serializableArray.length];
        Arrays.fill(objectArray, type);
        try {
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.setPositionalParameterTypes((Type[])objectArray);
            queryParameters.setPositionalParameterValues(serializableArray);
            queryParameters.setOptionalObject(object);
            queryParameters.setOptionalEntityName(string);
            queryParameters.setOptionalId(serializable);
            queryParameters.setLockOptions(lockOptions);
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, queryParameters, false);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], serializableArray, this.getFactory()), this.getSQLString());
        }
        LOG.debug("Done entity batch load");
        return list;
    }

    public final void loadCollection(SessionImplementor sessionImplementor, Serializable serializable, Type type) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Loading collection: %s", (Object)MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializable, this.getFactory()));
        }
        Object[] objectArray = new Serializable[]{serializable};
        try {
            this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters(new Type[]{type}, objectArray, (Serializable[])objectArray), true);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not initialize a collection: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializable, this.getFactory()), this.getSQLString());
        }
        LOG.debug("Done loading collection");
    }

    public final void loadCollectionBatch(SessionImplementor sessionImplementor, Serializable[] serializableArray, Type type) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Batch loading collection: %s", (Object)MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializableArray, this.getFactory()));
        }
        Object[] objectArray = new Type[serializableArray.length];
        Arrays.fill(objectArray, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters((Type[])objectArray, serializableArray, serializableArray), true);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not initialize a collection batch: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializableArray, this.getFactory()), this.getSQLString());
        }
        LOG.debug("Done batch load");
    }

    protected final void loadCollectionSubselect(SessionImplementor sessionImplementor, Serializable[] serializableArray, Object[] objectArray, Type[] typeArray, Map<String, TypedValue> map, Type type) throws HibernateException {
        Object[] objectArray2 = new Type[serializableArray.length];
        Arrays.fill(objectArray2, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(sessionImplementor, new QueryParameters(typeArray, objectArray, map, serializableArray), true);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not load collection by subselect: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], serializableArray, this.getFactory()), this.getSQLString());
        }
    }

    protected List list(SessionImplementor sessionImplementor, QueryParameters queryParameters, Set set, Type[] typeArray) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = this.factory.getSettings().isQueryCacheEnabled() && queryParameters.isCacheable();
        if (bl) {
            return this.listUsingQueryCache(sessionImplementor, queryParameters, set, typeArray);
        }
        return this.listIgnoreQueryCache(sessionImplementor, queryParameters);
    }

    private List listIgnoreQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return this.getResultList(this.doList(sessionImplementor, queryParameters), queryParameters.getResultTransformer());
    }

    private List listUsingQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters, Set set, Type[] typeArray) {
        ResultTransformer resultTransformer;
        QueryCache queryCache = this.factory.getQueryCache(queryParameters.getCacheRegion());
        QueryKey queryKey = this.generateQueryKey(sessionImplementor, queryParameters);
        if (set == null || set.size() == 0) {
            LOG.tracev("Unexpected querySpaces is {0}", set == null ? set : "empty");
        } else {
            LOG.tracev("querySpaces is {0}", (Object)set);
        }
        List list = this.getResultFromQueryCache(sessionImplementor, queryParameters, set, typeArray, queryCache, queryKey);
        if (list == null) {
            list = this.doList(sessionImplementor, queryParameters, queryKey.getResultTransformer());
            this.putResultInQueryCache(sessionImplementor, queryParameters, typeArray, queryCache, queryKey, list);
        }
        if ((resultTransformer = this.resolveResultTransformer(queryParameters.getResultTransformer())) != null) {
            list = this.areResultSetRowsTransformedImmediately() ? queryKey.getResultTransformer().retransformResults(list, this.getResultRowAliases(), queryParameters.getResultTransformer(), this.includeInResultRow()) : queryKey.getResultTransformer().untransformToTuples(list);
        }
        return this.getResultList(list, queryParameters.getResultTransformer());
    }

    private QueryKey generateQueryKey(SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return QueryKey.generateQueryKey(this.getSQLString(), queryParameters, FilterKey.createFilterKeys(sessionImplementor.getLoadQueryInfluencers().getEnabledFilters()), sessionImplementor, this.createCacheableResultTransformer(queryParameters));
    }

    private CacheableResultTransformer createCacheableResultTransformer(QueryParameters queryParameters) {
        return CacheableResultTransformer.create(queryParameters.getResultTransformer(), this.getResultRowAliases(), this.includeInResultRow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getResultFromQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters, Set set, Type[] typeArray, QueryCache queryCache, QueryKey queryKey) {
        List list = null;
        if (sessionImplementor.getCacheMode().isGetEnabled()) {
            boolean bl = queryParameters.isNaturalKeyLookup() && typeArray.length == 1 && typeArray[0].isEntityType() && this.getEntityPersister((EntityType)EntityType.class.cast(typeArray[0])).getEntityMetamodel().hasImmutableNaturalId();
            PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
            boolean bl2 = persistenceContext.isDefaultReadOnly();
            if (queryParameters.isReadOnlyInitialized()) {
                persistenceContext.setDefaultReadOnly(queryParameters.isReadOnly());
            } else {
                queryParameters.setReadOnly(persistenceContext.isDefaultReadOnly());
            }
            try {
                list = queryCache.get(queryKey, queryKey.getResultTransformer().getCachedResultTypes(typeArray), bl, set, sessionImplementor);
            }
            finally {
                persistenceContext.setDefaultReadOnly(bl2);
            }
            if (this.factory.getStatistics().isStatisticsEnabled()) {
                if (list == null) {
                    this.factory.getStatisticsImplementor().queryCacheMiss(this.getQueryIdentifier(), queryCache.getRegion().getName());
                } else {
                    this.factory.getStatisticsImplementor().queryCacheHit(this.getQueryIdentifier(), queryCache.getRegion().getName());
                }
            }
        }
        return list;
    }

    private EntityPersister getEntityPersister(EntityType entityType) {
        return this.factory.getEntityPersister(entityType.getAssociatedEntityName());
    }

    private void putResultInQueryCache(SessionImplementor sessionImplementor, QueryParameters queryParameters, Type[] typeArray, QueryCache queryCache, QueryKey queryKey, List list) {
        boolean bl;
        if (sessionImplementor.getCacheMode().isPutEnabled() && (bl = queryCache.put(queryKey, queryKey.getResultTransformer().getCachedResultTypes(typeArray), list, queryParameters.isNaturalKeyLookup(), sessionImplementor)) && this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().queryCachePut(this.getQueryIdentifier(), queryCache.getRegion().getName());
        }
    }

    protected List doList(SessionImplementor sessionImplementor, QueryParameters queryParameters) throws HibernateException {
        return this.doList(sessionImplementor, queryParameters, null);
    }

    private List doList(SessionImplementor sessionImplementor, QueryParameters queryParameters, ResultTransformer resultTransformer) throws HibernateException {
        List list;
        boolean bl = this.getFactory().getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        try {
            list = this.doQueryAndInitializeNonLazyCollections(sessionImplementor, queryParameters, true, resultTransformer);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not execute query", this.getSQLString());
        }
        if (bl) {
            this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), list.size(), System.currentTimeMillis() - l);
        }
        return list;
    }

    protected void checkScrollability() throws HibernateException {
    }

    protected boolean needsFetchingScroll() {
        return false;
    }

    protected ScrollableResults scroll(QueryParameters queryParameters, Type[] typeArray, HolderInstantiator holderInstantiator, SessionImplementor sessionImplementor) throws HibernateException {
        this.checkScrollability();
        boolean bl = this.getQueryIdentifier() != null && this.getFactory().getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        try {
            SqlStatementWrapper sqlStatementWrapper = this.executeQueryStatement(queryParameters, true, Collections.<AfterLoadAction>emptyList(), sessionImplementor);
            ResultSet resultSet = sqlStatementWrapper.getResultSet();
            PreparedStatement preparedStatement = (PreparedStatement)sqlStatementWrapper.getStatement();
            if (bl) {
                this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), 0, System.currentTimeMillis() - l);
            }
            if (this.needsFetchingScroll()) {
                return new FetchingScrollableResultsImpl(resultSet, preparedStatement, sessionImplementor, this, queryParameters, typeArray, holderInstantiator);
            }
            return new ScrollableResultsImpl(resultSet, preparedStatement, sessionImplementor, this, queryParameters, typeArray, holderInstantiator);
        }
        catch (SQLException sQLException) {
            throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not execute query using scroll", this.getSQLString());
        }
    }

    protected void postInstantiate() {
    }

    protected abstract EntityAliases[] getEntityAliases();

    protected abstract CollectionAliases[] getCollectionAliases();

    protected String getQueryIdentifier() {
        return null;
    }

    public final SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getSQLString() + ')';
    }

    protected static class SqlStatementWrapper {
        private final Statement statement;
        private final ResultSet resultSet;

        private SqlStatementWrapper(Statement statement, ResultSet resultSet) {
            this.resultSet = resultSet;
            this.statement = statement;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public Statement getStatement() {
            return this.statement;
        }
    }

    protected static interface AfterLoadAction {
        public void afterLoad(SessionImplementor var1, Object var2, Loadable var3);
    }
}

