/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.internal.JoinHelper;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.PropertyPath;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.ConditionFragment;
import org.hibernate.sql.DisjunctionFragment;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public class JoinWalker {
    private final SessionFactoryImplementor factory;
    protected final List associations = new ArrayList();
    private final Set visitedAssociationKeys = new HashSet();
    private final LoadQueryInfluencers loadQueryInfluencers;
    protected String[] suffixes;
    protected String[] collectionSuffixes;
    protected Loadable[] persisters;
    protected int[] owners;
    protected EntityType[] ownerAssociationTypes;
    protected CollectionPersister[] collectionPersisters;
    protected int[] collectionOwners;
    protected String[] aliases;
    protected LockOptions lockOptions;
    protected LockMode[] lockModeArray;
    protected String sql;

    protected JoinWalker(SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        this.factory = sessionFactoryImplementor;
        this.loadQueryInfluencers = loadQueryInfluencers;
    }

    public String[] getCollectionSuffixes() {
        return this.collectionSuffixes;
    }

    public void setCollectionSuffixes(String[] stringArray) {
        this.collectionSuffixes = stringArray;
    }

    public LockOptions getLockModeOptions() {
        return this.lockOptions;
    }

    public LockMode[] getLockModeArray() {
        return this.lockModeArray;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public void setSuffixes(String[] stringArray) {
        this.suffixes = stringArray;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] stringArray) {
        this.aliases = stringArray;
    }

    public int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    public void setCollectionOwners(int[] nArray) {
        this.collectionOwners = nArray;
    }

    public CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    public void setCollectionPersisters(CollectionPersister[] collectionPersisterArray) {
        this.collectionPersisters = collectionPersisterArray;
    }

    public EntityType[] getOwnerAssociationTypes() {
        return this.ownerAssociationTypes;
    }

    public void setOwnerAssociationTypes(EntityType[] entityTypeArray) {
        this.ownerAssociationTypes = entityTypeArray;
    }

    public int[] getOwners() {
        return this.owners;
    }

    public void setOwners(int[] nArray) {
        this.owners = nArray;
    }

    public Loadable[] getPersisters() {
        return this.persisters;
    }

    public void setPersisters(Loadable[] loadableArray) {
        this.persisters = loadableArray;
    }

    public String getSQLString() {
        return this.sql;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected Dialect getDialect() {
        return this.factory.getDialect();
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    private void addAssociationToJoinTreeIfNecessary(AssociationType associationType, String[] stringArray, String string, PropertyPath propertyPath, int n, JoinType joinType) throws MappingException {
        if (joinType != JoinType.NONE) {
            this.addAssociationToJoinTree(associationType, stringArray, string, propertyPath, n, joinType);
        }
    }

    protected boolean hasRestriction(PropertyPath propertyPath) {
        return false;
    }

    protected String getWithClause(PropertyPath propertyPath) {
        return "";
    }

    private void addAssociationToJoinTree(AssociationType associationType, String[] stringArray, String string, PropertyPath propertyPath, int n, JoinType joinType) throws MappingException {
        Joinable joinable = associationType.getAssociatedJoinable(this.getFactory());
        String string2 = this.generateTableAlias(this.associations.size() + 1, propertyPath, joinable);
        OuterJoinableAssociation outerJoinableAssociation = new OuterJoinableAssociation(propertyPath, associationType, string, stringArray, string2, joinType, this.getWithClause(propertyPath), this.hasRestriction(propertyPath), this.getFactory(), this.loadQueryInfluencers.getEnabledFilters());
        outerJoinableAssociation.validateJoin(propertyPath.getFullPath());
        this.associations.add(outerJoinableAssociation);
        int n2 = n + 1;
        if (!joinable.isCollection()) {
            if (joinable instanceof OuterJoinLoadable) {
                this.walkEntityTree((OuterJoinLoadable)joinable, string2, propertyPath, n2);
            }
        } else if (joinable instanceof QueryableCollection) {
            this.walkCollectionTree((QueryableCollection)joinable, string2, propertyPath, n2);
        }
    }

    protected final void walkEntityTree(OuterJoinLoadable outerJoinLoadable, String string) throws MappingException {
        this.walkEntityTree(outerJoinLoadable, string, new PropertyPath(), 0);
    }

    protected final void walkCollectionTree(QueryableCollection queryableCollection, String string) throws MappingException {
        this.walkCollectionTree(queryableCollection, string, new PropertyPath(), 0);
    }

    private void walkCollectionTree(QueryableCollection queryableCollection, String string, PropertyPath propertyPath, int n) throws MappingException {
        if (queryableCollection.isOneToMany()) {
            this.walkEntityTree((OuterJoinLoadable)queryableCollection.getElementPersister(), string, propertyPath, n);
        } else {
            Type type = queryableCollection.getElementType();
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                String[] stringArray = queryableCollection.getElementColumnNames(string);
                String[] stringArray2 = queryableCollection.getElementColumnNames();
                boolean bl = n == 0;
                JoinType joinType = this.getJoinType(associationType, queryableCollection.getFetchMode(), propertyPath, queryableCollection.getTableName(), stringArray2, !bl, n - 1, null);
                this.addAssociationToJoinTreeIfNecessary(associationType, stringArray, string, propertyPath, n - 1, joinType);
            } else if (type.isComponentType()) {
                this.walkCompositeElementTree((CompositeType)type, queryableCollection.getElementColumnNames(), queryableCollection, string, propertyPath, n);
            }
        }
    }

    private void walkEntityAssociationTree(AssociationType associationType, OuterJoinLoadable outerJoinLoadable, int n, String string, PropertyPath propertyPath, boolean bl, int n2) throws MappingException {
        String[] stringArray = JoinHelper.getAliasedLHSColumnNames(associationType, string, n, outerJoinLoadable, this.getFactory());
        String[] stringArray2 = JoinHelper.getLHSColumnNames(associationType, n, outerJoinLoadable, this.getFactory());
        String string2 = JoinHelper.getLHSTableName(associationType, n, outerJoinLoadable);
        PropertyPath propertyPath2 = propertyPath.append(outerJoinLoadable.getSubclassPropertyName(n));
        JoinType joinType = this.getJoinType(outerJoinLoadable, propertyPath2, n, associationType, outerJoinLoadable.getFetchMode(n), outerJoinLoadable.getCascadeStyle(n), string2, stringArray2, bl, n2);
        this.addAssociationToJoinTreeIfNecessary(associationType, stringArray, string, propertyPath2, n2, joinType);
    }

    protected JoinType getJoinType(OuterJoinLoadable outerJoinLoadable, PropertyPath propertyPath, int n, AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle, String string, String[] stringArray, boolean bl, int n2) throws MappingException {
        return this.getJoinType(associationType, fetchMode, propertyPath, string, stringArray, bl, n2, cascadeStyle);
    }

    protected JoinType getJoinType(AssociationType associationType, FetchMode fetchMode, PropertyPath propertyPath, String string, String[] stringArray, boolean bl, int n, CascadeStyle cascadeStyle) throws MappingException {
        if (!this.isJoinedFetchEnabled(associationType, fetchMode, cascadeStyle)) {
            return JoinType.NONE;
        }
        if (this.isTooDeep(n) || associationType.isCollectionType() && this.isTooManyCollections()) {
            return JoinType.NONE;
        }
        if (this.isDuplicateAssociation(string, stringArray, associationType)) {
            return JoinType.NONE;
        }
        return this.getJoinType(bl, n);
    }

    private void walkEntityTree(OuterJoinLoadable outerJoinLoadable, String string, PropertyPath propertyPath, int n) throws MappingException {
        Type type;
        int n2 = outerJoinLoadable.countSubclassProperties();
        for (int i = 0; i < n2; ++i) {
            type = outerJoinLoadable.getSubclassPropertyType(i);
            if (type.isAssociationType()) {
                this.walkEntityAssociationTree((AssociationType)type, outerJoinLoadable, i, string, propertyPath, outerJoinLoadable.isSubclassPropertyNullable(i), n);
                continue;
            }
            if (!type.isComponentType()) continue;
            this.walkComponentTree((CompositeType)type, i, 0, outerJoinLoadable, string, propertyPath.append(outerJoinLoadable.getSubclassPropertyName(i)), n);
        }
        Type type2 = outerJoinLoadable.getIdentifierType();
        if (type2.isComponentType() && (type = (CompositeType)type2).isEmbedded() && outerJoinLoadable.getEntityMetamodel().getIdentifierProperty().isEmbedded()) {
            this.walkComponentTree((CompositeType)type, -1, 0, outerJoinLoadable, string, propertyPath, n);
        }
    }

    private void walkComponentTree(CompositeType compositeType, int n, int n2, OuterJoinLoadable outerJoinLoadable, String string, PropertyPath propertyPath, int n3) throws MappingException {
        Type[] typeArray = compositeType.getSubtypes();
        String[] stringArray = compositeType.getPropertyNames();
        for (int i = 0; i < typeArray.length; ++i) {
            Object object;
            if (typeArray[i].isAssociationType()) {
                object = (AssociationType)typeArray[i];
                String[] stringArray2 = JoinHelper.getAliasedLHSColumnNames((AssociationType)object, string, n, n2, outerJoinLoadable, this.getFactory());
                String[] stringArray3 = JoinHelper.getLHSColumnNames((AssociationType)object, n, n2, outerJoinLoadable, this.getFactory());
                String string2 = JoinHelper.getLHSTableName((AssociationType)object, n, outerJoinLoadable);
                PropertyPath propertyPath2 = propertyPath.append(stringArray[i]);
                boolean[] blArray = compositeType.getPropertyNullability();
                JoinType joinType = this.getJoinType(outerJoinLoadable, propertyPath2, n, (AssociationType)object, compositeType.getFetchMode(i), compositeType.getCascadeStyle(i), string2, stringArray3, blArray == null || blArray[i], n3);
                this.addAssociationToJoinTreeIfNecessary((AssociationType)object, stringArray2, string, propertyPath2, n3, joinType);
            } else if (typeArray[i].isComponentType()) {
                object = propertyPath.append(stringArray[i]);
                this.walkComponentTree((CompositeType)typeArray[i], n, n2, outerJoinLoadable, string, (PropertyPath)object, n3);
            }
            n2 += typeArray[i].getColumnSpan(this.getFactory());
        }
    }

    private void walkCompositeElementTree(CompositeType compositeType, String[] stringArray, QueryableCollection queryableCollection, String string, PropertyPath propertyPath, int n) throws MappingException {
        Type[] typeArray = compositeType.getSubtypes();
        String[] stringArray2 = compositeType.getPropertyNames();
        int n2 = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            Object object;
            int n3 = typeArray[i].getColumnSpan(this.getFactory());
            String[] stringArray3 = ArrayHelper.slice(stringArray, n2, n3);
            if (typeArray[i].isAssociationType()) {
                object = (AssociationType)typeArray[i];
                String[] stringArray4 = StringHelper.qualify(string, stringArray3);
                PropertyPath propertyPath2 = propertyPath.append(stringArray2[i]);
                boolean[] blArray = compositeType.getPropertyNullability();
                JoinType joinType = this.getJoinType((AssociationType)object, compositeType.getFetchMode(i), propertyPath2, queryableCollection.getTableName(), stringArray3, blArray == null || blArray[i], n, compositeType.getCascadeStyle(i));
                this.addAssociationToJoinTreeIfNecessary((AssociationType)object, stringArray4, string, propertyPath2, n, joinType);
            } else if (typeArray[i].isComponentType()) {
                object = propertyPath.append(stringArray2[i]);
                this.walkCompositeElementTree((CompositeType)typeArray[i], stringArray3, queryableCollection, string, (PropertyPath)object, n);
            }
            n2 += n3;
        }
    }

    protected JoinType getJoinType(boolean bl, int n) {
        return !bl && n <= 0 ? JoinType.INNER_JOIN : JoinType.LEFT_OUTER_JOIN;
    }

    protected boolean isTooDeep(int n) {
        Integer n2 = this.getFactory().getSettings().getMaximumFetchDepth();
        return n2 != null && n >= n2;
    }

    protected boolean isTooManyCollections() {
        return false;
    }

    protected boolean isJoinedFetchEnabledInMapping(FetchMode fetchMode, AssociationType associationType) throws MappingException {
        if (!associationType.isEntityType() && !associationType.isCollectionType()) {
            return false;
        }
        if (fetchMode == FetchMode.JOIN) {
            return true;
        }
        if (fetchMode == FetchMode.SELECT) {
            return false;
        }
        if (associationType.isEntityType()) {
            EntityType entityType = (EntityType)associationType;
            EntityPersister entityPersister = this.getFactory().getEntityPersister(entityType.getAssociatedEntityName());
            return !entityPersister.hasProxy();
        }
        return false;
    }

    protected boolean isJoinedFetchEnabled(AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle) {
        return associationType.isEntityType() && this.isJoinedFetchEnabledInMapping(fetchMode, associationType);
    }

    protected String generateTableAlias(int n, PropertyPath propertyPath, Joinable joinable) {
        return StringHelper.generateAlias(joinable.getName(), n);
    }

    protected String generateRootAlias(String string) {
        return StringHelper.generateAlias(string, 0);
    }

    protected boolean isDuplicateAssociation(String string, String[] stringArray) {
        AssociationKey associationKey = new AssociationKey(stringArray, string);
        return !this.visitedAssociationKeys.add(associationKey);
    }

    protected boolean isDuplicateAssociation(String string, String[] stringArray, AssociationType associationType) {
        String[] stringArray2;
        String string2;
        if (associationType.getForeignKeyDirection() == ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT) {
            string2 = string;
            stringArray2 = stringArray;
        } else {
            string2 = associationType.getAssociatedJoinable(this.getFactory()).getTableName();
            stringArray2 = JoinHelper.getRHSColumnNames(associationType, this.getFactory());
        }
        return this.isDuplicateAssociation(string2, stringArray2);
    }

    protected boolean isJoinable(JoinType joinType, Set set, String string, String[] stringArray, AssociationType associationType, int n) {
        if (joinType == JoinType.NONE) {
            return false;
        }
        if (joinType == JoinType.INNER_JOIN) {
            return true;
        }
        Integer n2 = this.getFactory().getSettings().getMaximumFetchDepth();
        boolean bl = n2 != null && n >= n2;
        return !bl && !this.isDuplicateAssociation(string, stringArray, associationType);
    }

    protected String orderBy(List list, String string) {
        return JoinWalker.mergeOrderings(JoinWalker.orderBy(list), string);
    }

    protected static String mergeOrderings(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        return string + ", " + string2;
    }

    protected final JoinFragment mergeOuterJoins(List list) throws MappingException {
        JoinFragment joinFragment = this.getDialect().createOuterJoinFragment();
        Iterator iterator = list.iterator();
        OuterJoinableAssociation outerJoinableAssociation = null;
        while (iterator.hasNext()) {
            OuterJoinableAssociation outerJoinableAssociation2 = (OuterJoinableAssociation)iterator.next();
            if (outerJoinableAssociation != null && outerJoinableAssociation.isManyToManyWith(outerJoinableAssociation2)) {
                outerJoinableAssociation2.addManyToManyJoin(joinFragment, (QueryableCollection)outerJoinableAssociation.getJoinable());
            } else {
                outerJoinableAssociation2.addJoins(joinFragment);
            }
            outerJoinableAssociation = outerJoinableAssociation2;
        }
        outerJoinableAssociation = null;
        return joinFragment;
    }

    protected static final int countEntityPersisters(List list) throws MappingException {
        int n = 0;
        for (OuterJoinableAssociation outerJoinableAssociation : list) {
            if (!outerJoinableAssociation.getJoinable().consumesEntityAlias()) continue;
            ++n;
        }
        return n;
    }

    protected static final int countCollectionPersisters(List list) throws MappingException {
        int n = 0;
        for (OuterJoinableAssociation outerJoinableAssociation : list) {
            if (outerJoinableAssociation.getJoinType() != JoinType.LEFT_OUTER_JOIN || !outerJoinableAssociation.getJoinable().isCollection() || outerJoinableAssociation.hasRestriction()) continue;
            ++n;
        }
        return n;
    }

    protected static final String orderBy(List list) throws MappingException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = list.iterator();
        OuterJoinableAssociation outerJoinableAssociation = null;
        while (iterator.hasNext()) {
            OuterJoinableAssociation outerJoinableAssociation2 = (OuterJoinableAssociation)iterator.next();
            if (outerJoinableAssociation2.getJoinType() == JoinType.LEFT_OUTER_JOIN) {
                String string;
                QueryableCollection queryableCollection;
                if (outerJoinableAssociation2.getJoinable().isCollection()) {
                    queryableCollection = (QueryableCollection)outerJoinableAssociation2.getJoinable();
                    if (queryableCollection.hasOrdering()) {
                        string = queryableCollection.getSQLOrderByString(outerJoinableAssociation2.getRHSAlias());
                        stringBuilder.append(string).append(", ");
                    }
                } else if (outerJoinableAssociation != null && outerJoinableAssociation.getJoinable().isCollection() && (queryableCollection = (QueryableCollection)outerJoinableAssociation.getJoinable()).isManyToMany() && outerJoinableAssociation.isManyToManyWith(outerJoinableAssociation2) && queryableCollection.hasManyToManyOrdering()) {
                    string = queryableCollection.getManyToManyOrderByString(outerJoinableAssociation2.getRHSAlias());
                    stringBuilder.append(string).append(", ");
                }
            }
            outerJoinableAssociation = outerJoinableAssociation2;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    protected StringBuilder whereString(String string, String[] stringArray, int n) {
        if (stringArray.length == 1) {
            InFragment inFragment = new InFragment().setColumn(string, stringArray[0]);
            for (int i = 0; i < n; ++i) {
                inFragment.addValue("?");
            }
            return new StringBuilder(inFragment.toFragmentString());
        }
        ConditionFragment conditionFragment = new ConditionFragment().setTableAlias(string).setCondition(stringArray, "?");
        StringBuilder stringBuilder = new StringBuilder();
        if (n == 1) {
            stringBuilder.append(conditionFragment.toFragmentString());
        } else {
            stringBuilder.append('(');
            DisjunctionFragment disjunctionFragment = new DisjunctionFragment();
            for (int i = 0; i < n; ++i) {
                disjunctionFragment.addCondition(conditionFragment);
            }
            stringBuilder.append(disjunctionFragment.toFragmentString());
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    protected void initPersisters(List list, LockMode lockMode) throws MappingException {
        this.initPersisters(list, new LockOptions(lockMode));
    }

    protected void initPersisters(List list, LockOptions lockOptions) throws MappingException {
        this.initPersisters(list, lockOptions, AssociationInitCallback.NO_CALLBACK);
    }

    protected void initPersisters(List list, LockOptions lockOptions, AssociationInitCallback associationInitCallback) throws MappingException {
        int n = JoinWalker.countEntityPersisters(list);
        int n2 = JoinWalker.countCollectionPersisters(list);
        this.collectionOwners = n2 == 0 ? null : new int[n2];
        this.collectionPersisters = n2 == 0 ? null : new CollectionPersister[n2];
        this.collectionSuffixes = BasicLoader.generateSuffixes(n + 1, n2);
        this.lockOptions = lockOptions;
        this.persisters = new Loadable[n];
        this.aliases = new String[n];
        this.owners = new int[n];
        this.ownerAssociationTypes = new EntityType[n];
        this.lockModeArray = ArrayHelper.fillArray(lockOptions.getLockMode(), n);
        int n3 = 0;
        int n4 = 0;
        for (OuterJoinableAssociation outerJoinableAssociation : list) {
            if (!outerJoinableAssociation.isCollection()) {
                this.persisters[n3] = (Loadable)((Object)outerJoinableAssociation.getJoinable());
                this.aliases[n3] = outerJoinableAssociation.getRHSAlias();
                this.owners[n3] = outerJoinableAssociation.getOwner(list);
                this.ownerAssociationTypes[n3] = (EntityType)outerJoinableAssociation.getJoinableType();
                associationInitCallback.associationProcessed(outerJoinableAssociation, n3);
                ++n3;
                continue;
            }
            QueryableCollection queryableCollection = (QueryableCollection)outerJoinableAssociation.getJoinable();
            if (outerJoinableAssociation.getJoinType() == JoinType.LEFT_OUTER_JOIN && !outerJoinableAssociation.hasRestriction()) {
                this.collectionPersisters[n4] = queryableCollection;
                this.collectionOwners[n4] = outerJoinableAssociation.getOwner(list);
                ++n4;
            }
            if (!queryableCollection.isOneToMany()) continue;
            this.persisters[n3] = (Loadable)queryableCollection.getElementPersister();
            this.aliases[n3] = outerJoinableAssociation.getRHSAlias();
            associationInitCallback.associationProcessed(outerJoinableAssociation, n3);
            ++n3;
        }
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
        if (this.collectionOwners != null && ArrayHelper.isAllNegative(this.collectionOwners)) {
            this.collectionOwners = null;
        }
    }

    protected final String selectString(List list) throws MappingException {
        if (list.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 100);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            OuterJoinableAssociation outerJoinableAssociation = (OuterJoinableAssociation)list.get(i);
            OuterJoinableAssociation outerJoinableAssociation2 = i == list.size() - 1 ? null : (OuterJoinableAssociation)list.get(i + 1);
            Joinable joinable = outerJoinableAssociation.getJoinable();
            String string = this.suffixes == null || n >= this.suffixes.length ? null : this.suffixes[n];
            String string2 = this.collectionSuffixes == null || n2 >= this.collectionSuffixes.length ? null : this.collectionSuffixes[n2];
            String string3 = joinable.selectFragment(outerJoinableAssociation2 == null ? null : outerJoinableAssociation2.getJoinable(), outerJoinableAssociation2 == null ? null : outerJoinableAssociation2.getRHSAlias(), outerJoinableAssociation.getRHSAlias(), string, string2, outerJoinableAssociation.getJoinType() == JoinType.LEFT_OUTER_JOIN);
            if (string3.trim().length() > 0) {
                stringBuilder.append(", ").append(string3);
            }
            if (joinable.consumesEntityAlias()) {
                ++n;
            }
            if (!joinable.consumesCollectionAlias() || outerJoinableAssociation.getJoinType() != JoinType.LEFT_OUTER_JOIN) continue;
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected static interface AssociationInitCallback {
        public static final AssociationInitCallback NO_CALLBACK = new AssociationInitCallback(){

            public void associationProcessed(OuterJoinableAssociation outerJoinableAssociation, int n) {
            }
        };

        public void associationProcessed(OuterJoinableAssociation var1, int var2);
    }

    private static final class AssociationKey {
        private String[] columns;
        private String table;

        private AssociationKey(String[] stringArray, String string) {
            this.columns = stringArray;
            this.table = string;
        }

        public boolean equals(Object object) {
            AssociationKey associationKey = (AssociationKey)object;
            return associationKey.table.equals(this.table) && Arrays.equals(this.columns, associationKey.columns);
        }

        public int hashCode() {
            return this.table.hashCode();
        }
    }
}

