/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Collections;
import java.util.Map;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;

public class GeneratedCollectionAliases
implements CollectionAliases {
    private final String suffix;
    private final String[] keyAliases;
    private final String[] indexAliases;
    private final String[] elementAliases;
    private final String identifierAlias;
    private Map userProvidedAliases;

    public GeneratedCollectionAliases(Map map, CollectionPersister collectionPersister, String string) {
        this.suffix = string;
        this.userProvidedAliases = map;
        this.keyAliases = this.getUserProvidedAliases("key", collectionPersister.getKeyColumnAliases(string));
        this.indexAliases = this.getUserProvidedAliases("index", collectionPersister.getIndexColumnAliases(string));
        this.elementAliases = this.getUserProvidedAliases("element", collectionPersister.getElementColumnAliases(string));
        this.identifierAlias = this.getUserProvidedAlias("id", collectionPersister.getIdentifierColumnAlias(string));
    }

    public GeneratedCollectionAliases(CollectionPersister collectionPersister, String string) {
        this(Collections.EMPTY_MAP, collectionPersister, string);
    }

    public String[] getSuffixedKeyAliases() {
        return this.keyAliases;
    }

    public String[] getSuffixedIndexAliases() {
        return this.indexAliases;
    }

    public String[] getSuffixedElementAliases() {
        return this.elementAliases;
    }

    public String getSuffixedIdentifierAlias() {
        return this.identifierAlias;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return super.toString() + " [suffix=" + this.suffix + ", suffixedKeyAliases=[" + this.join(this.keyAliases) + "], suffixedIndexAliases=[" + this.join(this.indexAliases) + "], suffixedElementAliases=[" + this.join(this.elementAliases) + "], suffixedIdentifierAlias=[" + this.identifierAlias + "]]";
    }

    private String join(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return StringHelper.join(", ", stringArray);
    }

    private String[] getUserProvidedAliases(String string, String[] stringArray) {
        String[] stringArray2 = (String[])this.userProvidedAliases.get(string);
        if (stringArray2 == null) {
            return stringArray;
        }
        return stringArray2;
    }

    private String getUserProvidedAlias(String string, String string2) {
        String[] stringArray = (String[])this.userProvidedAliases.get(string);
        if (stringArray == null) {
            return string2;
        }
        return stringArray[0];
    }
}

