/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.Loader;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.BagType;

public abstract class BasicLoader
extends Loader {
    protected static final String[] NO_SUFFIX = new String[]{""};
    private EntityAliases[] descriptors;
    private CollectionAliases[] collectionDescriptors;

    public BasicLoader(SessionFactoryImplementor sessionFactoryImplementor) {
        super(sessionFactoryImplementor);
    }

    protected final EntityAliases[] getEntityAliases() {
        return this.descriptors;
    }

    protected final CollectionAliases[] getCollectionAliases() {
        return this.collectionDescriptors;
    }

    protected abstract String[] getSuffixes();

    protected abstract String[] getCollectionSuffixes();

    protected void postInstantiate() {
        Loadable[] loadableArray = this.getEntityPersisters();
        String[] stringArray = this.getSuffixes();
        this.descriptors = new EntityAliases[loadableArray.length];
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i] = new DefaultEntityAliases(loadableArray[i], stringArray[i]);
        }
        CollectionPersister[] collectionPersisterArray = this.getCollectionPersisters();
        ArrayList<String> arrayList = null;
        if (collectionPersisterArray != null) {
            String[] stringArray2 = this.getCollectionSuffixes();
            this.collectionDescriptors = new CollectionAliases[collectionPersisterArray.length];
            for (int i = 0; i < collectionPersisterArray.length; ++i) {
                if (this.isBag(collectionPersisterArray[i])) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(collectionPersisterArray[i].getRole());
                }
                this.collectionDescriptors[i] = new GeneratedCollectionAliases(collectionPersisterArray[i], stringArray2[i]);
            }
        } else {
            this.collectionDescriptors = null;
        }
        if (arrayList != null && arrayList.size() > 1) {
            throw new MultipleBagFetchException(arrayList);
        }
    }

    private boolean isBag(CollectionPersister collectionPersister) {
        return collectionPersister.getCollectionType().getClass().isAssignableFrom(BagType.class);
    }

    public static String[] generateSuffixes(int n) {
        return BasicLoader.generateSuffixes(0, n);
    }

    public static String[] generateSuffixes(int n, int n2) {
        if (n2 == 0) {
            return NO_SUFFIX;
        }
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = Integer.toString(i + n) + "_";
        }
        return stringArray;
    }
}

