/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.FetchMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.PropertyPath;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;

public abstract class AbstractEntityJoinWalker
extends JoinWalker {
    private final OuterJoinLoadable persister;
    private final String alias;

    public AbstractEntityJoinWalker(OuterJoinLoadable outerJoinLoadable, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        this(outerJoinLoadable, sessionFactoryImplementor, loadQueryInfluencers, null);
    }

    public AbstractEntityJoinWalker(OuterJoinLoadable outerJoinLoadable, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers, String string) {
        super(sessionFactoryImplementor, loadQueryInfluencers);
        this.persister = outerJoinLoadable;
        this.alias = string == null ? this.generateRootAlias(outerJoinLoadable.getEntityName()) : string;
    }

    protected final void initAll(String string, String string2, LockOptions lockOptions) throws MappingException {
        this.initAll(string, string2, lockOptions, JoinWalker.AssociationInitCallback.NO_CALLBACK);
    }

    protected final void initAll(String string, String string2, LockOptions lockOptions, JoinWalker.AssociationInitCallback associationInitCallback) throws MappingException {
        this.walkEntityTree(this.persister, this.getAlias());
        ArrayList<OuterJoinableAssociation> arrayList = new ArrayList<OuterJoinableAssociation>();
        arrayList.addAll(this.associations);
        arrayList.add(OuterJoinableAssociation.createRoot(this.persister.getEntityType(), this.alias, this.getFactory()));
        this.initPersisters(arrayList, lockOptions, associationInitCallback);
        this.initStatementString(string, string2, lockOptions);
    }

    protected final void initProjection(String string, String string2, String string3, String string4, LockOptions lockOptions) throws MappingException {
        this.walkEntityTree(this.persister, this.getAlias());
        this.persisters = new Loadable[0];
        this.initStatementString(string, string2, string3, string4, lockOptions);
    }

    private void initStatementString(String string, String string2, LockOptions lockOptions) throws MappingException {
        this.initStatementString(null, string, string2, "", lockOptions);
    }

    private void initStatementString(String string, String string2, String string3, String string4, LockOptions lockOptions) throws MappingException {
        int n = AbstractEntityJoinWalker.countEntityPersisters(this.associations);
        this.suffixes = BasicLoader.generateSuffixes(n + 1);
        JoinFragment joinFragment = this.mergeOuterJoins(this.associations);
        Select select = new Select(this.getDialect()).setLockOptions(lockOptions).setSelectClause(string == null ? this.persister.selectFragment(this.alias, this.suffixes[n]) + this.selectString(this.associations) : string).setFromClause(this.getDialect().appendLockHint(lockOptions, this.persister.fromTableFragment(this.alias)) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(string2).setOuterJoins(joinFragment.toFromFragmentString(), joinFragment.toWhereFragmentString() + this.getWhereFragment()).setOrderByClause(this.orderBy(this.associations, string3)).setGroupByClause(string4);
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment(this.getComment());
        }
        this.sql = select.toStatementString();
    }

    protected String getWhereFragment() throws MappingException {
        return this.persister.whereJoinFragment(this.alias, true, true);
    }

    protected boolean isJoinedFetchEnabled(AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle) {
        return this.isJoinedFetchEnabledInMapping(fetchMode, associationType);
    }

    protected final boolean isJoinFetchEnabledByProfile(OuterJoinLoadable outerJoinLoadable, PropertyPath propertyPath, int n) {
        String string;
        if (!this.getLoadQueryInfluencers().hasEnabledFetchProfiles()) {
            return false;
        }
        String string2 = propertyPath.getFullPath();
        int n2 = string2.lastIndexOf(string = outerJoinLoadable.getSubclassPropertyName(n));
        String string3 = n2 >= 0 ? string2.substring(n2) : string;
        String string4 = outerJoinLoadable.getEntityName() + "." + string3;
        for (String string5 : this.getLoadQueryInfluencers().getEnabledFetchProfileNames()) {
            FetchProfile fetchProfile = this.getFactory().getFetchProfile(string5);
            Fetch fetch = fetchProfile.getFetchByRole(string4);
            if (fetch == null || Fetch.Style.JOIN != fetch.getStyle()) continue;
            return true;
        }
        return false;
    }

    public abstract String getComment();

    protected boolean isDuplicateAssociation(String string, String[] stringArray) {
        boolean bl = this.persister.getTableName().equals(string) && Arrays.equals(stringArray, this.persister.getKeyColumnNames());
        return bl || super.isDuplicateAssociation(string, stringArray);
    }

    public final Loadable getPersister() {
        return this.persister;
    }

    public final String getAlias() {
        return this.alias;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getPersister().getEntityName() + ')';
    }
}

