/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jmx.HibernateService;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.service.jndi.internal.JndiServiceImpl;
import org.hibernate.stat.Statistics;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SessionFactoryStub
implements SessionFactory {
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SessionFactoryStub.class.getName());
    private transient SessionFactory impl;
    private transient HibernateService service;
    private String uuid;
    private String name;

    SessionFactoryStub(HibernateService hibernateService) {
        this.service = hibernateService;
        this.name = hibernateService.getJndiName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, ConfigurationHelper.getBoolean("hibernate.session_factory_name_is_jndi", hibernateService.getProperties(), true), this, new JndiServiceImpl(hibernateService.getProperties()));
    }

    @Override
    public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
        return this.impl.getSessionFactoryOptions();
    }

    @Override
    public SessionBuilder withOptions() {
        return this.getImpl().withOptions();
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.getImpl().openSession();
    }

    @Override
    public Session getCurrentSession() {
        return this.getImpl().getCurrentSession();
    }

    private synchronized SessionFactory getImpl() {
        if (this.impl == null) {
            this.impl = this.service.buildSessionFactory();
        }
        return this.impl;
    }

    private Object readResolve() throws ObjectStreamException {
        SessionFactory sessionFactory = SessionFactoryRegistry.INSTANCE.getSessionFactory(this.uuid);
        if (sessionFactory == null) {
            sessionFactory = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(this.name);
            if (sessionFactory == null) {
                throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + this.uuid + ",name=" + this.name + "]");
            }
            LOG.debug("Resolved stub SessionFactory by name");
        } else {
            LOG.debug("Resolved stub SessionFactory by UUID");
        }
        return sessionFactory;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(SessionFactoryStub.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    @Override
    public ClassMetadata getClassMetadata(Class clazz) throws HibernateException {
        return this.getImpl().getClassMetadata(clazz);
    }

    @Override
    public ClassMetadata getClassMetadata(String string) throws HibernateException {
        return this.getImpl().getClassMetadata(string);
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String string) throws HibernateException {
        return this.getImpl().getCollectionMetadata(string);
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.getImpl().getAllClassMetadata();
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getImpl().getAllCollectionMetadata();
    }

    @Override
    public void close() throws HibernateException {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Cache getCache() {
        return this.getImpl().getCache();
    }

    @Override
    public void evict(Class clazz, Serializable serializable) throws HibernateException {
        this.getImpl().evict(clazz, serializable);
    }

    @Override
    public void evict(Class clazz) throws HibernateException {
        this.getImpl().evict(clazz);
    }

    @Override
    public void evictEntity(String string, Serializable serializable) throws HibernateException {
        this.getImpl().evictEntity(string, serializable);
    }

    @Override
    public void evictEntity(String string) throws HibernateException {
        this.getImpl().evictEntity(string);
    }

    @Override
    public void evictCollection(String string, Serializable serializable) throws HibernateException {
        this.getImpl().evictCollection(string, serializable);
    }

    @Override
    public void evictCollection(String string) throws HibernateException {
        this.getImpl().evictCollection(string);
    }

    @Override
    public void evictQueries() throws HibernateException {
        this.getImpl().evictQueries();
    }

    @Override
    public void evictQueries(String string) throws HibernateException {
        this.getImpl().evictQueries(string);
    }

    @Override
    public Statistics getStatistics() {
        return this.getImpl().getStatistics();
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return this.getImpl().withStatelessOptions();
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.getImpl().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.getImpl().openStatelessSession(connection);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.getImpl().getDefinedFilterNames();
    }

    @Override
    public FilterDefinition getFilterDefinition(String string) throws HibernateException {
        return this.getImpl().getFilterDefinition(string);
    }

    @Override
    public boolean containsFetchProfileDefinition(String string) {
        return this.getImpl().containsFetchProfileDefinition(string);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.getImpl().getTypeHelper();
    }
}

