/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.ExternalSessionFactoryConfig;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.jmx.HibernateServiceMBean;
import org.hibernate.jmx.SessionFactoryStub;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jboss.logging.Logger;

@Deprecated
public class HibernateService
extends ExternalSessionFactoryConfig
implements HibernateServiceMBean {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, HibernateService.class.getName());
    private String boundName;
    private Properties properties = new Properties();

    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.buildSessionFactory();
        }
        catch (HibernateException hibernateException) {
            LOG.unableToBuildSessionFactoryUsingMBeanClasspath(hibernateException.getMessage());
            LOG.debug("Error was", hibernateException);
            new SessionFactoryStub(this);
        }
    }

    public void stop() {
        LOG.stoppingService();
        try {
            InitialContext initialContext = JndiHelper.getInitialContext(this.buildProperties());
            ((SessionFactory)initialContext.lookup(this.boundName)).close();
        }
        catch (Exception exception) {
            LOG.unableToStopHibernateService(exception);
        }
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        LOG.startingServiceAtJndiName(this.boundName);
        LOG.serviceProperties(this.properties);
        return this.buildConfiguration().buildSessionFactory(new ServiceRegistryBuilder().applySettings(this.properties).buildServiceRegistry());
    }

    protected Map getExtraProperties() {
        return this.properties;
    }

    public String getTransactionStrategy() {
        return this.getProperty("hibernate.transaction.factory_class");
    }

    public void setTransactionStrategy(String string) {
        this.setProperty("hibernate.transaction.factory_class", string);
    }

    public String getUserTransactionName() {
        return this.getProperty("jta.UserTransaction");
    }

    public void setUserTransactionName(String string) {
        this.setProperty("jta.UserTransaction", string);
    }

    public String getJtaPlatformName() {
        return this.getProperty("hibernate.transaction.jta.platform");
    }

    public void setJtaPlatformName(String string) {
        this.setProperty("hibernate.transaction.jta.platform", string);
    }

    public String getPropertyList() {
        return this.buildProperties().toString();
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void dropSchema() {
        new SchemaExport(this.buildConfiguration()).drop(false, true);
    }

    public void createSchema() {
        new SchemaExport(this.buildConfiguration()).create(false, true);
    }

    public String getName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public String getDatasource() {
        return this.getProperty("hibernate.connection.datasource");
    }

    public void setDatasource(String string) {
        this.setProperty("hibernate.connection.datasource", string);
    }

    public String getJndiName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    public void setJndiName(String string) {
        this.setProperty("hibernate.session_factory_name", string);
    }

    public String getUserName() {
        return this.getProperty("hibernate.connection.username");
    }

    public void setUserName(String string) {
        this.setProperty("hibernate.connection.username", string);
    }

    public String getPassword() {
        return this.getProperty("hibernate.connection.password");
    }

    public void setPassword(String string) {
        this.setProperty("hibernate.connection.password", string);
    }

    public void setFlushBeforeCompletionEnabled(String string) {
        this.setProperty("hibernate.transaction.flush_before_completion", string);
    }

    public String getFlushBeforeCompletionEnabled() {
        return this.getProperty("hibernate.transaction.flush_before_completion");
    }

    public void setAutoCloseSessionEnabled(String string) {
        this.setProperty("hibernate.transaction.auto_close_session", string);
    }

    public String getAutoCloseSessionEnabled() {
        return this.getProperty("hibernate.transaction.auto_close_session");
    }

    public Properties getProperties() {
        return this.buildProperties();
    }
}

