/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.xml;

import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.hibernate.InvalidMappingException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.xml.ErrorLogger;
import org.hibernate.internal.util.xml.Origin;
import org.hibernate.internal.util.xml.XmlDocument;
import org.hibernate.internal.util.xml.XmlDocumentImpl;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MappingReader {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, MappingReader.class.getName());
    public static final MappingReader INSTANCE = new MappingReader();

    private MappingReader() {
    }

    public XmlDocument readMappingDocument(EntityResolver entityResolver, InputSource inputSource, Origin origin) {
        ErrorLogger errorLogger = new ErrorLogger();
        SAXReader sAXReader = new SAXReader();
        sAXReader.setEntityResolver(entityResolver);
        sAXReader.setErrorHandler(errorLogger);
        sAXReader.setMergeAdjacentText(true);
        sAXReader.setValidation(true);
        Document document = null;
        try {
            this.setValidationFor(sAXReader, "orm_2_0.xsd");
            document = sAXReader.read(inputSource);
            if (errorLogger.hasErrors()) {
                throw errorLogger.getErrors().get(0);
            }
            return new XmlDocumentImpl(document, origin.getType(), origin.getName());
        }
        catch (Exception exception) {
            Exception exception2;
            block8: {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Problem parsing XML using orm 2 xsd : %s", (Object)exception.getMessage());
                }
                exception2 = exception;
                errorLogger.reset();
                if (document != null) {
                    try {
                        this.setValidationFor(sAXReader, "orm_1_0.xsd");
                        document = sAXReader.read(new StringReader(document.asXML()));
                        if (errorLogger.hasErrors()) {
                            errorLogger.logErrors();
                            throw errorLogger.getErrors().get(0);
                        }
                        return new XmlDocumentImpl(document, origin.getType(), origin.getName());
                    }
                    catch (Exception exception3) {
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debugf("Problem parsing XML using orm 1 xsd : %s", (Object)exception3.getMessage());
                    }
                }
            }
            throw new InvalidMappingException("Unable to read XML", origin.getType(), origin.getName(), exception2);
        }
    }

    private void setValidationFor(SAXReader sAXReader, String string) {
        try {
            sAXReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            sAXReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://java.sun.com/xml/ns/persistence/orm " + string);
        }
        catch (SAXException sAXException) {
            sAXReader.setValidation(false);
        }
    }
}

