/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLogger
implements ErrorHandler,
Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ErrorLogger.class.getName());
    private List<SAXParseException> errors;
    private String file;

    public ErrorLogger() {
    }

    public ErrorLogger(String string) {
        this.file = string;
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        if (this.errors == null) {
            this.errors = new ArrayList<SAXParseException>();
        }
        this.errors.add(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        this.error(sAXParseException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        LOG.parsingXmlWarning(sAXParseException.getLineNumber(), sAXParseException.getMessage());
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public void reset() {
        this.errors = null;
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    public void logErrors() {
        if (this.errors != null) {
            for (SAXParseException sAXParseException : this.errors) {
                if (this.file == null) {
                    LOG.parsingXmlError(sAXParseException.getLineNumber(), sAXParseException.getMessage());
                    continue;
                }
                LOG.parsingXmlErrorForFile(this.file, sAXParseException.getLineNumber(), sAXParseException.getMessage());
            }
        }
    }
}

