/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.xml;

import java.io.InputStream;
import java.io.Serializable;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ConfigHelper;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DTDEntityResolver.class.getName());
    private static final String HIBERNATE_NAMESPACE = "http://www.hibernate.org/dtd/";
    private static final String OLD_HIBERNATE_NAMESPACE = "http://hibernate.sourceforge.net/";
    private static final String USER_NAMESPACE = "classpath://";

    public InputSource resolveEntity(String string, String string2) {
        InputSource inputSource = null;
        if (string2 != null) {
            LOG.debugf("Trying to resolve system-id [%s]", (Object)string2);
            if (string2.startsWith(HIBERNATE_NAMESPACE)) {
                LOG.debug("Recognized hibernate namespace; attempting to resolve on classpath under org/hibernate/");
                inputSource = this.resolveOnClassPath(string, string2, HIBERNATE_NAMESPACE);
            } else if (string2.startsWith(OLD_HIBERNATE_NAMESPACE)) {
                LOG.recognizedObsoleteHibernateNamespace(OLD_HIBERNATE_NAMESPACE, HIBERNATE_NAMESPACE);
                LOG.debug("Attempting to resolve on classpath under org/hibernate/");
                inputSource = this.resolveOnClassPath(string, string2, OLD_HIBERNATE_NAMESPACE);
            } else if (string2.startsWith(USER_NAMESPACE)) {
                LOG.debug("Recognized local namespace; attempting to resolve on classpath");
                String string3 = string2.substring(USER_NAMESPACE.length());
                InputStream inputStream = this.resolveInLocalNamespace(string3);
                if (inputStream == null) {
                    LOG.debugf("Unable to locate [%s] on classpath", (Object)string2);
                } else {
                    LOG.debugf("Located [%s] in classpath", (Object)string2);
                    inputSource = new InputSource(inputStream);
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                }
            }
        }
        return inputSource;
    }

    private InputSource resolveOnClassPath(String string, String string2, String string3) {
        InputSource inputSource = null;
        String string4 = "org/hibernate/" + string2.substring(string3.length());
        InputStream inputStream = this.resolveInHibernateNamespace(string4);
        if (inputStream == null) {
            LOG.debugf("Unable to locate [%s] on classpath", (Object)string2);
            if (string2.substring(string3.length()).indexOf("2.0") > -1) {
                LOG.usingOldDtd();
            }
        } else {
            LOG.debugf("Located [%s] in classpath", (Object)string2);
            inputSource = new InputSource(inputStream);
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
        }
        return inputSource;
    }

    protected InputStream resolveInHibernateNamespace(String string) {
        return this.getClass().getClassLoader().getResourceAsStream(string);
    }

    protected InputStream resolveInLocalNamespace(String string) {
        try {
            return ConfigHelper.getUserResourceAsStream(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

