/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

@Deprecated
public final class JndiHelper {
    private JndiHelper() {
    }

    public static Properties extractJndiProperties(Map map) {
        Properties properties = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) continue;
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (!string.startsWith("hibernate.jndi")) continue;
            if ("hibernate.jndi.class".equals(string)) {
                if (v == null) continue;
                properties.put("java.naming.factory.initial", v);
                continue;
            }
            if ("hibernate.jndi.url".equals(string)) {
                if (v == null) continue;
                properties.put("java.naming.provider.url", v);
                continue;
            }
            String string2 = string.substring("hibernate.jndi".length() + 1);
            properties.put(string2, v);
        }
        return properties;
    }

    public static InitialContext getInitialContext(Properties properties) throws NamingException {
        Properties properties2 = JndiHelper.extractJndiProperties(properties);
        return ((Hashtable)properties2).size() == 0 ? new InitialContext() : new InitialContext(properties2);
    }

    public static void bind(Context context, String string, Object object) throws NamingException {
        try {
            context.rebind(string, object);
        }
        catch (Exception exception) {
            Name name = context.getNameParser("").parse(string);
            while (name.size() > 1) {
                String string2 = name.get(0);
                Context context2 = null;
                try {
                    context2 = (Context)context.lookup(string2);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                context = context2 != null ? context2 : context.createSubcontext(string2);
                name = name.getSuffix(1);
            }
            context.rebind(name, object);
        }
    }
}

