/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.config.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationHelper {
    private static final String PLACEHOLDER_START = "${";

    private ConfigurationHelper() {
    }

    public static String getString(String string, Map map) {
        Object v = map.get(string);
        if (v == null) {
            return null;
        }
        if (String.class.isInstance(v)) {
            return (String)v;
        }
        return v.toString();
    }

    public static String getString(String string, Map map, String string2) {
        String string3 = ConfigurationHelper.getString(string, map);
        return string3 == null ? string2 : string3;
    }

    public static String getString(String string, Map map, String string2, String ... stringArray) {
        String string3 = ConfigurationHelper.getString(string, map, string2);
        if (!string2.equals(string3) && ArrayHelper.indexOf(stringArray, string3) == -1) {
            throw new ConfigurationException("Unsupported configuration [name=" + string + ", value=" + string3 + "]. " + "Choose value between: '" + string2 + "', '" + StringHelper.join("', '", stringArray) + "'.");
        }
        return string3;
    }

    public static boolean getBoolean(String string, Map map) {
        return ConfigurationHelper.getBoolean(string, map, false);
    }

    public static boolean getBoolean(String string, Map map, boolean bl) {
        Object v = map.get(string);
        if (v == null) {
            return bl;
        }
        if (Boolean.class.isInstance(v)) {
            return (Boolean)v;
        }
        if (String.class.isInstance(v)) {
            return Boolean.parseBoolean((String)v);
        }
        throw new ConfigurationException("Could not determine how to handle configuration value [name=" + string + ", value=" + v + "] as boolean");
    }

    public static int getInt(String string, Map map, int n) {
        Object v = map.get(string);
        if (v == null) {
            return n;
        }
        if (Integer.class.isInstance(v)) {
            return (Integer)v;
        }
        if (String.class.isInstance(v)) {
            return Integer.parseInt((String)v);
        }
        throw new ConfigurationException("Could not determine how to handle configuration value [name=" + string + ", value=" + v + "(" + v.getClass().getName() + ")] as int");
    }

    public static Integer getInteger(String string, Map map) {
        Object v = map.get(string);
        if (v == null) {
            return null;
        }
        if (Integer.class.isInstance(v)) {
            return (Integer)v;
        }
        if (String.class.isInstance(v)) {
            String string2 = v.toString().trim();
            if (string2.isEmpty()) {
                return null;
            }
            return Integer.valueOf(string2);
        }
        throw new ConfigurationException("Could not determine how to handle configuration value [name=" + string + ", value=" + v + "(" + v.getClass().getName() + ")] as Integer");
    }

    public static Map clone(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        if (Properties.class.isInstance(map)) {
            return (Properties)((Properties)map).clone();
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static Properties maskOut(Properties properties, String string) {
        Properties properties2 = (Properties)properties.clone();
        if (properties2.get(string) != null) {
            properties2.setProperty(string, "****");
        }
        return properties2;
    }

    public static String extractPropertyValue(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        if (StringHelper.isEmpty(string2 = string2.trim())) {
            return null;
        }
        return string2;
    }

    public static Map toMap(String string, String string2, Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = ConfigurationHelper.extractPropertyValue(string, properties);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            while (stringTokenizer.hasMoreTokens()) {
                hashMap.put(stringTokenizer.nextToken(), stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : "");
            }
        }
        return hashMap;
    }

    public static String[] toStringArray(String string, String string2, Properties properties) {
        return ConfigurationHelper.toStringArray(ConfigurationHelper.extractPropertyValue(string, properties), string2);
    }

    public static String[] toStringArray(String string, String string2) {
        if (string != null) {
            return StringHelper.split(string2, string);
        }
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public static void resolvePlaceHolders(Map<?, ?> map) {
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry<?, ?> entry = iterator.next();
            Object obj = entry.getValue();
            if (obj == null || !String.class.isInstance(obj) || obj.equals(string = ConfigurationHelper.resolvePlaceHolder((String)obj))) continue;
            if (string == null) {
                iterator.remove();
                continue;
            }
            entry.setValue(string);
        }
    }

    public static String resolvePlaceHolder(String string) {
        String string2;
        if (string.indexOf(PLACEHOLDER_START) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '$' && cArray[i + 1] == '{') {
                int n;
                String string3 = "";
                for (n = i + 2; n < cArray.length && cArray[n] != '}'; ++n) {
                    string3 = string3 + cArray[n];
                    if (n != cArray.length - 1) continue;
                    throw new IllegalArgumentException("unmatched placeholder start [" + string + "]");
                }
                String string4 = ConfigurationHelper.extractFromSystem(string3);
                stringBuilder.append(string4 == null ? "" : string4);
                i = n + 1;
                if (i >= cArray.length) break;
            }
            stringBuilder.append(cArray[i]);
        }
        return StringHelper.isEmpty(string2 = stringBuilder.toString()) ? null : string2;
    }

    private static String extractFromSystem(String string) {
        try {
            return System.getProperty(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

