/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentityMap<K, V>
implements Map<K, V> {
    private final Map<IdentityKey<K>, V> map;
    private transient Map.Entry<IdentityKey<K>, V>[] entryArray = new Map.Entry[0];
    private transient boolean dirty = false;

    public static <K, V> IdentityMap<K, V> instantiateSequenced(int n) {
        return new IdentityMap(new LinkedHashMap(n));
    }

    private IdentityMap(Map<IdentityKey<K>, V> map) {
        this.map = map;
        this.dirty = true;
    }

    public static <K, V> Map.Entry<K, V>[] concurrentEntries(Map<K, V> map) {
        return ((IdentityMap)map).entryArray();
    }

    public Iterator<K> keyIterator() {
        return new KeyIterator(this.map.keySet().iterator());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(new IdentityKey<Object>(object));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.map.get(new IdentityKey<Object>(object));
    }

    @Override
    public V put(K k, V v) {
        this.dirty = true;
        return this.map.put(new IdentityKey<K>(k), v);
    }

    @Override
    public V remove(Object object) {
        this.dirty = true;
        return this.map.remove(new IdentityKey<Object>(object));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.dirty = true;
        this.entryArray = null;
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>(this.map.size());
        for (Map.Entry<IdentityKey<K>, V> entry : this.map.entrySet()) {
            hashSet.add(new IdentityMapEntry<K, V>(entry.getKey().getRealKey(), entry.getValue()));
        }
        return hashSet;
    }

    public Map.Entry[] entryArray() {
        if (this.dirty) {
            this.entryArray = new Map.Entry[this.map.size()];
            Iterator<Map.Entry<IdentityKey<K>, V>> iterator = this.map.entrySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry<IdentityKey<K>, V> entry = iterator.next();
                this.entryArray[n++] = new IdentityMapEntry<Object, V>(((IdentityKey)entry.getKey()).key, entry.getValue());
            }
            this.dirty = false;
        }
        return this.entryArray;
    }

    public String toString() {
        return this.map.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IdentityKey<K>
    implements Serializable {
        private final K key;
        private int hash = 0;

        IdentityKey(K k) {
            this.key = k;
        }

        public boolean equals(Object object) {
            return this.key == ((IdentityKey)object).key;
        }

        public int hashCode() {
            if (this.hash == 0) {
                int n = System.identityHashCode(this.key);
                if (n == 0) {
                    this.hash = -1;
                    return -1;
                }
                this.hash = n;
                return n;
            }
            return this.hash;
        }

        public String toString() {
            return this.key.toString();
        }

        public K getRealKey() {
            return this.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IdentityMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        IdentityMapEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class KeyIterator<K>
    implements Iterator<K> {
        private final Iterator<IdentityKey<K>> identityKeyIterator;

        private KeyIterator(Iterator<IdentityKey<K>> iterator) {
            this.identityKeyIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.identityKeyIterator.hasNext();
        }

        @Override
        public K next() {
            return this.identityKeyIterator.next().getRealKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

