/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionHelper {
    public static final int MINIMUM_INITIAL_CAPACITY = 16;
    public static final float LOAD_FACTOR = 0.75f;
    @Deprecated
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;
    @Deprecated
    public static final Collection EMPTY_COLLECTION = Collections.EMPTY_LIST;
    @Deprecated
    public static final Map EMPTY_MAP = Collections.EMPTY_MAP;

    private CollectionHelper() {
    }

    public static <K, V> Map<K, V> mapOfSize(int n) {
        return new HashMap(CollectionHelper.determineProperSizing(n), 0.75f);
    }

    public static int determineProperSizing(Map map) {
        return CollectionHelper.determineProperSizing(map.size());
    }

    public static int determineProperSizing(Set set) {
        return CollectionHelper.determineProperSizing(set.size());
    }

    public static int determineProperSizing(int n) {
        int n2 = (int)((float)n / 0.75f) + 1;
        return Math.max(n2, 16);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int n) {
        return CollectionHelper.concurrentMap(n, 0.75f);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int n, float f) {
        int n2 = n + 1 + (int)((float)n * f);
        return new ConcurrentHashMap(n2, f);
    }

    public static <T> List<T> arrayList(int n) {
        return new ArrayList(n);
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionHelper.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map map) {
        return !CollectionHelper.isEmpty(map);
    }
}

