/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_MAXIMUM_CAPACITY = 512;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;

    private static int hash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    final Segment<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    public BoundedConcurrentHashMap(int n, int n2, Eviction eviction, EvictionListener<K, V> evictionListener) {
        int n3;
        int n4;
        if (n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        n2 = Math.min(n / 2, n2);
        if (n < (n2 = Math.max(n2, 1)) * 2 && n != 1) {
            throw new IllegalArgumentException("Maximum capacity has to be at least twice the concurrencyLevel");
        }
        if (eviction == null || evictionListener == null) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n5 = 0;
        for (n4 = 1; n4 < n2; n4 <<= 1) {
            ++n5;
        }
        this.segmentShift = 32 - n5;
        this.segmentMask = n4 - 1;
        this.segments = Segment.newArray(n4);
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        int n6 = n / n4;
        for (n3 = 1; n3 < n6; n3 <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment<K, V>(n3, n6, 0.75f, eviction, evictionListener);
        }
    }

    public BoundedConcurrentHashMap(int n, int n2) {
        this(n, n2, Eviction.LRU);
    }

    public BoundedConcurrentHashMap(int n, int n2, Eviction eviction) {
        this(n, n2, eviction, new NullEvictionListener());
    }

    public BoundedConcurrentHashMap(int n) {
        this(n, 16);
    }

    public BoundedConcurrentHashMap() {
        this(512, 16);
    }

    @Override
    public boolean isEmpty() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n2 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) {
                return false;
            }
            nArray[n] = segmentArray[n].modCount;
            n2 += nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n = 0; n < 2; ++n) {
            int n2;
            l2 = 0L;
            l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l += (long)segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    l2 += (long)segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    l2 = -1L;
                    break;
                }
            }
            if (l2 == l) break;
        }
        if (l2 != l) {
            l = 0L;
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].lock();
            }
            try {
                for (n = 0; n < segmentArray.length; ++n) {
                    l += (long)segmentArray[n].count;
                }
            }
            finally {
                for (n = 0; n < segmentArray.length; ++n) {
                    segmentArray[n].unlock();
                }
            }
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public V get(Object object) {
        int n = BoundedConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).get(object, n);
    }

    @Override
    public boolean containsKey(Object object) {
        int n = BoundedConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).containsKey(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        int n;
        boolean bl;
        if (object == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (bl = false; bl < 2 != 0; bl += 1) {
            int n2;
            int n3;
            n = 0;
            for (n3 = 0; n3 < segmentArray.length; ++n3) {
                n2 = segmentArray[n3].count;
                nArray[n3] = segmentArray[n3].modCount;
                n += nArray[n3];
                if (!segmentArray[n3].containsValue(object)) continue;
                return true;
            }
            n3 = 1;
            if (n != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    int n4 = segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    n3 = 0;
                    break;
                }
            }
            if (n3 == 0) continue;
            return false;
        }
        for (bl = false; bl < segmentArray.length; bl += 1) {
            segmentArray[bl].lock();
        }
        bl = false;
        try {
            for (n = 0; n < segmentArray.length; ++n) {
                if (!segmentArray[n].containsValue(object)) continue;
                bl = true;
                break;
            }
        }
        finally {
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        return bl;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = BoundedConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).put(k, n, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = BoundedConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).put(k, n, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = BoundedConcurrentHashMap.hash(object.hashCode());
        return this.segmentFor(n).remove(object, n, null);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n = BoundedConcurrentHashMap.hash(object.hashCode());
        if (object2 == null) {
            return false;
        }
        return this.segmentFor(n).remove(object, n, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (v == null || v2 == null) {
            throw new NullPointerException();
        }
        int n = BoundedConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = BoundedConcurrentHashMap.hash(k.hashCode());
        return this.segmentFor(n).replace(k, n, v);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.segments.length; ++i) {
            Segment<K, V> segment = this.segments[i];
            segment.lock();
            try {
                HashEntry<K, V>[] hashEntryArray = segment.table;
                for (int j = 0; j < hashEntryArray.length; ++j) {
                    HashEntry hashEntry = hashEntryArray[j];
                    while (hashEntry != null) {
                        objectOutputStream.writeObject(hashEntry.key);
                        objectOutputStream.writeObject(hashEntry.value);
                        hashEntry = hashEntry.next;
                    }
                }
                continue;
            }
            finally {
                segment.unlock();
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setTable(new HashEntry[1]);
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = BoundedConcurrentHashMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return BoundedConcurrentHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return BoundedConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BoundedConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            BoundedConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return BoundedConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BoundedConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return BoundedConcurrentHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            BoundedConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return BoundedConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BoundedConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return BoundedConcurrentHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return BoundedConcurrentHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            BoundedConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key, hashEntry.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = -7041346694785573824L;

        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object v2 = super.setValue(v);
            BoundedConcurrentHashMap.this.put(this.getKey(), v);
            return v2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value;
        }

        @Override
        public V nextElement() {
            return super.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().key;
        }

        @Override
        public K nextElement() {
            return super.nextEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = BoundedConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = BoundedConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                for (int i = this.currentTable.length - 1; i >= 0; --i) {
                    this.nextEntry = this.currentTable[i];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            BoundedConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Segment<K, V>
    extends ReentrantLock {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;
        final int evictCap;
        final transient EvictionPolicy<K, V> eviction;
        final transient EvictionListener<K, V> evictionListener;

        Segment(int n, int n2, float f, Eviction eviction, EvictionListener<K, V> evictionListener) {
            this.loadFactor = f;
            this.evictCap = n2;
            this.eviction = eviction.make(this, n2, f);
            this.evictionListener = evictionListener;
            this.setTable(HashEntry.newArray(n));
        }

        static <K, V> Segment<K, V>[] newArray(int n) {
            return new Segment[n];
        }

        EvictionListener<K, V> getEvictionListener() {
            return this.evictionListener;
        }

        void setTable(HashEntry<K, V>[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
        }

        HashEntry<K, V> getFirst(int n) {
            HashEntry<K, V>[] hashEntryArray = this.table;
            return hashEntryArray[n & hashEntryArray.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                Object v = hashEntry.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object object, int n) {
            int n2 = this.count;
            if (n2 != 0) {
                Set<HashEntry<K, V>> set;
                Set<HashEntry<K, V>> set2 = null;
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key)) {
                        set = hashEntry.value;
                        if (set != null) {
                            set2 = set;
                            break;
                        }
                        set2 = this.readValueUnderLock(hashEntry);
                        break;
                    }
                    hashEntry = hashEntry.next;
                }
                if (set2 != null && this.eviction.onEntryHit(hashEntry)) {
                    set = this.attemptEviction(false);
                    this.notifyEvictionListener(set);
                }
                return (V)set2;
            }
            return null;
        }

        boolean containsKey(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key)) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        boolean containsValue(Object object) {
            if (this.count != 0) {
                for (HashEntry<K, V> hashEntry : this.table) {
                    while (hashEntry != null) {
                        Object v = hashEntry.value;
                        if (v == null) {
                            v = this.readValueUnderLock(hashEntry);
                        }
                        if (object.equals(v)) {
                            return true;
                        }
                        hashEntry = hashEntry.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k, int n, V v, V v2) {
            this.lock();
            Set<HashEntry<K, V>> set = null;
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && k.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl = false;
                if (hashEntry != null && v.equals(hashEntry.value)) {
                    bl = true;
                    hashEntry.value = v2;
                    if (this.eviction.onEntryHit(hashEntry)) {
                        set = this.attemptEviction(true);
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.unlock();
                this.notifyEvictionListener(set);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k, int n, V v) {
            this.lock();
            Set<HashEntry<K, V>> set = null;
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && k.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                V v2 = null;
                if (hashEntry != null) {
                    v2 = hashEntry.value;
                    hashEntry.value = v;
                    if (this.eviction.onEntryHit(hashEntry)) {
                        set = this.attemptEviction(true);
                    }
                }
                V v3 = v2;
                return v3;
            }
            finally {
                this.unlock();
                this.notifyEvictionListener(set);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k, int n, V v, boolean bl) {
            this.lock();
            Set<HashEntry<K, V>> set = null;
            try {
                Set<HashEntry<K, V>> set2;
                Set<HashEntry<K, V>> set3;
                HashEntry<K, V> hashEntry;
                int n2 = this.count;
                if (n2++ > this.threshold && this.eviction.strategy() == Eviction.NONE) {
                    this.rehash();
                }
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n3];
                while (!(hashEntry2 == null || hashEntry2.hash == n && k.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    set3 = (Set<HashEntry<K, V>>)hashEntry2.value;
                    if (!bl) {
                        hashEntry2.value = v;
                        this.eviction.onEntryHit(hashEntry2);
                    }
                } else {
                    set3 = null;
                    ++this.modCount;
                    this.count = n2;
                    if (this.eviction.strategy() != Eviction.NONE) {
                        if (n2 > this.evictCap) {
                            set = this.eviction.execute();
                            hashEntry = hashEntryArray[n3];
                        }
                        hashEntryArray[n3] = this.eviction.createNewEntry(k, n, hashEntry, v);
                        set2 = this.eviction.onEntryMiss(hashEntryArray[n3]);
                        if (!set2.isEmpty()) {
                            if (set != null) {
                                set.addAll(set2);
                            } else {
                                set = set2;
                            }
                        }
                    } else {
                        hashEntryArray[n3] = this.eviction.createNewEntry(k, n, hashEntry, v);
                    }
                }
                set2 = set3;
                return (V)set2;
            }
            finally {
                this.unlock();
                this.notifyEvictionListener(set);
            }
        }

        void rehash() {
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n = hashEntryArray.length;
            if (n >= 0x40000000) {
                return;
            }
            HashEntry<K, V>[] hashEntryArray2 = HashEntry.newArray(n << 1);
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n2 = hashEntryArray2.length - 1;
            for (int i = 0; i < n; ++i) {
                int n3;
                HashEntry<K, V> hashEntry = hashEntryArray[i];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n4 = hashEntry.hash & n2;
                if (hashEntry2 == null) {
                    hashEntryArray2[n4] = hashEntry;
                    continue;
                }
                HashEntry<K, V> hashEntry3 = hashEntry;
                int n5 = n4;
                HashEntry hashEntry4 = hashEntry2;
                while (hashEntry4 != null) {
                    n3 = hashEntry4.hash & n2;
                    if (n3 != n5) {
                        n5 = n3;
                        hashEntry3 = hashEntry4;
                    }
                    hashEntry4 = hashEntry4.next;
                }
                hashEntryArray2[n5] = hashEntry3;
                hashEntry4 = hashEntry;
                while (hashEntry4 != hashEntry3) {
                    n3 = hashEntry4.hash & n2;
                    HashEntry hashEntry5 = hashEntryArray2[n3];
                    hashEntryArray2[n3] = this.eviction.createNewEntry(hashEntry4.key, hashEntry4.hash, hashEntry5, hashEntry4.value);
                    hashEntry4 = hashEntry4.next;
                }
            }
            this.table = hashEntryArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n, Object object2) {
            this.lock();
            try {
                V v;
                HashEntry<K, V> hashEntry;
                int n2 = this.count - 1;
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n3];
                while (!(hashEntry2 == null || hashEntry2.hash == n && object.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                V v2 = null;
                if (hashEntry2 != null) {
                    v = hashEntry2.value;
                    if (object2 == null || object2.equals(v)) {
                        v2 = v;
                        ++this.modCount;
                        this.eviction.onEntryRemove(hashEntry2);
                        HashEntry hashEntry3 = hashEntry2.next;
                        HashEntry<K, V> hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry2) {
                            this.eviction.onEntryRemove(hashEntry4);
                            hashEntry3 = this.eviction.createNewEntry(hashEntry4.key, hashEntry4.hash, hashEntry3, hashEntry4.value);
                            this.eviction.onEntryMiss(hashEntry3);
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray[n3] = hashEntry3;
                        this.count = n2;
                    }
                }
                v = v2;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    for (int i = 0; i < hashEntryArray.length; ++i) {
                        hashEntryArray[i] = null;
                    }
                    ++this.modCount;
                    this.eviction.clear();
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<HashEntry<K, V>> attemptEviction(boolean bl) {
            boolean bl2;
            Set<HashEntry<K, V>> set = null;
            boolean bl3 = bl2 = bl || this.tryLock();
            if (!bl2 && this.eviction.thresholdExpired()) {
                this.lock();
                bl2 = true;
            }
            if (bl2) {
                try {
                    if (this.eviction.thresholdExpired()) {
                        set = this.eviction.execute();
                    }
                }
                finally {
                    if (!bl) {
                        this.unlock();
                    }
                }
            }
            return set;
        }

        private void notifyEvictionListener(Set<HashEntry<K, V>> set) {
            if (set != null) {
                Map map;
                if (set.size() == 1) {
                    HashEntry<K, V> hashEntry = set.iterator().next();
                    map = Collections.singletonMap(hashEntry.key, hashEntry.value);
                } else {
                    map = new HashMap(set.size());
                    for (HashEntry<K, V> hashEntry : set) {
                        map.put(hashEntry.key, hashEntry.value);
                    }
                    map = Collections.unmodifiableMap(map);
                }
                this.evictionListener.onEntryEviction(map);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LIRS<K, V>
    implements EvictionPolicy<K, V> {
        private static final float L_LIRS = 0.95f;
        private final Segment<K, V> segment;
        private final ConcurrentLinkedQueue<LIRSHashEntry<K, V>> accessQueue;
        private final int maxBatchQueueSize;
        private int size;
        private final float batchThresholdFactor;
        private final LIRSHashEntry<K, V> header = new LIRSHashEntry<Object, Object>(null, null, 0, null, null);
        private final int maximumHotSize;
        private final int maximumSize;
        private int hotSize = 0;

        public LIRS(Segment<K, V> segment, int n, int n2, float f) {
            this.segment = segment;
            this.maximumSize = n;
            this.maximumHotSize = LIRS.calculateLIRSize(n);
            this.maxBatchQueueSize = n2 > 64 ? 64 : n2;
            this.batchThresholdFactor = f;
            this.accessQueue = new ConcurrentLinkedQueue();
        }

        private static int calculateLIRSize(int n) {
            int n2 = (int)(0.95f * (float)n);
            return n2 == n ? n - 1 : n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<HashEntry<K, V>> execute() {
            HashSet<HashEntry<K, V>> hashSet = new HashSet<HashEntry<K, V>>();
            try {
                for (LIRSHashEntry<K, V> lIRSHashEntry : this.accessQueue) {
                    if (!lIRSHashEntry.isResident()) continue;
                    lIRSHashEntry.hit(hashSet);
                }
                this.removeFromSegment(hashSet);
            }
            finally {
                this.accessQueue.clear();
            }
            return hashSet;
        }

        private void pruneStack(Set<HashEntry<K, V>> set) {
            LIRSHashEntry<K, V> lIRSHashEntry = this.stackBottom();
            while (lIRSHashEntry != null && lIRSHashEntry.state != Recency.LIR_RESIDENT) {
                ((LIRSHashEntry)lIRSHashEntry).removeFromStack();
                if (lIRSHashEntry.state == Recency.HIR_NONRESIDENT) {
                    set.add(lIRSHashEntry);
                }
                lIRSHashEntry = this.stackBottom();
            }
        }

        @Override
        public Set<HashEntry<K, V>> onEntryMiss(HashEntry<K, V> hashEntry) {
            LIRSHashEntry lIRSHashEntry = (LIRSHashEntry)hashEntry;
            Set set = lIRSHashEntry.miss();
            this.removeFromSegment(set);
            return set;
        }

        private void removeFromSegment(Set<HashEntry<K, V>> set) {
            for (HashEntry<K, V> hashEntry : set) {
                ((LIRSHashEntry)hashEntry).evict();
                this.segment.evictionListener.onEntryChosenForEviction(hashEntry.value);
                this.segment.remove(hashEntry.key, hashEntry.hash, null);
            }
        }

        @Override
        public boolean onEntryHit(HashEntry<K, V> hashEntry) {
            this.accessQueue.add((LIRSHashEntry)hashEntry);
            return (float)this.accessQueue.size() >= (float)this.maxBatchQueueSize * this.batchThresholdFactor;
        }

        @Override
        public boolean thresholdExpired() {
            return this.accessQueue.size() >= this.maxBatchQueueSize;
        }

        @Override
        public void onEntryRemove(HashEntry<K, V> hashEntry) {
            ((LIRSHashEntry)hashEntry).remove();
            while (this.accessQueue.remove(hashEntry)) {
            }
        }

        @Override
        public void clear() {
            this.accessQueue.clear();
        }

        @Override
        public Eviction strategy() {
            return Eviction.LIRS;
        }

        private LIRSHashEntry<K, V> stackBottom() {
            LIRSHashEntry lIRSHashEntry = ((LIRSHashEntry)this.header).previousInStack;
            return lIRSHashEntry == this.header ? null : lIRSHashEntry;
        }

        private LIRSHashEntry<K, V> queueFront() {
            LIRSHashEntry lIRSHashEntry = ((LIRSHashEntry)this.header).nextInQueue;
            return lIRSHashEntry == this.header ? null : lIRSHashEntry;
        }

        private LIRSHashEntry<K, V> queueEnd() {
            LIRSHashEntry lIRSHashEntry = ((LIRSHashEntry)this.header).previousInQueue;
            return lIRSHashEntry == this.header ? null : lIRSHashEntry;
        }

        @Override
        public HashEntry<K, V> createNewEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            return new LIRSHashEntry<K, V>(this, k, n, hashEntry, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LIRSHashEntry<K, V>
    extends HashEntry<K, V> {
        private LIRSHashEntry<K, V> previousInStack;
        private LIRSHashEntry<K, V> nextInStack;
        private LIRSHashEntry<K, V> previousInQueue;
        private LIRSHashEntry<K, V> nextInQueue;
        volatile Recency state;
        LIRS<K, V> owner;

        LIRSHashEntry(LIRS<K, V> lIRS, K k, int n, HashEntry<K, V> hashEntry, V v) {
            super(k, n, hashEntry, v);
            this.owner = lIRS;
            this.state = Recency.HIR_RESIDENT;
            this.previousInStack = this;
            this.nextInStack = this;
            this.previousInQueue = this;
            this.nextInQueue = this;
        }

        @Override
        public int hashCode() {
            int n = 17;
            n = n * 31 + this.hash;
            n = n * 31 + this.key.hashCode();
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            HashEntry hashEntry = (HashEntry)object;
            return this.hash == hashEntry.hash && this.key.equals(hashEntry.key);
        }

        public boolean inStack() {
            return this.nextInStack != null;
        }

        public boolean inQueue() {
            return this.nextInQueue != null;
        }

        public void hit(Set<HashEntry<K, V>> set) {
            switch (this.state) {
                case LIR_RESIDENT: {
                    this.hotHit(set);
                    break;
                }
                case HIR_RESIDENT: {
                    this.coldHit(set);
                    break;
                }
                case HIR_NONRESIDENT: {
                    throw new IllegalStateException("Can't hit a non-resident entry!");
                }
                default: {
                    throw new AssertionError((Object)("Hit with unknown status: " + (Object)((Object)this.state)));
                }
            }
        }

        private void hotHit(Set<HashEntry<K, V>> set) {
            boolean bl = ((LIRS)this.owner).stackBottom() == this;
            this.moveToStackTop();
            if (bl) {
                ((LIRS)this.owner).pruneStack(set);
            }
        }

        private void coldHit(Set<HashEntry<K, V>> set) {
            boolean bl = this.inStack();
            this.moveToStackTop();
            if (bl) {
                this.hot();
                this.removeFromQueue();
                ((LIRS)this.owner).stackBottom().migrateToQueue();
                ((LIRS)this.owner).pruneStack(set);
            } else {
                this.moveToQueueEnd();
            }
        }

        private Set<HashEntry<K, V>> miss() {
            Set<HashEntry<K, V>> set = Collections.emptySet();
            if (((LIRS)this.owner).hotSize < ((LIRS)this.owner).maximumHotSize) {
                this.warmupMiss();
            } else {
                set = new HashSet();
                this.fullMiss(set);
            }
            ((LIRS)this.owner).size++;
            return set;
        }

        private void warmupMiss() {
            this.hot();
            this.moveToStackTop();
        }

        private void fullMiss(Set<HashEntry<K, V>> set) {
            if (((LIRS)this.owner).size >= ((LIRS)this.owner).maximumSize) {
                LIRSHashEntry lIRSHashEntry = ((LIRS)this.owner).queueFront();
                set.add(lIRSHashEntry);
            }
            boolean bl = this.inStack();
            this.moveToStackTop();
            if (bl) {
                this.hot();
                ((LIRS)this.owner).stackBottom().migrateToQueue();
                ((LIRS)this.owner).pruneStack(set);
            } else {
                this.cold();
            }
        }

        private void hot() {
            if (this.state != Recency.LIR_RESIDENT) {
                ((LIRS)this.owner).hotSize++;
            }
            this.state = Recency.LIR_RESIDENT;
        }

        private void cold() {
            if (this.state == Recency.LIR_RESIDENT) {
                ((LIRS)this.owner).hotSize--;
            }
            this.state = Recency.HIR_RESIDENT;
            this.moveToQueueEnd();
        }

        private void nonResident() {
            switch (this.state) {
                case LIR_RESIDENT: {
                    ((LIRS)this.owner).hotSize--;
                }
                case HIR_RESIDENT: {
                    ((LIRS)this.owner).size--;
                }
            }
            this.state = Recency.HIR_NONRESIDENT;
        }

        public boolean isResident() {
            return this.state != Recency.HIR_NONRESIDENT;
        }

        private void tempRemoveFromStack() {
            if (this.inStack()) {
                this.previousInStack.nextInStack = this.nextInStack;
                this.nextInStack.previousInStack = this.previousInStack;
            }
        }

        private void removeFromStack() {
            this.tempRemoveFromStack();
            this.previousInStack = null;
            this.nextInStack = null;
        }

        private void addToStackBefore(LIRSHashEntry<K, V> lIRSHashEntry) {
            this.previousInStack = lIRSHashEntry.previousInStack;
            this.nextInStack = lIRSHashEntry;
            this.previousInStack.nextInStack = this;
            this.nextInStack.previousInStack = this;
        }

        private void moveToStackTop() {
            this.tempRemoveFromStack();
            this.addToStackBefore(((LIRS)this.owner).header.nextInStack);
        }

        private void moveToStackBottom() {
            this.tempRemoveFromStack();
            this.addToStackBefore(((LIRS)this.owner).header);
        }

        private void tempRemoveFromQueue() {
            if (this.inQueue()) {
                this.previousInQueue.nextInQueue = this.nextInQueue;
                this.nextInQueue.previousInQueue = this.previousInQueue;
            }
        }

        private void removeFromQueue() {
            this.tempRemoveFromQueue();
            this.previousInQueue = null;
            this.nextInQueue = null;
        }

        private void addToQueueBefore(LIRSHashEntry<K, V> lIRSHashEntry) {
            this.previousInQueue = lIRSHashEntry.previousInQueue;
            this.nextInQueue = lIRSHashEntry;
            this.previousInQueue.nextInQueue = this;
            this.nextInQueue.previousInQueue = this;
        }

        private void moveToQueueEnd() {
            this.tempRemoveFromQueue();
            this.addToQueueBefore(((LIRS)this.owner).header);
        }

        private void migrateToQueue() {
            this.removeFromStack();
            this.cold();
        }

        private void migrateToStack() {
            this.removeFromQueue();
            if (!this.inStack()) {
                this.moveToStackBottom();
            }
            this.hot();
        }

        private void evict() {
            this.removeFromQueue();
            this.removeFromStack();
            this.nonResident();
            this.owner = null;
        }

        private V remove() {
            boolean bl = this.state == Recency.LIR_RESIDENT;
            Object object = this.value;
            LIRSHashEntry lIRSHashEntry = this.owner != null ? ((LIRS)this.owner).queueEnd() : null;
            this.evict();
            if (bl && lIRSHashEntry != null) {
                lIRSHashEntry.migrateToStack();
            }
            return (V)object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LRU<K, V>
    extends LinkedHashMap<HashEntry<K, V>, V>
    implements EvictionPolicy<K, V> {
        private static final long serialVersionUID = -7645068174197717838L;
        private final ConcurrentLinkedQueue<HashEntry<K, V>> accessQueue;
        private final Segment<K, V> segment;
        private final int maxBatchQueueSize;
        private final int trimDownSize;
        private final float batchThresholdFactor;
        private final Set<HashEntry<K, V>> evicted;

        public LRU(Segment<K, V> segment, int n, float f, int n2, float f2) {
            super(n, f, true);
            this.segment = segment;
            this.trimDownSize = n;
            this.maxBatchQueueSize = n2 > 64 ? 64 : n2;
            this.batchThresholdFactor = f2;
            this.accessQueue = new ConcurrentLinkedQueue();
            this.evicted = new HashSet<HashEntry<K, V>>();
        }

        @Override
        public Set<HashEntry<K, V>> execute() {
            HashSet<HashEntry<K, V>> hashSet = new HashSet<HashEntry<K, V>>();
            for (HashEntry<K, V> hashEntry : this.accessQueue) {
                this.put(hashEntry, hashEntry.value);
            }
            hashSet.addAll(this.evicted);
            this.accessQueue.clear();
            this.evicted.clear();
            return hashSet;
        }

        @Override
        public Set<HashEntry<K, V>> onEntryMiss(HashEntry<K, V> hashEntry) {
            this.put(hashEntry, hashEntry.value);
            if (!this.evicted.isEmpty()) {
                HashSet<HashEntry<K, V>> hashSet = new HashSet<HashEntry<K, V>>();
                hashSet.addAll(this.evicted);
                this.evicted.clear();
                return hashSet;
            }
            return Collections.emptySet();
        }

        @Override
        public boolean onEntryHit(HashEntry<K, V> hashEntry) {
            this.accessQueue.add(hashEntry);
            return (float)this.accessQueue.size() >= (float)this.maxBatchQueueSize * this.batchThresholdFactor;
        }

        @Override
        public boolean thresholdExpired() {
            return this.accessQueue.size() >= this.maxBatchQueueSize;
        }

        @Override
        public void onEntryRemove(HashEntry<K, V> hashEntry) {
            this.remove(hashEntry);
            while (this.accessQueue.remove(hashEntry)) {
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.accessQueue.clear();
        }

        @Override
        public Eviction strategy() {
            return Eviction.LRU;
        }

        protected boolean isAboveThreshold() {
            return this.size() > this.trimDownSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashEntry<K, V>, V> entry) {
            boolean bl = this.isAboveThreshold();
            if (bl) {
                HashEntry<K, V> hashEntry = entry.getKey();
                this.segment.evictionListener.onEntryChosenForEviction(hashEntry.value);
                this.segment.remove(hashEntry.key, hashEntry.hash, null);
                this.evicted.add(hashEntry);
            }
            return bl;
        }

        @Override
        public HashEntry<K, V> createNewEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            return new HashEntry<K, V>(k, n, hashEntry, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullEvictionPolicy<K, V>
    implements EvictionPolicy<K, V> {
        NullEvictionPolicy() {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<HashEntry<K, V>> execute() {
            return Collections.emptySet();
        }

        @Override
        public boolean onEntryHit(HashEntry<K, V> hashEntry) {
            return false;
        }

        @Override
        public Set<HashEntry<K, V>> onEntryMiss(HashEntry<K, V> hashEntry) {
            return Collections.emptySet();
        }

        @Override
        public void onEntryRemove(HashEntry<K, V> hashEntry) {
        }

        @Override
        public boolean thresholdExpired() {
            return false;
        }

        @Override
        public Eviction strategy() {
            return Eviction.NONE;
        }

        @Override
        public HashEntry<K, V> createNewEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            return new HashEntry<K, V>(k, n, hashEntry, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EvictionPolicy<K, V> {
        public static final int MAX_BATCH_SIZE = 64;

        public HashEntry<K, V> createNewEntry(K var1, int var2, HashEntry<K, V> var3, V var4);

        public Set<HashEntry<K, V>> execute();

        public Set<HashEntry<K, V>> onEntryMiss(HashEntry<K, V> var1);

        public boolean onEntryHit(HashEntry<K, V> var1);

        public void onEntryRemove(HashEntry<K, V> var1);

        public void clear();

        public Eviction strategy();

        public boolean thresholdExpired();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NullEvictionListener<K, V>
    implements EvictionListener<K, V> {
        NullEvictionListener() {
        }

        @Override
        public void onEntryEviction(Map<K, V> map) {
        }

        @Override
        public void onEntryChosenForEviction(V v) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EvictionListener<K, V> {
        public void onEntryEviction(Map<K, V> var1);

        public void onEntryChosenForEviction(V var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Eviction {
        NONE{

            @Override
            public <K, V> EvictionPolicy<K, V> make(Segment<K, V> segment, int n, float f) {
                return new NullEvictionPolicy();
            }
        }
        ,
        LRU{

            @Override
            public <K, V> EvictionPolicy<K, V> make(Segment<K, V> segment, int n, float f) {
                return new LRU<K, V>(segment, n, f, n * 10, f);
            }
        }
        ,
        LIRS{

            @Override
            public <K, V> EvictionPolicy<K, V> make(Segment<K, V> segment, int n, float f) {
                return new LIRS<K, V>(segment, n, n * 10, f);
            }
        };


        abstract <K, V> EvictionPolicy<K, V> make(Segment<K, V> var1, int var2, float var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Recency {
        HIR_RESIDENT,
        LIR_RESIDENT,
        HIR_NONRESIDENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashEntry<K, V> {
        final K key;
        final int hash;
        volatile V value;
        final HashEntry<K, V> next;

        HashEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            this.key = k;
            this.hash = n;
            this.next = hashEntry;
            this.value = v;
        }

        public int hashCode() {
            int n = 17;
            n = n * 31 + this.hash;
            n = n * 31 + this.key.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            HashEntry hashEntry = (HashEntry)object;
            return this.hash == hashEntry.hash && this.key.equals(hashEntry.key);
        }

        static <K, V> HashEntry<K, V>[] newArray(int n) {
            return new HashEntry[n];
        }
    }
}

