/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayHelper {
    public static final boolean[] TRUE = new boolean[]{true};
    public static final boolean[] FALSE = new boolean[]{false};
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static int SEED = 23;
    private static int PRIME_NUMER = 37;

    public static int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static String[] toStringArray(Object[] objectArray) {
        int n = objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public static String[] fillArray(String string, int n) {
        Object[] objectArray = new String[n];
        Arrays.fill(objectArray, string);
        return objectArray;
    }

    public static int[] fillArray(int n, int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, n);
        return nArray;
    }

    public static LockMode[] fillArray(LockMode lockMode, int n) {
        LockMode[] lockModeArray = new LockMode[n];
        Arrays.fill((Object[])lockModeArray, (Object)lockMode);
        return lockModeArray;
    }

    public static LockOptions[] fillArray(LockOptions lockOptions, int n) {
        Object[] objectArray = new LockOptions[n];
        Arrays.fill(objectArray, lockOptions);
        return objectArray;
    }

    public static String[] toStringArray(Collection collection) {
        return collection.toArray(new String[collection.size()]);
    }

    public static String[][] to2DStringArray(Collection collection) {
        return (String[][])collection.toArray((T[])new String[collection.size()][]);
    }

    public static int[][] to2DIntArray(Collection collection) {
        return (int[][])collection.toArray((T[])new int[collection.size()][]);
    }

    public static Type[] toTypeArray(Collection collection) {
        return collection.toArray(new Type[collection.size()]);
    }

    public static int[] toIntArray(Collection collection) {
        Iterator iterator = collection.iterator();
        int[] nArray = new int[collection.size()];
        int n = 0;
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        return nArray;
    }

    public static boolean[] toBooleanArray(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean[] blArray = new boolean[collection.size()];
        int n = 0;
        while (iterator.hasNext()) {
            blArray[n++] = (Boolean)iterator.next();
        }
        return blArray;
    }

    public static Object[] typecast(Object[] objectArray, Object[] objectArray2) {
        return Arrays.asList(objectArray).toArray(objectArray2);
    }

    public static List toList(Object object) {
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        int n = Array.getLength(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(Array.get(object, i));
        }
        return arrayList;
    }

    public static String[] slice(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    public static Object[] slice(Object[] objectArray, int n, int n2) {
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, n, objectArray2, 0, n2);
        return objectArray2;
    }

    public static List toList(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static String[] join(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String[] join(String[] stringArray, String[] stringArray2, boolean[] blArray) {
        String[] stringArray3 = new String[stringArray.length + ArrayHelper.countTrue(blArray)];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        int n = stringArray.length;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!blArray[i]) continue;
            stringArray3[n++] = stringArray2[i];
        }
        return stringArray3;
    }

    public static int[] join(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static <T> T[] join(T[] TArray, T[] TArray2) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    private ArrayHelper() {
    }

    public static String toString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i]);
            if (i >= objectArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static boolean isAllNegative(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllTrue(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            return false;
        }
        return true;
    }

    public static int countTrue(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    public static boolean isAllFalse(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            return false;
        }
        return true;
    }

    public static void addAll(Collection collection, Object[] objectArray) {
        collection.addAll(Arrays.asList(objectArray));
    }

    public static int[] getBatchSizes(int n) {
        int n2 = n;
        int n3 = 1;
        while (n2 > 1) {
            n2 = ArrayHelper.getNextBatchSize(n2);
            ++n3;
        }
        int[] nArray = new int[n3];
        n2 = n;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = n2;
            n2 = ArrayHelper.getNextBatchSize(n2);
        }
        return nArray;
    }

    private static int getNextBatchSize(int n) {
        if (n <= 10) {
            return n - 1;
        }
        if (n / 2 < 10) {
            return 10;
        }
        return n / 2;
    }

    public static int hash(Object[] objectArray) {
        int n = objectArray.length;
        int n2 = SEED;
        for (int i = 0; i < n; ++i) {
            n2 = ArrayHelper.hash(n2, objectArray[i] == null ? 0 : objectArray[i].hashCode());
        }
        return n2;
    }

    public static int hash(char[] cArray) {
        int n = cArray.length;
        int n2 = SEED;
        for (int i = 0; i < n; ++i) {
            n2 = ArrayHelper.hash(n2, cArray[i]);
        }
        return n2;
    }

    public static int hash(byte[] byArray) {
        int n = byArray.length;
        int n2 = SEED;
        for (int i = 0; i < n; ++i) {
            n2 = ArrayHelper.hash(n2, byArray[i]);
        }
        return n2;
    }

    private static int hash(int n, int n2) {
        return PRIME_NUMER * n + n2;
    }

    public static boolean isEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (n != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n = cArray.length;
        if (n != cArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static Serializable[] extractNonNull(Serializable[] serializableArray) {
        int n = ArrayHelper.countNonNull(serializableArray);
        Serializable[] serializableArray2 = new Serializable[n];
        int n2 = 0;
        for (Serializable serializable : serializableArray) {
            if (serializable == null) continue;
            serializableArray2[n2++] = serializable;
        }
        if (n2 != n) {
            throw new HibernateException("Number of non-null elements varied between iterations");
        }
        return serializableArray2;
    }

    public static int countNonNull(Serializable[] serializableArray) {
        int n = 0;
        for (Serializable serializable : serializableArray) {
            if (serializable == null) continue;
            ++n;
        }
        return n;
    }

    public static void main(String ... stringArray) {
        int n;
        int[] nArray = ArrayHelper.getBatchSizes(32);
        System.out.println("Forward ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        for (n = 0; n < nArray.length; ++n) {
            System.out.println("[" + n + "] -> " + nArray[n]);
        }
        System.out.println("Backward ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        for (n = nArray.length - 1; n >= 0; --n) {
            System.out.println("[" + n + "] -> " + nArray[n]);
        }
    }
}

