/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.internal.util.beans.BeanIntrospectionException;

public class BeanInfoHelper {
    private final Class beanClass;
    private final Class stopClass;

    public BeanInfoHelper(Class clazz) {
        this(clazz, Object.class);
    }

    public BeanInfoHelper(Class clazz, Class clazz2) {
        this.beanClass = clazz;
        this.stopClass = clazz2;
    }

    public void applyToBeanInfo(Object object, BeanInfoDelegate beanInfoDelegate) {
        if (!this.beanClass.isInstance(object)) {
            throw new BeanIntrospectionException("Bean [" + object + "] was not of declared bean type [" + this.beanClass.getName() + "]");
        }
        BeanInfoHelper.visitBeanInfo(this.beanClass, this.stopClass, beanInfoDelegate);
    }

    public static void visitBeanInfo(Class clazz, BeanInfoDelegate beanInfoDelegate) {
        BeanInfoHelper.visitBeanInfo(clazz, Object.class, beanInfoDelegate);
    }

    public static void visitBeanInfo(Class clazz, Class clazz2, BeanInfoDelegate beanInfoDelegate) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, clazz2);
            try {
                beanInfoDelegate.processBeanInfo(beanInfo);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new BeanIntrospectionException("Error delegating bean info use", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new BeanIntrospectionException("Error delegating bean info use", exception);
            }
            finally {
                Introspector.flushFromCaches(clazz);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new BeanIntrospectionException("Unable to determine bean info from class [" + clazz.getName() + "]", introspectionException);
        }
    }

    public static interface BeanInfoDelegate {
        public void processBeanInfo(BeanInfo var1) throws Exception;
    }
}

