/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.ArrayHelper;

public final class StringHelper {
    private static final int ALIAS_TRUNCATE_LENGTH = 10;
    public static final String WHITESPACE = " \n\r\f\t";
    public static final String BATCH_ID_PLACEHOLDER = "$$BATCH_ID_PLACEHOLDER$$";

    private StringHelper() {
    }

    public static int lastIndexOfLetter(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || '_' == c) continue;
            return i - 1;
        }
        return string.length() - 1;
    }

    public static String join(String string, String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n * stringArray[0].length()).append(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string).append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String joinWithQualifier(String[] stringArray, String string, String string2) {
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n * stringArray[0].length()).append(StringHelper.qualify(string, stringArray[0]));
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string2).append(StringHelper.qualify(string, stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String join(String string, Iterator iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public static String[] add(String[] stringArray, String string, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i] = stringArray[i] + string + stringArray2[i];
        }
        return stringArray3;
    }

    public static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string, int n, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n + string2.length() * (n - 1)).append(string);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.toString();
    }

    public static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static String replace(String string, String string2, String string3) {
        return StringHelper.replace(string, string2, string3, false);
    }

    public static String[] replace(String[] stringArray, String string, String string2) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringHelper.replace(stringArray[i], string, string2);
        }
        return stringArray2;
    }

    public static String replace(String string, String string2, String string3, boolean bl) {
        return StringHelper.replace(string, string2, string3, bl, false);
    }

    public static String replace(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + string2.length());
        return StringHelper.replace(string4, string5, string2, string3, bl, bl2);
    }

    public static String replace(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        boolean bl3 = !bl || string2.length() == 0 || !Character.isJavaIdentifierPart(string2.charAt(0));
        boolean bl4 = bl3 && bl2 && StringHelper.getLastNonWhitespaceCharacter(string) != '(' && StringHelper.getFirstNonWhitespaceCharacter(string2) != ')';
        StringBuilder stringBuilder = new StringBuilder(string);
        if (bl4) {
            stringBuilder.append('(');
        }
        stringBuilder.append(bl3 ? string4 : string3);
        if (bl4) {
            stringBuilder.append(')');
        }
        stringBuilder.append(StringHelper.replace(string2, string3, string4, bl, bl2));
        return stringBuilder.toString();
    }

    public static char getLastNonWhitespaceCharacter(String string) {
        if (string != null && string.length() > 0) {
            for (int i = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                return c;
            }
        }
        return '\u0000';
    }

    public static char getFirstNonWhitespaceCharacter(String string) {
        if (string != null && string.length() > 0) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                return c;
            }
        }
        return '\u0000';
    }

    public static String replaceOnce(String string, String string2, String string3) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + string3 + string.substring(n + string2.length());
    }

    public static String[] split(String string, String string2) {
        return StringHelper.split(string, string2, false);
    }

    public static String[] split(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string, bl);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String unqualify(String string) {
        int n = string.lastIndexOf(".");
        return n < 0 ? string : string.substring(n + 1);
    }

    public static String qualifier(String string) {
        int n = string.lastIndexOf(".");
        return n < 0 ? "" : string.substring(0, n);
    }

    public static String collapse(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return StringHelper.collapseQualifier(string.substring(0, n), true) + string.substring(n);
    }

    public static String collapseQualifier(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = Character.toString(stringTokenizer.nextToken().charAt(0));
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                string2 = string2 + '.';
            }
            string2 = string2 + stringTokenizer.nextToken().charAt(0);
        }
        return string2;
    }

    public static String partiallyUnqualify(String string, String string2) {
        if (string == null || !string.startsWith(string2)) {
            return string;
        }
        return string.substring(string2.length() + 1);
    }

    public static String collapseQualifierBase(String string, String string2) {
        if (string == null || !string.startsWith(string2)) {
            return StringHelper.collapse(string);
        }
        return StringHelper.collapseQualifier(string2, true) + string.substring(string2.length());
    }

    public static String[] suffix(String[] stringArray, String string) {
        if (string == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringHelper.suffix(stringArray[i], string);
        }
        return stringArray2;
    }

    private static String suffix(String string, String string2) {
        return string2 == null ? string : string + string2;
    }

    public static String root(String string) {
        int n = string.indexOf(".");
        return n < 0 ? string : string.substring(0, n);
    }

    public static String unroot(String string) {
        int n = string.indexOf(".");
        return n < 0 ? string : string.substring(n + 1, string.length());
    }

    public static boolean booleanValue(String string) {
        String string2 = string.trim().toLowerCase();
        return string2.equals("true") || string2.equals("t");
    }

    public static String toString(Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n * 12);
        for (int i = 0; i < n - 1; ++i) {
            stringBuilder.append(objectArray[i]).append(", ");
        }
        return stringBuilder.append(objectArray[n - 1]).toString();
    }

    public static String[] multiply(String string, Iterator iterator, Iterator iterator2) {
        String[] stringArray = new String[]{string};
        while (iterator.hasNext()) {
            stringArray = StringHelper.multiply(stringArray, (String)iterator.next(), (String[])iterator2.next());
        }
        return stringArray;
    }

    private static String[] multiply(String[] stringArray, String string, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray2.length * stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray3[n++] = StringHelper.replaceOnce(stringArray[j], string, stringArray2[i]);
            }
        }
        return stringArray3;
    }

    public static int countUnquoted(String string, char c) {
        if ('\'' == c) {
            throw new IllegalArgumentException("Unquoted count of quotes is invalid");
        }
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if ('\'' != c2) continue;
                bl = false;
                continue;
            }
            if ('\'' == c2) {
                bl = true;
                continue;
            }
            if (c2 != c) continue;
            ++n;
        }
        return n;
    }

    public static int[] locateUnquoted(String string, char c) {
        if ('\'' == c) {
            throw new IllegalArgumentException("Unquoted count of quotes is invalid");
        }
        if (string == null) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(20);
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if ('\'' != c2) continue;
                bl = false;
                continue;
            }
            if ('\'' == c2) {
                bl = true;
                continue;
            }
            if (c2 != c) continue;
            arrayList.add(i);
        }
        return ArrayHelper.toIntArray(arrayList);
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String qualify(String string, String string2) {
        if (string2 == null || string == null) {
            throw new NullPointerException();
        }
        return new StringBuilder(string.length() + string2.length() + 1).append(string).append('.').append(string2).toString();
    }

    public static String[] qualify(String string, String[] stringArray) {
        if (string == null) {
            return stringArray;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = StringHelper.qualify(string, stringArray[i]);
        }
        return stringArray2;
    }

    public static String[] qualifyIfNot(String string, String[] stringArray) {
        if (string == null) {
            return stringArray;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i].indexOf(46) < 0 ? StringHelper.qualify(string, stringArray[i]) : stringArray[i];
        }
        return stringArray2;
    }

    public static int firstIndexOfChar(String string, BitSet bitSet, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            if (!bitSet.get(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int firstIndexOfChar(String string, String string2, int n) {
        BitSet bitSet = new BitSet();
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            bitSet.set(string2.charAt(i));
        }
        return StringHelper.firstIndexOfChar(string, bitSet, n);
    }

    public static String truncate(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String generateAlias(String string) {
        return StringHelper.generateAliasRoot(string) + '_';
    }

    public static String generateAlias(String string, int n) {
        return StringHelper.generateAliasRoot(string) + Integer.toString(n) + '_';
    }

    private static String generateAliasRoot(String string) {
        String string2 = StringHelper.truncate(StringHelper.unqualifyEntityName(string), 10).toLowerCase().replace('/', '_').replace('$', '_');
        if (Character.isDigit((string2 = StringHelper.cleanAlias(string2)).charAt(string2.length() - 1))) {
            return string2 + "x";
        }
        return string2;
    }

    private static String cleanAlias(String string) {
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (!Character.isLetter(cArray[i])) continue;
                return string.substring(i);
            }
        }
        return string;
    }

    public static String unqualifyEntityName(String string) {
        String string2 = StringHelper.unqualify(string);
        int n = string2.indexOf(47);
        if (n > 0) {
            string2 = string2.substring(0, n - 1);
        }
        return string2;
    }

    public static String toUpperCase(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static String toLowerCase(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String moveAndToBeginning(String string) {
        if (string.trim().length() > 0 && (string = string + " and ").startsWith(" and ")) {
            string = string.substring(4);
        }
        return string;
    }

    public static boolean isQuoted(String string) {
        return string != null && string.length() != 0 && string.charAt(0) == '`' && string.charAt(string.length() - 1) == '`';
    }

    public static String quote(String string) {
        if (StringHelper.isEmpty(string) || StringHelper.isQuoted(string)) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return new StringBuilder(string.length() + 2).append('`').append(string).append('`').toString();
    }

    public static String unquote(String string) {
        return StringHelper.isQuoted(string) ? string.substring(1, string.length() - 1) : string;
    }

    public static boolean isQuoted(String string, Dialect dialect) {
        return string != null && string.length() != 0 && (string.charAt(0) == '`' && string.charAt(string.length() - 1) == '`' || string.charAt(0) == dialect.openQuote() && string.charAt(string.length() - 1) == dialect.closeQuote());
    }

    public static String unquote(String string, Dialect dialect) {
        return StringHelper.isQuoted(string, dialect) ? string.substring(1, string.length() - 1) : string;
    }

    public static String[] unquote(String[] stringArray, Dialect dialect) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringHelper.unquote(stringArray[i], dialect);
        }
        return stringArray2;
    }

    public static StringBuilder buildBatchFetchRestrictionFragment(String string, String[] stringArray, Dialect dialect) {
        if (stringArray.length == 1) {
            return new StringBuilder(StringHelper.qualify(string, stringArray[0])).append(" in (").append(BATCH_ID_PLACEHOLDER).append(")");
        }
        if (dialect.supportsRowValueConstructorSyntaxInInList()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            boolean bl = true;
            String string2 = "";
            for (String string3 : stringArray) {
                stringBuilder.append(string2).append(StringHelper.qualify(string, string3));
                if (!bl) continue;
                bl = false;
                string2 = ",";
            }
            stringBuilder.append(") in (");
            stringBuilder.append(BATCH_ID_PLACEHOLDER);
            stringBuilder.append(")");
            return stringBuilder;
        }
        return new StringBuilder("(").append(BATCH_ID_PLACEHOLDER).append(")");
    }

    public static String expandBatchIdPlaceholder(String string, Serializable[] serializableArray, String string2, String[] stringArray, Dialect dialect) {
        if (stringArray.length == 1) {
            return StringHelper.replace(string, BATCH_ID_PLACEHOLDER, StringHelper.repeat("?", serializableArray.length, ","));
        }
        if (dialect.supportsRowValueConstructorSyntaxInInList()) {
            String string3 = "(" + StringHelper.repeat("?", stringArray.length, ",");
            return StringHelper.replace(string, BATCH_ID_PLACEHOLDER, StringHelper.repeat(string3, serializableArray.length, ","));
        }
        String string4 = StringHelper.joinWithQualifier(stringArray, string2, " and ");
        return StringHelper.replace(string, BATCH_ID_PLACEHOLDER, StringHelper.repeat(string4, serializableArray.length, " or "));
    }

    public static String[] toArrayElement(String string) {
        String[] stringArray;
        if (string == null || string.length() == 0) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        return stringArray;
    }
}

