/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.type.SerializationException;
import org.jboss.logging.Logger;

public final class SerializationHelper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SerializationHelper.class.getName());

    private SerializationHelper() {
    }

    public static Object clone(Serializable serializable) throws SerializationException {
        LOG.trace("Starting clone through serialization");
        if (serializable == null) {
            return null;
        }
        return SerializationHelper.deserialize(SerializationHelper.serialize(serializable), serializable.getClass().getClassLoader());
    }

    public static void serialize(Serializable serializable, OutputStream outputStream) throws SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        if (LOG.isTraceEnabled()) {
            if (Hibernate.isInitialized(serializable)) {
                LOG.tracev("Starting serialization of object [{0}]", (Object)serializable);
            } else {
                LOG.trace("Starting serialization of [uninitialized proxy]");
            }
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not serialize", iOException);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Serializable serializable) throws SerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationHelper.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(InputStream inputStream) throws SerializationException {
        return SerializationHelper.doDeserialize(inputStream, SerializationHelper.defaultClassLoader(), SerializationHelper.hibernateClassLoader(), null);
    }

    public static ClassLoader defaultClassLoader() {
        return ClassLoaderHelper.getContextClassLoader();
    }

    public static ClassLoader hibernateClassLoader() {
        return SerializationHelper.class.getClassLoader();
    }

    public static Object deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
        return SerializationHelper.doDeserialize(inputStream, classLoader, SerializationHelper.defaultClassLoader(), SerializationHelper.hibernateClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doDeserialize(InputStream inputStream, ClassLoader classLoader, ClassLoader classLoader2, ClassLoader classLoader3) throws SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        LOG.trace("Starting deserialization of object");
        try {
            CustomObjectInputStream customObjectInputStream = new CustomObjectInputStream(inputStream, classLoader, classLoader2, classLoader3);
            try {
                Object object = customObjectInputStream.readObject();
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException("could not deserialize", classNotFoundException);
            }
            catch (IOException iOException) {
                throw new SerializationException("could not deserialize", iOException);
            }
            finally {
                try {
                    customObjectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("could not deserialize", iOException);
        }
    }

    public static Object deserialize(byte[] byArray) throws SerializationException {
        return SerializationHelper.doDeserialize(SerializationHelper.wrap(byArray), SerializationHelper.defaultClassLoader(), SerializationHelper.hibernateClassLoader(), null);
    }

    private static InputStream wrap(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return new ByteArrayInputStream(byArray);
    }

    public static Object deserialize(byte[] byArray, ClassLoader classLoader) throws SerializationException {
        return SerializationHelper.doDeserialize(SerializationHelper.wrap(byArray), classLoader, SerializationHelper.defaultClassLoader(), SerializationHelper.hibernateClassLoader());
    }

    private static final class CustomObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader loader1;
        private final ClassLoader loader2;
        private final ClassLoader loader3;

        private CustomObjectInputStream(InputStream inputStream, ClassLoader classLoader, ClassLoader classLoader2, ClassLoader classLoader3) throws IOException {
            super(inputStream);
            this.loader1 = classLoader;
            this.loader2 = classLoader2;
            this.loader3 = classLoader3;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string = objectStreamClass.getName();
            LOG.tracev("Attempting to locate class [{0}]", (Object)string);
            try {
                return Class.forName(string, false, this.loader1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.trace("Unable to locate class using given classloader");
                if (this.different(this.loader1, this.loader2)) {
                    try {
                        return Class.forName(string, false, this.loader2);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        LOG.trace("Unable to locate class using given classloader");
                    }
                }
                if (this.different(this.loader1, this.loader3) && this.different(this.loader2, this.loader3)) {
                    try {
                        return Class.forName(string, false, this.loader3);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        LOG.trace("Unable to locate class using given classloader");
                    }
                }
                return super.resolveClass(objectStreamClass);
            }
        }

        private boolean different(ClassLoader classLoader, ClassLoader classLoader2) {
            if (classLoader == null) {
                return classLoader2 != null;
            }
            return !classLoader.equals(classLoader2);
        }
    }
}

