/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityPrinter {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EntityPrinter.class.getName());
    private SessionFactoryImplementor factory;

    public String toString(String string, Object object) throws HibernateException {
        EntityPersister entityPersister = this.factory.getEntityPersister(string);
        if (entityPersister == null) {
            return object.getClass().getName();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (entityPersister.hasIdentifierProperty()) {
            hashMap.put(entityPersister.getIdentifierPropertyName(), entityPersister.getIdentifierType().toLoggableString(entityPersister.getIdentifier(object), this.factory));
        }
        Type[] typeArray = entityPersister.getPropertyTypes();
        String[] stringArray = entityPersister.getPropertyNames();
        Object[] objectArray = entityPersister.getPropertyValues(object);
        for (int i = 0; i < typeArray.length; ++i) {
            if (stringArray[i].startsWith("_")) continue;
            String string2 = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? objectArray[i].toString() : typeArray[i].toLoggableString(objectArray[i], this.factory);
            hashMap.put(stringArray[i], string2);
        }
        return string + ((Object)hashMap).toString();
    }

    public String toString(Type[] typeArray, Object[] objectArray) throws HibernateException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i] == null) continue;
            stringBuilder.append(typeArray[i].toLoggableString(objectArray[i], this.factory)).append(", ");
        }
        return stringBuilder.toString();
    }

    public String toString(Map<String, TypedValue> map) throws HibernateException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, TypedValue> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getType().toLoggableString(entry.getValue().getValue(), this.factory));
        }
        return ((Object)hashMap).toString();
    }

    public void toString(Iterable<Map.Entry<EntityKey, Object>> iterable) throws HibernateException {
        if (!LOG.isDebugEnabled() || !iterable.iterator().hasNext()) {
            return;
        }
        LOG.debug("Listing entities:");
        int n = 0;
        for (Map.Entry<EntityKey, Object> entry : iterable) {
            if (n++ > 20) {
                LOG.debug("More......");
                break;
            }
            LOG.debug(this.toString(entry.getKey().getEntityName(), entry.getValue()));
        }
    }

    public EntityPrinter(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }
}

