/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.HibernateException;

public class Cloneable {
    private static final Object[] READER_METHOD_ARGS = new Object[0];

    public Object shallowCopy() {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Cloneable.this.copyListeners();
            }
        });
    }

    public void validate() throws HibernateException {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cloneable.this.checkListeners();
                return null;
            }
        });
    }

    private Object copyListeners() {
        Object var1_1 = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
            this.internalCheckListeners(beanInfo);
            var1_1 = this.getClass().newInstance();
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    propertyDescriptorArray[i].getWriteMethod().invoke(var1_1, propertyDescriptorArray[i].getReadMethod().invoke((Object)this, READER_METHOD_ARGS));
                    continue;
                }
                catch (Throwable throwable) {
                    throw new HibernateException("Unable copy copy listener [" + propertyDescriptorArray[i].getName() + "]");
                }
            }
        }
        catch (Exception exception) {
            throw new HibernateException("Unable to copy listeners", exception);
        }
        finally {
            if (beanInfo != null) {
                Introspector.flushFromCaches(this.getClass());
            }
        }
        return var1_1;
    }

    private void checkListeners() {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
            this.internalCheckListeners(beanInfo);
        }
        catch (IntrospectionException introspectionException) {
            throw new HibernateException("Unable to validate listener config", introspectionException);
        }
        finally {
            if (beanInfo != null) {
                Introspector.flushFromCaches(this.getClass());
            }
        }
    }

    private void internalCheckListeners(BeanInfo beanInfo) {
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        try {
            int n = propertyDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = propertyDescriptorArray[i].getReadMethod().invoke((Object)this, READER_METHOD_ARGS);
                if (object == null) {
                    throw new HibernateException("Listener [" + propertyDescriptorArray[i].getName() + "] was null");
                }
                if (!object.getClass().isArray()) continue;
                Object[] objectArray = (Object[])object;
                int n2 = objectArray.length;
                for (int j = 0; j < n2; ++j) {
                    if (objectArray[j] != null) continue;
                    throw new HibernateException("Listener in [" + propertyDescriptorArray[i].getName() + "] was null");
                }
            }
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to validate listener config");
        }
    }
}

