/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import org.hibernate.internal.util.StringHelper;

public final class BytesHelper {
    private BytesHelper() {
    }

    public static int toInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = (n << 8) - -128 + byArray[i];
        }
        return n;
    }

    public static byte[] fromShort(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8), (byte)(n << 8 >> 8)};
        return byArray;
    }

    public static byte[] fromInt(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n << 8 >> 24), (byte)(n << 16 >> 24), (byte)(n << 24 >> 24)};
        return byArray;
    }

    public static byte[] fromLong(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56), (byte)(l << 8 >> 56), (byte)(l << 16 >> 56), (byte)(l << 24 >> 56), (byte)(l << 32 >> 56), (byte)(l << 40 >> 56), (byte)(l << 48 >> 56), (byte)(l << 56 >> 56)};
        return byArray;
    }

    public static long asLong(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Expecting 8 byte values to construct a long");
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    public static String toBinaryString(byte by) {
        String string = Integer.toBinaryString(by);
        if (string.length() > 8) {
            string = string.substring(string.length() - 8);
        }
        StringBuilder stringBuilder = new StringBuilder("00000000");
        stringBuilder.replace(8 - string.length(), 8, string);
        return stringBuilder.toString();
    }

    public static String toBinaryString(int n) {
        String string = Long.toBinaryString(n);
        StringBuilder stringBuilder = new StringBuilder(StringHelper.repeat('0', 32));
        stringBuilder.replace(64 - string.length(), 64, string);
        return stringBuilder.toString();
    }

    public static String toBinaryString(long l) {
        String string = Long.toBinaryString(l);
        StringBuilder stringBuilder = new StringBuilder(StringHelper.repeat('0', 64));
        stringBuilder.replace(64 - string.length(), 64, string);
        return stringBuilder.toString();
    }
}

