/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.Interceptor;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.criterion.NaturalIdentifier;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.query.spi.FilterQueryPlan;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.NonFlushedChanges;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEvent;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.EvictEvent;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEvent;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.internal.AbstractSessionImpl;
import org.hibernate.internal.CollectionFilterImpl;
import org.hibernate.internal.ConnectionObserverStatsBridge;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.NonFlushedChangesImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.internal.SessionStatisticsImpl;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionImpl
extends AbstractSessionImpl
implements EventSource {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SessionImpl.class.getName());
    private static final boolean tracing = LOG.isTraceEnabled();
    private transient long timestamp;
    private transient SessionOwner sessionOwner;
    private transient ActionQueue actionQueue;
    private transient StatefulPersistenceContext persistenceContext;
    private transient TransactionCoordinatorImpl transactionCoordinator;
    private transient Interceptor interceptor;
    private transient EntityNameResolver entityNameResolver = new CoordinatingEntityNameResolver();
    private transient ConnectionReleaseMode connectionReleaseMode;
    private transient FlushMode flushMode = FlushMode.AUTO;
    private transient CacheMode cacheMode = CacheMode.NORMAL;
    private transient boolean autoClear;
    private transient boolean autoJoinTransactions = true;
    private transient boolean flushBeforeCompletionEnabled;
    private transient boolean autoCloseSessionEnabled;
    private transient int dontFlushFromFind = 0;
    private transient LoadQueryInfluencers loadQueryInfluencers;
    private final transient boolean isTransactionCoordinatorShared;
    private transient TransactionObserver transactionObserver;
    private transient LobHelperImpl lobHelper;

    SessionImpl(Connection connection, SessionFactoryImpl sessionFactoryImpl, SessionOwner sessionOwner, final TransactionCoordinatorImpl transactionCoordinatorImpl, boolean bl, long l, Interceptor interceptor, final boolean bl2, final boolean bl3, ConnectionReleaseMode connectionReleaseMode, String string) {
        super(sessionFactoryImpl, string);
        this.timestamp = l;
        this.sessionOwner = sessionOwner;
        this.interceptor = interceptor == null ? EmptyInterceptor.INSTANCE : interceptor;
        this.actionQueue = new ActionQueue(this);
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.autoCloseSessionEnabled = bl3;
        this.flushBeforeCompletionEnabled = bl2;
        if (transactionCoordinatorImpl == null) {
            this.isTransactionCoordinatorShared = false;
            this.connectionReleaseMode = connectionReleaseMode;
            this.autoJoinTransactions = bl;
            this.transactionCoordinator = new TransactionCoordinatorImpl(connection, this);
            this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().addObserver(new ConnectionObserverStatsBridge(sessionFactoryImpl));
        } else {
            if (connection != null) {
                throw new SessionException("Cannot simultaneously share transaction context and specify connection");
            }
            this.transactionCoordinator = transactionCoordinatorImpl;
            this.isTransactionCoordinatorShared = true;
            this.autoJoinTransactions = false;
            if (bl) {
                LOG.debug("Session creation specified 'autoJoinTransactions', which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
            }
            if (connectionReleaseMode != transactionCoordinatorImpl.getJdbcCoordinator().getLogicalConnection().getConnectionReleaseMode()) {
                LOG.debug("Session creation specified 'connectionReleaseMode', which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
            }
            this.connectionReleaseMode = transactionCoordinatorImpl.getJdbcCoordinator().getLogicalConnection().getConnectionReleaseMode();
            this.transactionObserver = new TransactionObserver(){

                public void afterBegin(TransactionImplementor transactionImplementor) {
                }

                public void beforeCompletion(TransactionImplementor transactionImplementor) {
                    if (SessionImpl.this.isOpen() && bl2) {
                        SessionImpl.this.managedFlush();
                    }
                    SessionImpl.this.beforeTransactionCompletion(transactionImplementor);
                }

                public void afterCompletion(boolean bl, TransactionImplementor transactionImplementor) {
                    SessionImpl.this.afterTransactionCompletion(transactionImplementor, bl);
                    if (SessionImpl.this.isOpen() && bl3) {
                        SessionImpl.this.managedClose();
                    }
                    transactionCoordinatorImpl.removeObserver(this);
                }
            };
            transactionCoordinatorImpl.addObserver(this.transactionObserver);
        }
        this.loadQueryInfluencers = new LoadQueryInfluencers(sessionFactoryImpl);
        if (sessionFactoryImpl.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImpl.getStatisticsImplementor().openSession();
        }
        if (tracing) {
            LOG.tracef("Opened session at timestamp: %s", (Object)l);
        }
    }

    @Override
    public SharedSessionBuilder sessionWithOptions() {
        return new SharedSessionBuilderImpl(this);
    }

    @Override
    public void clear() {
        this.errorIfClosed();
        this.pulseTransactionCoordinator();
        this.internalClear();
    }

    private void internalClear() {
        this.persistenceContext.clear();
        this.actionQueue.clear();
    }

    @Override
    public long getTimestamp() {
        this.checkTransactionSynchStatus();
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection close() throws HibernateException {
        LOG.trace("Closing session");
        if (this.isClosed()) {
            throw new SessionException("Session was already closed");
        }
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().closeSession();
        }
        try {
            if (!this.isTransactionCoordinatorShared) {
                Connection connection = this.transactionCoordinator.close();
                return connection;
            }
            if (this.getActionQueue().hasAfterTransactionActions()) {
                LOG.warn("On close, shared Session had after transaction actions that have not yet been processed");
            } else {
                this.transactionCoordinator.removeObserver(this.transactionObserver);
            }
            Connection connection = null;
            return connection;
        }
        finally {
            this.setClosed();
            this.cleanup();
        }
    }

    @Override
    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.connectionReleaseMode;
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return this.autoJoinTransactions;
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.autoCloseSessionEnabled;
    }

    @Override
    public boolean isOpen() {
        this.checkTransactionSynchStatus();
        return !this.isClosed();
    }

    @Override
    public boolean isFlushModeNever() {
        return FlushMode.isManualFlushMode(this.getFlushMode());
    }

    @Override
    public boolean isFlushBeforeCompletionEnabled() {
        return this.flushBeforeCompletionEnabled;
    }

    @Override
    public void managedFlush() {
        if (this.isClosed()) {
            LOG.trace("Skipping auto-flush due to session closed");
            return;
        }
        LOG.trace("Automatically flushing session");
        this.flush();
    }

    @Override
    public NonFlushedChanges getNonFlushedChanges() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new NonFlushedChangesImpl(this);
    }

    @Override
    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.replacePersistenceContext(((NonFlushedChangesImpl)nonFlushedChanges).getPersistenceContext());
        this.replaceActionQueue(((NonFlushedChangesImpl)nonFlushedChanges).getActionQueue());
    }

    private void replacePersistenceContext(StatefulPersistenceContext statefulPersistenceContext) {
        if (statefulPersistenceContext.getSession() != null) {
            throw new IllegalStateException("new persistence context is already connected to a session ");
        }
        this.persistenceContext.clear();
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializePersistenceContext(statefulPersistenceContext)));
            this.persistenceContext = StatefulPersistenceContext.deserialize(objectInputStream, this);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not deserialize the persistence context", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("could not deserialize the persistence context", classNotFoundException);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] serializePersistenceContext(StatefulPersistenceContext statefulPersistenceContext) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            statefulPersistenceContext.serialize(objectOutputStream);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not serialize persistence context", iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void replaceActionQueue(ActionQueue actionQueue) {
        if (this.actionQueue.hasAnyQueuedActions()) {
            throw new IllegalStateException("cannot replace an ActionQueue with queued actions ");
        }
        this.actionQueue.clear();
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializeActionQueue(actionQueue)));
            this.actionQueue = ActionQueue.deserialize(objectInputStream, this);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not deserialize the action queue", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("could not deserialize the action queue", classNotFoundException);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] serializeActionQueue(ActionQueue actionQueue) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            actionQueue.serialize(objectOutputStream);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not serialize action queue", iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean shouldAutoClose() {
        if (this.isClosed()) {
            return false;
        }
        if (this.sessionOwner != null) {
            return this.sessionOwner.shouldAutoCloseSession();
        }
        return this.isAutoCloseSessionEnabled();
    }

    @Override
    public void managedClose() {
        LOG.trace("Automatically closing session");
        this.close();
    }

    @Override
    public Connection connection() throws HibernateException {
        this.errorIfClosed();
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getConnection();
    }

    @Override
    public boolean isConnected() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().isOpen();
    }

    @Override
    public boolean isTransactionInProgress() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.transactionCoordinator.isTransactionInProgress();
    }

    @Override
    public Connection disconnect() throws HibernateException {
        this.errorIfClosed();
        LOG.debug("Disconnecting session");
        this.transactionCoordinator.getJdbcCoordinator().releaseResources();
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().manualDisconnect();
    }

    @Override
    public void reconnect(Connection connection) throws HibernateException {
        this.errorIfClosed();
        LOG.debug("Reconnecting session");
        this.checkTransactionSynchStatus();
        this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().manualReconnect(connection);
    }

    @Override
    public void setAutoClear(boolean bl) {
        this.errorIfClosed();
        this.autoClear = bl;
    }

    @Override
    public void disableTransactionAutoJoin() {
        this.errorIfClosed();
        this.autoJoinTransactions = false;
    }

    public void afterOperation(boolean bl) {
        if (!this.transactionCoordinator.isTransactionInProgress()) {
            this.transactionCoordinator.afterNonTransactionalQuery(bl);
        }
    }

    @Override
    public void afterTransactionBegin(TransactionImplementor transactionImplementor) {
        this.errorIfClosed();
        this.interceptor.afterTransactionBegin(transactionImplementor);
    }

    @Override
    public void beforeTransactionCompletion(TransactionImplementor transactionImplementor) {
        LOG.trace("before transaction completion");
        this.actionQueue.beforeTransactionCompletion();
        try {
            this.interceptor.beforeTransactionCompletion(transactionImplementor);
        }
        catch (Throwable throwable) {
            LOG.exceptionInBeforeTransactionCompletionInterceptor(throwable);
        }
    }

    @Override
    public void afterTransactionCompletion(TransactionImplementor transactionImplementor, boolean bl) {
        LOG.trace("after transaction completion");
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(bl);
        if (transactionImplementor != null) {
            try {
                this.interceptor.afterTransactionCompletion(transactionImplementor);
            }
            catch (Throwable throwable) {
                LOG.exceptionInAfterTransactionCompletionInterceptor(throwable);
            }
        }
        if (this.autoClear) {
            this.internalClear();
        }
    }

    @Override
    public String onPrepareStatement(String string) {
        this.errorIfClosed();
        string = this.interceptor.onPrepareStatement(string);
        if (string == null || string.length() == 0) {
            throw new AssertionFailure("Interceptor.onPrepareStatement() returned null or empty string.");
        }
        return string;
    }

    private void cleanup() {
        this.persistenceContext.clear();
    }

    @Override
    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        if (object instanceof HibernateProxy && (object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry entityEntry = this.persistenceContext.getEntry(object);
        if (entityEntry == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (entityEntry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("The given object was deleted", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        return entityEntry.getLockMode();
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey entityKey) throws HibernateException {
        this.errorIfClosed();
        Object object = this.persistenceContext.getEntity(entityKey);
        if (object == null) {
            Object object2 = this.interceptor.getEntity(entityKey.getEntityName(), entityKey.getIdentifier());
            if (object2 != null) {
                try {
                    this.lock(object2, LockMode.NONE);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return object2;
        }
        return object;
    }

    private void checkNoUnresolvedActionsBeforeOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0 && this.actionQueue.hasUnresolvedEntityInsertActions()) {
            throw new IllegalStateException("There are delayed insert actions before operation as cascade level 0.");
        }
    }

    private void checkNoUnresolvedActionsAfterOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0) {
            this.actionQueue.checkNoUnresolvedActionsAfterOperation();
        }
        this.delayedAfterCompletion();
    }

    private void delayedAfterCompletion() {
        this.transactionCoordinator.getSynchronizationCallbackCoordinator().delayedAfterCompletion();
    }

    @Override
    public void saveOrUpdate(Object object) throws HibernateException {
        this.saveOrUpdate(null, object);
    }

    @Override
    public void saveOrUpdate(String string, Object object) throws HibernateException {
        this.fireSaveOrUpdate(new SaveOrUpdateEvent(string, object, this));
    }

    private void fireSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (SaveOrUpdateEventListener saveOrUpdateEventListener : this.listeners(EventType.SAVE_UPDATE)) {
            saveOrUpdateEventListener.onSaveOrUpdate(saveOrUpdateEvent);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    private <T> Iterable<T> listeners(EventType<T> eventType) {
        return this.eventListenerGroup(eventType).listeners();
    }

    private <T> EventListenerGroup<T> eventListenerGroup(EventType<T> eventType) {
        return this.factory.getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(eventType);
    }

    @Override
    public Serializable save(Object object) throws HibernateException {
        return this.save(null, object);
    }

    @Override
    public Serializable save(String string, Object object) throws HibernateException {
        return this.fireSave(new SaveOrUpdateEvent(string, object, this));
    }

    private Serializable fireSave(SaveOrUpdateEvent saveOrUpdateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (SaveOrUpdateEventListener saveOrUpdateEventListener : this.listeners(EventType.SAVE)) {
            saveOrUpdateEventListener.onSaveOrUpdate(saveOrUpdateEvent);
        }
        this.checkNoUnresolvedActionsAfterOperation();
        return saveOrUpdateEvent.getResultId();
    }

    @Override
    public void update(Object object) throws HibernateException {
        this.update(null, object);
    }

    @Override
    public void update(String string, Object object) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(string, object, this));
    }

    private void fireUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (SaveOrUpdateEventListener saveOrUpdateEventListener : this.listeners(EventType.UPDATE)) {
            saveOrUpdateEventListener.onSaveOrUpdate(saveOrUpdateEvent);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    @Override
    public void lock(String string, Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(string, object, lockMode, (EventSource)this));
    }

    @Override
    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return new LockRequestImpl(lockOptions);
    }

    @Override
    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(object, lockMode, (EventSource)this));
    }

    private void fireLock(String string, Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(string, object, lockOptions, (EventSource)this));
    }

    private void fireLock(Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(object, lockOptions, (EventSource)this));
    }

    private void fireLock(LockEvent lockEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (LockEventListener lockEventListener : this.listeners(EventType.LOCK)) {
            lockEventListener.onLock(lockEvent);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void persist(String string, Object object) throws HibernateException {
        this.firePersist(new PersistEvent(string, object, this));
    }

    @Override
    public void persist(Object object) throws HibernateException {
        this.persist(null, object);
    }

    @Override
    public void persist(String string, Object object, Map map) throws HibernateException {
        this.firePersist(map, new PersistEvent(string, object, this));
    }

    private void firePersist(Map map, PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener persistEventListener : this.listeners(EventType.PERSIST)) {
            persistEventListener.onPersist(persistEvent, map);
        }
        this.delayedAfterCompletion();
    }

    private void firePersist(PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (PersistEventListener persistEventListener : this.listeners(EventType.PERSIST)) {
            persistEventListener.onPersist(persistEvent);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    public void persistOnFlush(String string, Object object) throws HibernateException {
        this.firePersistOnFlush(new PersistEvent(string, object, this));
    }

    public void persistOnFlush(Object object) throws HibernateException {
        this.persist(null, object);
    }

    @Override
    public void persistOnFlush(String string, Object object, Map map) throws HibernateException {
        this.firePersistOnFlush(map, new PersistEvent(string, object, this));
    }

    private void firePersistOnFlush(Map map, PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener persistEventListener : this.listeners(EventType.PERSIST_ONFLUSH)) {
            persistEventListener.onPersist(persistEvent, map);
        }
        this.delayedAfterCompletion();
    }

    private void firePersistOnFlush(PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (PersistEventListener persistEventListener : this.listeners(EventType.PERSIST_ONFLUSH)) {
            persistEventListener.onPersist(persistEvent);
        }
        this.checkNoUnresolvedActionsAfterOperation();
    }

    @Override
    public Object merge(String string, Object object) throws HibernateException {
        return this.fireMerge(new MergeEvent(string, object, this));
    }

    @Override
    public Object merge(Object object) throws HibernateException {
        return this.merge(null, object);
    }

    @Override
    public void merge(String string, Object object, Map map) throws HibernateException {
        this.fireMerge(map, new MergeEvent(string, object, this));
    }

    private Object fireMerge(MergeEvent mergeEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        for (MergeEventListener mergeEventListener : this.listeners(EventType.MERGE)) {
            mergeEventListener.onMerge(mergeEvent);
        }
        this.checkNoUnresolvedActionsAfterOperation();
        return mergeEvent.getResult();
    }

    private void fireMerge(Map map, MergeEvent mergeEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (MergeEventListener mergeEventListener : this.listeners(EventType.MERGE)) {
            mergeEventListener.onMerge(mergeEvent, map);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void delete(Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(object, this));
    }

    @Override
    public void delete(String string, Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(string, object, this));
    }

    @Override
    public void delete(String string, Object object, boolean bl, Set set) throws HibernateException {
        this.fireDelete(new DeleteEvent(string, object, bl, this), set);
    }

    private void fireDelete(DeleteEvent deleteEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (DeleteEventListener deleteEventListener : this.listeners(EventType.DELETE)) {
            deleteEventListener.onDelete(deleteEvent);
        }
        this.delayedAfterCompletion();
    }

    private void fireDelete(DeleteEvent deleteEvent, Set set) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (DeleteEventListener deleteEventListener : this.listeners(EventType.DELETE)) {
            deleteEventListener.onDelete(deleteEvent, set);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void load(Object object, Serializable serializable) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, object, this);
        this.fireLoad(loadEvent, LoadEventListener.RELOAD);
    }

    @Override
    public Object load(Class clazz, Serializable serializable) throws HibernateException {
        return this.byId(clazz).getReference(serializable);
    }

    @Override
    public Object load(String string, Serializable serializable) throws HibernateException {
        return this.byId(string).getReference(serializable);
    }

    @Override
    public Object get(Class clazz, Serializable serializable) throws HibernateException {
        return this.byId(clazz).load(serializable);
    }

    @Override
    public Object get(String string, Serializable serializable) throws HibernateException {
        return this.byId(string).load(serializable);
    }

    @Override
    public Object immediateLoad(String string, Serializable serializable) throws HibernateException {
        Object object;
        if (LOG.isDebugEnabled()) {
            object = this.getFactory().getEntityPersister(string);
            LOG.debugf("Initializing proxy: %s", (Object)MessageHelper.infoString((EntityPersister)object, serializable, this.getFactory()));
        }
        object = new LoadEvent(serializable, string, true, (EventSource)this);
        this.fireLoad((LoadEvent)object, LoadEventListener.IMMEDIATE_LOAD);
        return ((LoadEvent)object).getResult();
    }

    @Override
    public Object internalLoad(String string, Serializable serializable, boolean bl, boolean bl2) throws HibernateException {
        LoadEventListener.LoadType loadType = bl2 ? LoadEventListener.INTERNAL_LOAD_NULLABLE : (bl ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY);
        LoadEvent loadEvent = new LoadEvent(serializable, string, true, (EventSource)this);
        this.fireLoad(loadEvent, loadType);
        if (!bl2) {
            UnresolvableObjectException.throwIfNull(loadEvent.getResult(), serializable, string);
        }
        return loadEvent.getResult();
    }

    @Override
    public Object load(Class clazz, Serializable serializable, LockMode lockMode) throws HibernateException {
        return this.byId(clazz).with(new LockOptions(lockMode)).getReference(serializable);
    }

    @Override
    public Object load(Class clazz, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.byId(clazz).with(lockOptions).getReference(serializable);
    }

    @Override
    public Object load(String string, Serializable serializable, LockMode lockMode) throws HibernateException {
        return this.byId(string).with(new LockOptions(lockMode)).getReference(serializable);
    }

    @Override
    public Object load(String string, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.byId(string).with(lockOptions).getReference(serializable);
    }

    @Override
    public Object get(Class clazz, Serializable serializable, LockMode lockMode) throws HibernateException {
        return this.byId(clazz).with(new LockOptions(lockMode)).load(serializable);
    }

    @Override
    public Object get(Class clazz, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.byId(clazz).with(lockOptions).load(serializable);
    }

    @Override
    public Object get(String string, Serializable serializable, LockMode lockMode) throws HibernateException {
        return this.byId(string).with(new LockOptions(lockMode)).load(serializable);
    }

    @Override
    public Object get(String string, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.byId(string).with(lockOptions).load(serializable);
    }

    @Override
    public IdentifierLoadAccessImpl byId(String string) {
        return new IdentifierLoadAccessImpl(string);
    }

    @Override
    public IdentifierLoadAccessImpl byId(Class clazz) {
        return new IdentifierLoadAccessImpl(clazz);
    }

    @Override
    public NaturalIdLoadAccess byNaturalId(String string) {
        return new NaturalIdLoadAccessImpl(string);
    }

    @Override
    public NaturalIdLoadAccess byNaturalId(Class clazz) {
        return new NaturalIdLoadAccessImpl(clazz);
    }

    @Override
    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String string) {
        return new SimpleNaturalIdLoadAccessImpl(string);
    }

    @Override
    public SimpleNaturalIdLoadAccess bySimpleNaturalId(Class clazz) {
        return new SimpleNaturalIdLoadAccessImpl(clazz);
    }

    private void fireLoad(LoadEvent loadEvent, LoadEventListener.LoadType loadType) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (LoadEventListener loadEventListener : this.listeners(EventType.LOAD)) {
            loadEventListener.onLoad(loadEvent, loadType);
        }
        this.delayedAfterCompletion();
    }

    private void fireResolveNaturalId(ResolveNaturalIdEvent resolveNaturalIdEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (ResolveNaturalIdEventListener resolveNaturalIdEventListener : this.listeners(EventType.RESOLVE_NATURAL_ID)) {
            resolveNaturalIdEventListener.onResolveNaturalId(resolveNaturalIdEvent);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void refresh(Object object) throws HibernateException {
        this.refresh(null, object);
    }

    @Override
    public void refresh(String string, Object object) throws HibernateException {
        this.fireRefresh(new RefreshEvent(string, object, (EventSource)this));
    }

    @Override
    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockMode, (EventSource)this));
    }

    @Override
    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.refresh(null, object, lockOptions);
    }

    @Override
    public void refresh(String string, Object object, LockOptions lockOptions) throws HibernateException {
        this.fireRefresh(new RefreshEvent(string, object, lockOptions, this));
    }

    @Override
    public void refresh(Object object, Map map) throws HibernateException {
        this.fireRefresh(map, new RefreshEvent(object, this));
    }

    private void fireRefresh(RefreshEvent refreshEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (RefreshEventListener refreshEventListener : this.listeners(EventType.REFRESH)) {
            refreshEventListener.onRefresh(refreshEvent);
        }
        this.delayedAfterCompletion();
    }

    private void fireRefresh(Map map, RefreshEvent refreshEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (RefreshEventListener refreshEventListener : this.listeners(EventType.REFRESH)) {
            refreshEventListener.onRefresh(refreshEvent, map);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(object, replicationMode, this));
    }

    @Override
    public void replicate(String string, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(string, object, replicationMode, this));
    }

    private void fireReplicate(ReplicateEvent replicateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (ReplicateEventListener replicateEventListener : this.listeners(EventType.REPLICATE)) {
            replicateEventListener.onReplicate(replicateEvent);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void evict(Object object) throws HibernateException {
        this.fireEvict(new EvictEvent(object, this));
    }

    private void fireEvict(EvictEvent evictEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (EvictEventListener evictEventListener : this.listeners(EventType.EVICT)) {
            evictEventListener.onEvict(evictEvent);
        }
        this.delayedAfterCompletion();
    }

    protected boolean autoFlushIfRequired(Set set) throws HibernateException {
        this.errorIfClosed();
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent autoFlushEvent = new AutoFlushEvent(set, this);
        for (AutoFlushEventListener autoFlushEventListener : this.listeners(EventType.AUTO_FLUSH)) {
            autoFlushEventListener.onAutoFlush(autoFlushEvent);
        }
        return autoFlushEvent.isFlushRequired();
    }

    @Override
    public boolean isDirty() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.debug("Checking session dirtiness");
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            LOG.debug("Session dirty (scheduled updates and insertions)");
            return true;
        }
        DirtyCheckEvent dirtyCheckEvent = new DirtyCheckEvent(this);
        for (DirtyCheckEventListener dirtyCheckEventListener : this.listeners(EventType.DIRTY_CHECK)) {
            dirtyCheckEventListener.onDirtyCheck(dirtyCheckEvent);
        }
        this.delayedAfterCompletion();
        return dirtyCheckEvent.isDirty();
    }

    @Override
    public void flush() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new HibernateException("Flush during cascade is dangerous");
        }
        FlushEvent flushEvent = new FlushEvent(this);
        for (FlushEventListener flushEventListener : this.listeners(EventType.FLUSH)) {
            flushEventListener.onFlush(flushEvent);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void forceFlush(EntityEntry entityEntry) throws HibernateException {
        this.errorIfClosed();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Flushing to force deletion of re-saved object: %s", (Object)MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), this.getFactory()));
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        List list = Collections.EMPTY_LIST;
        boolean bl = false;
        ++this.dontFlushFromFind;
        try {
            list = hQLQueryPlan.performList(queryParameters, this);
            bl = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(bl);
            this.delayedAfterCompletion();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        boolean bl = false;
        int n = 0;
        try {
            n = hQLQueryPlan.performExecuteUpdate(queryParameters, this);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
            this.delayedAfterCompletion();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        NativeSQLQueryPlan nativeSQLQueryPlan = this.getNativeSQLQueryPlan(nativeSQLQuerySpecification);
        this.autoFlushIfRequired(nativeSQLQueryPlan.getCustomQuery().getQuerySpaces());
        boolean bl = false;
        int n = 0;
        try {
            n = nativeSQLQueryPlan.performExecuteUpdate(queryParameters, this);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
            this.delayedAfterCompletion();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterate(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, true);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            Iterator iterator = hQLQueryPlan.performIterate(queryParameters, this);
            return iterator;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = hQLQueryPlan.performScroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    @Override
    public Query createFilter(Object object, String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        CollectionFilterImpl collectionFilterImpl = new CollectionFilterImpl(string, object, (SessionImplementor)this, this.getFilterQueryPlan(object, string, null, false).getParameterMetadata());
        collectionFilterImpl.setComment(string);
        this.delayedAfterCompletion();
        return collectionFilterImpl;
    }

    @Override
    public Query getNamedQuery(String string) throws MappingException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        Query query = super.getNamedQuery(string);
        this.delayedAfterCompletion();
        return query;
    }

    @Override
    public Object instantiate(String string, Serializable serializable) throws HibernateException {
        return this.instantiate(this.factory.getEntityPersister(string), serializable);
    }

    @Override
    public Object instantiate(EntityPersister entityPersister, Serializable serializable) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        Object object = this.interceptor.instantiate(entityPersister.getEntityName(), entityPersister.getEntityMetamodel().getEntityMode(), serializable);
        if (object == null) {
            object = entityPersister.instantiate(serializable, this);
        }
        this.delayedAfterCompletion();
        return object;
    }

    @Override
    public void setFlushMode(FlushMode flushMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.tracev("Setting flush mode to: {0}", (Object)flushMode);
        this.flushMode = flushMode;
    }

    @Override
    public FlushMode getFlushMode() {
        this.checkTransactionSynchStatus();
        return this.flushMode;
    }

    @Override
    public CacheMode getCacheMode() {
        this.checkTransactionSynchStatus();
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.tracev("Setting cache mode to: {0}", (Object)cacheMode);
        this.cacheMode = cacheMode;
    }

    @Override
    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        return this.transactionCoordinator.getTransaction();
    }

    @Override
    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        Transaction transaction = this.getTransaction();
        transaction.begin();
        return transaction;
    }

    @Override
    public EntityPersister getEntityPersister(String string, Object object) {
        this.errorIfClosed();
        if (string == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        try {
            return this.factory.getEntityPersister(string).getSubclassEntityPersister(object, this.getFactory());
        }
        catch (HibernateException hibernateException) {
            try {
                return this.getEntityPersister(null, object);
            }
            catch (HibernateException hibernateException2) {
                throw hibernateException;
            }
        }
    }

    @Override
    public Serializable getIdentifier(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (lazyInitializer.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return lazyInitializer.getIdentifier();
        }
        EntityEntry entityEntry = this.persistenceContext.getEntry(object);
        if (entityEntry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entityEntry.getId();
    }

    @Override
    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        if (object instanceof HibernateProxy) {
            return this.getProxyIdentifier(object);
        }
        EntityEntry entityEntry = this.persistenceContext.getEntry(object);
        return entityEntry != null ? entityEntry.getId() : null;
    }

    private Serializable getProxyIdentifier(Object object) {
        return ((HibernateProxy)object).getHibernateLazyInitializer().getIdentifier();
    }

    private FilterQueryPlan getFilterQueryPlan(Object object, String string, QueryParameters queryParameters, boolean bl) throws HibernateException {
        if (object == null) {
            throw new NullPointerException("null collection passed to filter");
        }
        CollectionEntry collectionEntry = this.persistenceContext.getCollectionEntryOrNull(object);
        CollectionPersister collectionPersister = collectionEntry == null ? null : collectionEntry.getLoadedPersister();
        FilterQueryPlan filterQueryPlan = null;
        if (collectionPersister == null) {
            CollectionPersister collectionPersister2;
            this.flush();
            collectionEntry = this.persistenceContext.getCollectionEntryOrNull(object);
            CollectionPersister collectionPersister3 = collectionPersister2 = collectionEntry == null ? null : collectionEntry.getLoadedPersister();
            if (collectionPersister2 == null) {
                throw new QueryException("The collection was unreferenced");
            }
            filterQueryPlan = this.factory.getQueryPlanCache().getFilterQueryPlan(string, collectionPersister2.getRole(), bl, this.getEnabledFilters());
        } else {
            filterQueryPlan = this.factory.getQueryPlanCache().getFilterQueryPlan(string, collectionPersister.getRole(), bl, this.getEnabledFilters());
            if (this.autoFlushIfRequired(filterQueryPlan.getQuerySpaces())) {
                CollectionPersister collectionPersister4;
                collectionEntry = this.persistenceContext.getCollectionEntryOrNull(object);
                CollectionPersister collectionPersister5 = collectionPersister4 = collectionEntry == null ? null : collectionEntry.getLoadedPersister();
                if (collectionPersister != collectionPersister4) {
                    if (collectionPersister4 == null) {
                        throw new QueryException("The collection was dereferenced");
                    }
                    filterQueryPlan = this.factory.getQueryPlanCache().getFilterQueryPlan(string, collectionPersister4.getRole(), bl, this.getEnabledFilters());
                }
            }
        }
        if (queryParameters != null) {
            queryParameters.getPositionalParameterValues()[0] = collectionEntry.getLoadedKey();
            queryParameters.getPositionalParameterTypes()[0] = collectionEntry.getLoadedPersister().getKeyType();
        }
        return filterQueryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listFilter(Object object, String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan filterQueryPlan = this.getFilterQueryPlan(object, string, queryParameters, false);
        List list = Collections.EMPTY_LIST;
        boolean bl = false;
        ++this.dontFlushFromFind;
        try {
            list = filterQueryPlan.performList(queryParameters, this);
            bl = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(bl);
            this.delayedAfterCompletion();
        }
        return list;
    }

    @Override
    public Iterator iterateFilter(Object object, String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan filterQueryPlan = this.getFilterQueryPlan(object, string, queryParameters, true);
        Iterator iterator = filterQueryPlan.performIterate(queryParameters, this);
        this.delayedAfterCompletion();
        return iterator;
    }

    @Override
    public Criteria createCriteria(Class clazz, String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(clazz.getName(), string, this);
    }

    @Override
    public Criteria createCriteria(String string, String string2) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(string, string2, this);
    }

    @Override
    public Criteria createCriteria(Class clazz) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(clazz.getName(), this);
    }

    @Override
    public Criteria createCriteria(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(string, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(Criteria criteria, ScrollMode scrollMode) {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String string = criteriaImpl.getEntityOrClassName();
        CriteriaLoader criteriaLoader = new CriteriaLoader(this.getOuterJoinLoadable(string), this.factory, criteriaImpl, string, this.getLoadQueryInfluencers());
        this.autoFlushIfRequired(criteriaLoader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = criteriaLoader.scroll(this, scrollMode);
            return scrollableResults;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(Criteria criteria) throws HibernateException {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        NaturalIdLoadAccess naturalIdLoadAccess = this.tryNaturalIdLoadAccess(criteriaImpl);
        if (naturalIdLoadAccess != null) {
            return Arrays.asList(naturalIdLoadAccess.load());
        }
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String[] stringArray = this.factory.getImplementors(criteriaImpl.getEntityOrClassName());
        int n = stringArray.length;
        CriteriaLoader[] criteriaLoaderArray = new CriteriaLoader[n];
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            criteriaLoaderArray[i] = new CriteriaLoader(this.getOuterJoinLoadable(stringArray[i]), this.factory, criteriaImpl, stringArray[i], this.getLoadQueryInfluencers());
            hashSet.addAll(criteriaLoaderArray[i].getQuerySpaces());
        }
        this.autoFlushIfRequired(hashSet);
        List list = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        boolean bl = false;
        try {
            for (int i = 0; i < n; ++i) {
                List list2 = criteriaLoaderArray[i].list(this);
                list2.addAll(list);
                list = list2;
            }
            bl = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(bl);
            this.delayedAfterCompletion();
        }
        return list;
    }

    private NaturalIdLoadAccess tryNaturalIdLoadAccess(CriteriaImpl criteriaImpl) {
        if (!criteriaImpl.isLookupByNaturalKey()) {
            return null;
        }
        String string = criteriaImpl.getEntityOrClassName();
        EntityPersister entityPersister = this.factory.getEntityPersister(string);
        if (!entityPersister.hasNaturalIdentifier()) {
            return null;
        }
        CriteriaImpl.CriterionEntry criterionEntry = (CriteriaImpl.CriterionEntry)criteriaImpl.iterateExpressionEntries().next();
        NaturalIdentifier naturalIdentifier = (NaturalIdentifier)criterionEntry.getCriterion();
        Map<String, Object> map = naturalIdentifier.getNaturalIdValues();
        int[] nArray = entityPersister.getNaturalIdentifierProperties();
        if (nArray.length != map.size()) {
            return null;
        }
        String[] stringArray = entityPersister.getPropertyNames();
        NaturalIdLoadAccess naturalIdLoadAccess = this.byNaturalId(string);
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = stringArray[nArray[i]];
            Object object = map.get(string2);
            if (object == null) {
                return null;
            }
            naturalIdLoadAccess.using(string2, object);
        }
        LOG.warn("Session.byNaturalId(" + string + ") should be used for naturalId queries instead of Restrictions.naturalId() from a Criteria");
        return naturalIdLoadAccess;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String string) throws MappingException {
        EntityPersister entityPersister = this.factory.getEntityPersister(string);
        if (!(entityPersister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + string);
        }
        return (OuterJoinLoadable)entityPersister;
    }

    @Override
    public boolean contains(Object object) {
        Object object2;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            object2 = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (object2.isUninitialized()) {
                return object2.getSession() == this;
            }
            object = object2.getImplementation();
        }
        object2 = this.persistenceContext.getEntry(object);
        this.delayedAfterCompletion();
        return object2 != null && ((EntityEntry)object2).getStatus() != Status.DELETED && ((EntityEntry)object2).getStatus() != Status.GONE;
    }

    @Override
    public Query createQuery(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createQuery(string);
    }

    @Override
    public SQLQuery createSQLQuery(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createSQLQuery(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Scroll SQL query: {0}", (Object)customQuery.getSQL());
        }
        CustomLoader customLoader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(customLoader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = customLoader.scroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            this.delayedAfterCompletion();
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("SQL query: {0}", (Object)customQuery.getSQL());
        }
        CustomLoader customLoader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(customLoader.getQuerySpaces());
        ++this.dontFlushFromFind;
        boolean bl = false;
        try {
            List list = customLoader.list(this, queryParameters);
            bl = true;
            List list2 = list;
            return list2;
        }
        finally {
            --this.dontFlushFromFind;
            this.delayedAfterCompletion();
            this.afterOperation(bl);
        }
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        this.checkTransactionSynchStatus();
        return this.factory;
    }

    @Override
    public void initializeCollection(PersistentCollection persistentCollection, boolean bl) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        InitializeCollectionEvent initializeCollectionEvent = new InitializeCollectionEvent(persistentCollection, this);
        for (InitializeCollectionEventListener initializeCollectionEventListener : this.listeners(EventType.INIT_COLLECTION)) {
            initializeCollectionEventListener.onInitializeCollection(initializeCollectionEvent);
        }
        this.delayedAfterCompletion();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        Object object2;
        if (object instanceof HibernateProxy) {
            object2 = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (object2.isUninitialized()) {
                return object2.getEntityName();
            }
            object = object2.getImplementation();
        }
        if ((object2 = this.persistenceContext.getEntry(object)) == null) {
            return this.guessEntityName(object);
        }
        return ((EntityEntry)object2).getPersister().getEntityName();
    }

    @Override
    public String getEntityName(Object object) {
        EntityEntry entityEntry;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            if (!this.persistenceContext.containsProxy(object)) {
                throw new TransientObjectException("proxy was not associated with the session");
            }
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        if ((entityEntry = this.persistenceContext.getEntry(object)) == null) {
            this.throwTransientObjectException(object);
        }
        return entityEntry.getPersister().getEntityName();
    }

    private void throwTransientObjectException(Object object) throws HibernateException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + this.guessEntityName(object));
    }

    @Override
    public String guessEntityName(Object object) throws HibernateException {
        this.errorIfClosed();
        return this.entityNameResolver.resolveEntityName(object);
    }

    @Override
    public void cancelQuery() throws HibernateException {
        this.errorIfClosed();
        this.getTransactionCoordinator().getJdbcCoordinator().cancelLastQuery();
    }

    @Override
    public Interceptor getInterceptor() {
        this.checkTransactionSynchStatus();
        return this.interceptor;
    }

    @Override
    public int getDontFlushFromFind() {
        return this.dontFlushFromFind;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(500).append("SessionImpl(");
        if (!this.isClosed()) {
            stringBuilder.append(this.persistenceContext).append(";").append(this.actionQueue);
        } else {
            stringBuilder.append("<closed>");
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public ActionQueue getActionQueue() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.actionQueue;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext;
    }

    @Override
    public SessionStatistics getStatistics() {
        this.checkTransactionSynchStatus();
        return new SessionStatisticsImpl(this);
    }

    @Override
    public boolean isEventSource() {
        this.checkTransactionSynchStatus();
        return true;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.persistenceContext.isDefaultReadOnly();
    }

    @Override
    public void setDefaultReadOnly(boolean bl) {
        this.persistenceContext.setDefaultReadOnly(bl);
    }

    @Override
    public boolean isReadOnly(Object object) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext.isReadOnly(object);
    }

    @Override
    public void setReadOnly(Object object, boolean bl) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.setReadOnly(object, bl);
    }

    @Override
    public void doWork(final Work work) throws HibernateException {
        WorkExecutorVisitable<Void> workExecutorVisitable = new WorkExecutorVisitable<Void>(){

            @Override
            public Void accept(WorkExecutor<Void> workExecutor, Connection connection) throws SQLException {
                workExecutor.executeWork(work, connection);
                return null;
            }
        };
        this.doWork(workExecutorVisitable);
    }

    @Override
    public <T> T doReturningWork(final ReturningWork<T> returningWork) throws HibernateException {
        WorkExecutorVisitable workExecutorVisitable = new WorkExecutorVisitable<T>(){

            @Override
            public T accept(WorkExecutor<T> workExecutor, Connection connection) throws SQLException {
                return workExecutor.executeReturningWork(returningWork, connection);
            }
        };
        return this.doWork(workExecutorVisitable);
    }

    private <T> T doWork(WorkExecutorVisitable<T> workExecutorVisitable) throws HibernateException {
        return this.transactionCoordinator.getJdbcCoordinator().coordinateWork(workExecutorVisitable);
    }

    @Override
    public void afterScrollOperation() {
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        this.errorIfClosed();
        return this.transactionCoordinator;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    @Override
    public Filter getEnabledFilter(String string) {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilter(string);
    }

    @Override
    public Filter enableFilter(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.enableFilter(string);
    }

    @Override
    public void disableFilter(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.disableFilter(string);
    }

    @Override
    public Object getFilterParameterValue(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterValue(string);
    }

    @Override
    public Type getFilterParameterType(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterType(string);
    }

    @Override
    public Map getEnabledFilters() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilters();
    }

    @Override
    public String getFetchProfile() {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getInternalFetchProfile();
    }

    @Override
    public void setFetchProfile(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.setInternalFetchProfile(string);
    }

    @Override
    public boolean isFetchProfileEnabled(String string) throws UnknownProfileException {
        return this.loadQueryInfluencers.isFetchProfileEnabled(string);
    }

    @Override
    public void enableFetchProfile(String string) throws UnknownProfileException {
        this.loadQueryInfluencers.enableFetchProfile(string);
    }

    @Override
    public void disableFetchProfile(String string) throws UnknownProfileException {
        this.loadQueryInfluencers.disableFetchProfile(string);
    }

    private void checkTransactionSynchStatus() {
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
    }

    private void pulseTransactionCoordinator() {
        if (!this.isClosed()) {
            this.transactionCoordinator.pulse();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing session");
        objectInputStream.defaultReadObject();
        this.entityNameResolver = new CoordinatingEntityNameResolver();
        this.connectionReleaseMode = ConnectionReleaseMode.parse((String)objectInputStream.readObject());
        this.autoClear = objectInputStream.readBoolean();
        this.autoJoinTransactions = objectInputStream.readBoolean();
        this.flushMode = FlushMode.valueOf((String)objectInputStream.readObject());
        this.cacheMode = CacheMode.valueOf((String)objectInputStream.readObject());
        this.flushBeforeCompletionEnabled = objectInputStream.readBoolean();
        this.autoCloseSessionEnabled = objectInputStream.readBoolean();
        this.interceptor = (Interceptor)objectInputStream.readObject();
        this.factory = SessionFactoryImpl.deserialize(objectInputStream);
        this.sessionOwner = (SessionOwner)objectInputStream.readObject();
        this.transactionCoordinator = TransactionCoordinatorImpl.deserialize(objectInputStream, this);
        this.persistenceContext = StatefulPersistenceContext.deserialize(objectInputStream, this);
        this.actionQueue = ActionQueue.deserialize(objectInputStream, this);
        this.loadQueryInfluencers = (LoadQueryInfluencers)objectInputStream.readObject();
        for (String string : this.loadQueryInfluencers.getEnabledFilterNames()) {
            ((FilterImpl)this.loadQueryInfluencers.getEnabledFilter(string)).afterDeserialize(this.factory);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.transactionCoordinator.getJdbcCoordinator().isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize a session while connected");
        }
        LOG.trace("Serializing session");
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.connectionReleaseMode.toString());
        objectOutputStream.writeBoolean(this.autoClear);
        objectOutputStream.writeBoolean(this.autoJoinTransactions);
        objectOutputStream.writeObject(this.flushMode.toString());
        objectOutputStream.writeObject(this.cacheMode.name());
        objectOutputStream.writeBoolean(this.flushBeforeCompletionEnabled);
        objectOutputStream.writeBoolean(this.autoCloseSessionEnabled);
        objectOutputStream.writeObject(this.interceptor);
        this.factory.serialize(objectOutputStream);
        objectOutputStream.writeObject(this.sessionOwner);
        this.transactionCoordinator.serialize(objectOutputStream);
        this.persistenceContext.serialize(objectOutputStream);
        this.actionQueue.serialize(objectOutputStream);
        objectOutputStream.writeObject(this.loadQueryInfluencers);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.getSessionFactory().getTypeHelper();
    }

    @Override
    public LobHelper getLobHelper() {
        if (this.lobHelper == null) {
            this.lobHelper = new LobHelperImpl(this);
        }
        return this.lobHelper;
    }

    private EntityPersister locateEntityPersister(String string) {
        EntityPersister entityPersister = this.factory.getEntityPersister(string);
        if (entityPersister == null) {
            throw new HibernateException("Unable to locate persister: " + string);
        }
        return entityPersister;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleNaturalIdLoadAccessImpl
    extends BaseNaturalIdLoadAccessImpl
    implements SimpleNaturalIdLoadAccess {
        private final String naturalIdAttributeName;

        private SimpleNaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            super(entityPersister);
            if (entityPersister.getNaturalIdentifierProperties().length != 1) {
                throw new HibernateException(String.format("Entity [%s] did not define a simple natural id", entityPersister.getEntityName()));
            }
            int n = entityPersister.getNaturalIdentifierProperties()[0];
            this.naturalIdAttributeName = entityPersister.getPropertyNames()[n];
        }

        private SimpleNaturalIdLoadAccessImpl(String string) {
            this(sessionImpl.locateEntityPersister(string));
        }

        private SimpleNaturalIdLoadAccessImpl(Class clazz) {
            this(clazz.getName());
        }

        @Override
        public final SimpleNaturalIdLoadAccessImpl with(LockOptions lockOptions) {
            return (SimpleNaturalIdLoadAccessImpl)super.with(lockOptions);
        }

        private Map<String, Object> getNaturalIdParameters(Object object) {
            return Collections.singletonMap(this.naturalIdAttributeName, object);
        }

        @Override
        public SimpleNaturalIdLoadAccessImpl setSynchronizationEnabled(boolean bl) {
            super.synchronizationEnabled(bl);
            return this;
        }

        @Override
        public Object getReference(Object object) {
            Serializable serializable = this.resolveNaturalId(this.getNaturalIdParameters(object));
            if (serializable == null) {
                return null;
            }
            return this.getIdentifierLoadAccess().getReference(serializable);
        }

        @Override
        public Object load(Object object) {
            Serializable serializable = this.resolveNaturalId(this.getNaturalIdParameters(object));
            if (serializable == null) {
                return null;
            }
            try {
                return this.getIdentifierLoadAccess().load(serializable);
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    private class NaturalIdLoadAccessImpl
    extends BaseNaturalIdLoadAccessImpl
    implements NaturalIdLoadAccess {
        private final Map<String, Object> naturalIdParameters;

        private NaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            super(entityPersister);
            this.naturalIdParameters = new LinkedHashMap<String, Object>();
        }

        private NaturalIdLoadAccessImpl(String string) {
            this(sessionImpl.locateEntityPersister(string));
        }

        private NaturalIdLoadAccessImpl(Class clazz) {
            this(clazz.getName());
        }

        public NaturalIdLoadAccessImpl with(LockOptions lockOptions) {
            return (NaturalIdLoadAccessImpl)super.with(lockOptions);
        }

        public NaturalIdLoadAccess using(String string, Object object) {
            this.naturalIdParameters.put(string, object);
            return this;
        }

        public NaturalIdLoadAccessImpl setSynchronizationEnabled(boolean bl) {
            super.synchronizationEnabled(bl);
            return this;
        }

        public final Object getReference() {
            Serializable serializable = this.resolveNaturalId(this.naturalIdParameters);
            if (serializable == null) {
                return null;
            }
            return this.getIdentifierLoadAccess().getReference(serializable);
        }

        public final Object load() {
            Serializable serializable = this.resolveNaturalId(this.naturalIdParameters);
            if (serializable == null) {
                return null;
            }
            try {
                return this.getIdentifierLoadAccess().load(serializable);
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseNaturalIdLoadAccessImpl {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;
        private boolean synchronizationEnabled = true;

        private BaseNaturalIdLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
            if (!entityPersister.hasNaturalIdentifier()) {
                throw new HibernateException(String.format("Entity [%s] did not define a natural id", entityPersister.getEntityName()));
            }
        }

        private BaseNaturalIdLoadAccessImpl(String string) {
            this(sessionImpl.locateEntityPersister(string));
        }

        private BaseNaturalIdLoadAccessImpl(Class clazz) {
            this(clazz.getName());
        }

        public BaseNaturalIdLoadAccessImpl with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        protected void synchronizationEnabled(boolean bl) {
            this.synchronizationEnabled = bl;
        }

        protected final Serializable resolveNaturalId(Map<String, Object> map) {
            this.performAnyNeededCrossReferenceSynchronizations();
            ResolveNaturalIdEvent resolveNaturalIdEvent = new ResolveNaturalIdEvent(map, this.entityPersister, SessionImpl.this);
            SessionImpl.this.fireResolveNaturalId(resolveNaturalIdEvent);
            if (resolveNaturalIdEvent.getEntityId() == PersistenceContext.NaturalIdHelper.INVALID_NATURAL_ID_REFERENCE) {
                return null;
            }
            return resolveNaturalIdEvent.getEntityId();
        }

        protected void performAnyNeededCrossReferenceSynchronizations() {
            if (!this.synchronizationEnabled) {
                return;
            }
            if (this.entityPersister.getEntityMetamodel().hasImmutableNaturalId()) {
                return;
            }
            if (!SessionImpl.this.isTransactionInProgress()) {
                return;
            }
            boolean bl = LOG.isDebugEnabled();
            for (Serializable serializable : SessionImpl.this.getPersistenceContext().getNaturalIdHelper().getCachedPkResolutions(this.entityPersister)) {
                EntityKey entityKey = SessionImpl.this.generateEntityKey(serializable, this.entityPersister);
                Object object = SessionImpl.this.getPersistenceContext().getEntity(entityKey);
                EntityEntry entityEntry = SessionImpl.this.getPersistenceContext().getEntry(object);
                if (entityEntry == null) {
                    if (!bl) continue;
                    LOG.debug("Cached natural-id/pk resolution linked to null EntityEntry in persistence context : " + MessageHelper.infoString(this.entityPersister, serializable, SessionImpl.this.getFactory()));
                    continue;
                }
                if (!entityEntry.requiresDirtyCheck(object) || entityEntry.getStatus() != Status.MANAGED) continue;
                SessionImpl.this.getPersistenceContext().getNaturalIdHelper().handleSynchronization(this.entityPersister, serializable, object);
            }
        }

        protected final IdentifierLoadAccess getIdentifierLoadAccess() {
            IdentifierLoadAccessImpl identifierLoadAccessImpl = new IdentifierLoadAccessImpl(this.entityPersister);
            if (this.lockOptions != null) {
                identifierLoadAccessImpl.with(this.lockOptions);
            }
            return identifierLoadAccessImpl;
        }

        protected EntityPersister entityPersister() {
            return this.entityPersister;
        }
    }

    private class IdentifierLoadAccessImpl
    implements IdentifierLoadAccess {
        private final EntityPersister entityPersister;
        private LockOptions lockOptions;

        private IdentifierLoadAccessImpl(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
        }

        private IdentifierLoadAccessImpl(String string) {
            this(sessionImpl.locateEntityPersister(string));
        }

        private IdentifierLoadAccessImpl(Class clazz) {
            this(clazz.getName());
        }

        public final IdentifierLoadAccessImpl with(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object getReference(Serializable serializable) {
            if (this.lockOptions != null) {
                LoadEvent loadEvent = new LoadEvent(serializable, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)SessionImpl.this);
                SessionImpl.this.fireLoad(loadEvent, LoadEventListener.LOAD);
                return loadEvent.getResult();
            }
            LoadEvent loadEvent = new LoadEvent(serializable, this.entityPersister.getEntityName(), false, (EventSource)SessionImpl.this);
            boolean bl = false;
            try {
                SessionImpl.this.fireLoad(loadEvent, LoadEventListener.LOAD);
                if (loadEvent.getResult() == null) {
                    SessionImpl.this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityPersister.getEntityName(), serializable);
                }
                bl = true;
                Object object = loadEvent.getResult();
                return object;
            }
            finally {
                SessionImpl.this.afterOperation(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object load(Serializable serializable) {
            if (this.lockOptions != null) {
                LoadEvent loadEvent = new LoadEvent(serializable, this.entityPersister.getEntityName(), this.lockOptions, (EventSource)SessionImpl.this);
                SessionImpl.this.fireLoad(loadEvent, LoadEventListener.GET);
                return loadEvent.getResult();
            }
            LoadEvent loadEvent = new LoadEvent(serializable, this.entityPersister.getEntityName(), false, (EventSource)SessionImpl.this);
            boolean bl = false;
            try {
                SessionImpl.this.fireLoad(loadEvent, LoadEventListener.GET);
                bl = true;
                Object object = loadEvent.getResult();
                return object;
            }
            finally {
                SessionImpl.this.afterOperation(bl);
            }
        }
    }

    private class LockRequestImpl
    implements Session.LockRequest {
        private final LockOptions lockOptions = new LockOptions();

        private LockRequestImpl(LockOptions lockOptions) {
            LockOptions.copy(lockOptions, this.lockOptions);
        }

        public LockMode getLockMode() {
            return this.lockOptions.getLockMode();
        }

        public Session.LockRequest setLockMode(LockMode lockMode) {
            this.lockOptions.setLockMode(lockMode);
            return this;
        }

        public int getTimeOut() {
            return this.lockOptions.getTimeOut();
        }

        public Session.LockRequest setTimeOut(int n) {
            this.lockOptions.setTimeOut(n);
            return this;
        }

        public boolean getScope() {
            return this.lockOptions.getScope();
        }

        public Session.LockRequest setScope(boolean bl) {
            this.lockOptions.setScope(bl);
            return this;
        }

        public void lock(String string, Object object) throws HibernateException {
            SessionImpl.this.fireLock(string, object, this.lockOptions);
        }

        public void lock(Object object) throws HibernateException {
            SessionImpl.this.fireLock(object, this.lockOptions);
        }
    }

    private class CoordinatingEntityNameResolver
    implements EntityNameResolver {
        private CoordinatingEntityNameResolver() {
        }

        public String resolveEntityName(Object object) {
            EntityNameResolver entityNameResolver;
            String string = SessionImpl.this.interceptor.getEntityName(object);
            if (string != null) {
                return string;
            }
            Iterator<EntityNameResolver> iterator = SessionImpl.this.factory.iterateEntityNameResolvers().iterator();
            while (iterator.hasNext() && (string = (entityNameResolver = iterator.next()).resolveEntityName(object)) == null) {
            }
            if (string != null) {
                return string;
            }
            return object.getClass().getName();
        }
    }

    private static class SharedSessionBuilderImpl
    extends SessionFactoryImpl.SessionBuilderImpl
    implements SharedSessionBuilder {
        private final SessionImpl session;
        private boolean shareTransactionContext;

        private SharedSessionBuilderImpl(SessionImpl sessionImpl) {
            super(sessionImpl.factory);
            this.session = sessionImpl;
            super.owner(sessionImpl.sessionOwner);
            super.tenantIdentifier(sessionImpl.getTenantIdentifier());
        }

        public SessionBuilder tenantIdentifier(String string) {
            throw new SessionException("Cannot redefine tenant identifier on child session");
        }

        protected TransactionCoordinatorImpl getTransactionCoordinator() {
            return this.shareTransactionContext ? this.session.transactionCoordinator : super.getTransactionCoordinator();
        }

        public SharedSessionBuilder interceptor() {
            return this.interceptor(this.session.interceptor);
        }

        public SharedSessionBuilder connection() {
            this.shareTransactionContext = true;
            return this;
        }

        public SharedSessionBuilder connectionReleaseMode() {
            return this.connectionReleaseMode(this.session.connectionReleaseMode);
        }

        public SharedSessionBuilder autoJoinTransactions() {
            return this.autoJoinTransactions(this.session.autoJoinTransactions);
        }

        public SharedSessionBuilder autoClose() {
            return this.autoClose(this.session.autoCloseSessionEnabled);
        }

        public SharedSessionBuilder flushBeforeCompletion() {
            return this.flushBeforeCompletion(this.session.flushBeforeCompletionEnabled);
        }

        @Deprecated
        public SharedSessionBuilder transactionContext() {
            return this.connection();
        }

        public SharedSessionBuilder interceptor(Interceptor interceptor) {
            return (SharedSessionBuilder)super.interceptor(interceptor);
        }

        public SharedSessionBuilder noInterceptor() {
            return (SharedSessionBuilder)super.noInterceptor();
        }

        public SharedSessionBuilder connection(Connection connection) {
            return (SharedSessionBuilder)super.connection(connection);
        }

        public SharedSessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            return (SharedSessionBuilder)super.connectionReleaseMode(connectionReleaseMode);
        }

        public SharedSessionBuilder autoJoinTransactions(boolean bl) {
            return (SharedSessionBuilder)super.autoJoinTransactions(bl);
        }

        public SharedSessionBuilder autoClose(boolean bl) {
            return (SharedSessionBuilder)super.autoClose(bl);
        }

        public SharedSessionBuilder flushBeforeCompletion(boolean bl) {
            return (SharedSessionBuilder)super.flushBeforeCompletion(bl);
        }
    }

    private static class LobHelperImpl
    implements LobHelper {
        private final SessionImpl session;

        private LobHelperImpl(SessionImpl sessionImpl) {
            this.session = sessionImpl;
        }

        public Blob createBlob(byte[] byArray) {
            return this.lobCreator().createBlob(byArray);
        }

        private LobCreator lobCreator() {
            return NonContextualLobCreator.INSTANCE;
        }

        public Blob createBlob(InputStream inputStream, long l) {
            return this.lobCreator().createBlob(inputStream, l);
        }

        public Clob createClob(String string) {
            return this.lobCreator().createClob(string);
        }

        public Clob createClob(Reader reader, long l) {
            return this.lobCreator().createClob(reader, l);
        }

        public NClob createNClob(String string) {
            return this.lobCreator().createNClob(string);
        }

        public NClob createNClob(Reader reader, long l) {
            return this.lobCreator().createNClob(reader, l);
        }
    }
}

