/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.spi.ObjectFactory;
import org.hibernate.SessionFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.jndi.JndiException;
import org.hibernate.service.jndi.JndiNameException;
import org.hibernate.service.jndi.spi.JndiService;
import org.jboss.logging.Logger;

public class SessionFactoryRegistry {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SessionFactoryRegistry.class.getName());
    public static final SessionFactoryRegistry INSTANCE = new SessionFactoryRegistry();
    private final ConcurrentHashMap<String, SessionFactory> sessionFactoryMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> nameUuidXref = new ConcurrentHashMap();
    private final NamespaceChangeListener LISTENER = new NamespaceChangeListener(){

        public void objectAdded(NamingEvent namingEvent) {
            LOG.debugf("A factory was successfully bound to name: %s", (Object)namingEvent.getNewBinding().getName());
        }

        public void objectRemoved(NamingEvent namingEvent) {
            String string = namingEvent.getOldBinding().getName();
            LOG.factoryUnboundFromName(string);
            String string2 = (String)SessionFactoryRegistry.this.nameUuidXref.remove(string);
            if (string2 == null) {
                // empty if block
            }
            SessionFactoryRegistry.this.sessionFactoryMap.remove(string2);
        }

        public void objectRenamed(NamingEvent namingEvent) {
            String string = namingEvent.getOldBinding().getName();
            String string2 = namingEvent.getNewBinding().getName();
            LOG.factoryJndiRename(string, string2);
            String string3 = (String)SessionFactoryRegistry.this.nameUuidXref.remove(string);
            SessionFactoryRegistry.this.nameUuidXref.put(string2, string3);
        }

        public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
            LOG.namingExceptionAccessingFactory(namingExceptionEvent.getException());
        }
    };

    public SessionFactoryRegistry() {
        LOG.debugf("Initializing SessionFactoryRegistry : %s", (Object)this);
    }

    public void addSessionFactory(String string, String string2, boolean bl, SessionFactory sessionFactory, JndiService jndiService) {
        if (string == null) {
            throw new IllegalArgumentException("SessionFactory UUID cannot be null");
        }
        LOG.debugf("Registering SessionFactory: %s (%s)", (Object)string, (Object)(string2 == null ? "<unnamed>" : string2));
        this.sessionFactoryMap.put(string, sessionFactory);
        if (string2 != null) {
            this.nameUuidXref.put(string2, string);
        }
        if (string2 == null || !bl) {
            LOG.debug("Not binding SessionFactory to JNDI, no JNDI name configured");
            return;
        }
        LOG.debugf("Attempting to bind SessionFactory [%s] to JNDI", (Object)string2);
        try {
            jndiService.bind(string2, sessionFactory);
            LOG.factoryBoundToJndiName(string2);
            try {
                jndiService.addListener(string2, this.LISTENER);
            }
            catch (Exception exception) {
                LOG.couldNotBindJndiListener();
            }
        }
        catch (JndiNameException jndiNameException) {
            LOG.invalidJndiName(string2, jndiNameException);
        }
        catch (JndiException jndiException) {
            LOG.unableToBindFactoryToJndi(jndiException);
        }
    }

    public void removeSessionFactory(String string, String string2, boolean bl, JndiService jndiService) {
        if (string2 != null) {
            this.nameUuidXref.remove(string2);
            if (bl) {
                try {
                    LOG.tracef("Unbinding SessionFactory from JNDI : %s", (Object)string2);
                    jndiService.unbind(string2);
                    LOG.factoryUnboundFromJndiName(string2);
                }
                catch (JndiNameException jndiNameException) {
                    LOG.invalidJndiName(string2, jndiNameException);
                }
                catch (JndiException jndiException) {
                    LOG.unableToUnbindFactoryFromJndi(jndiException);
                }
            }
        }
        this.sessionFactoryMap.remove(string);
    }

    public SessionFactory getNamedSessionFactory(String string) {
        LOG.debugf("Lookup: name=%s", (Object)string);
        String string2 = this.nameUuidXref.get(string);
        return string2 == null ? null : this.getSessionFactory(string2);
    }

    public SessionFactory getSessionFactory(String string) {
        LOG.debugf("Lookup: uid=%s", (Object)string);
        SessionFactory sessionFactory = this.sessionFactoryMap.get(string);
        if (sessionFactory == null && LOG.isDebugEnabled()) {
            LOG.debugf("Not found: %s", (Object)string);
            LOG.debugf(this.sessionFactoryMap.toString(), new Object[0]);
        }
        return sessionFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectFactoryImpl
    implements ObjectFactory {
        @Override
        public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
            LOG.debugf("JNDI lookup: %s", (Object)name);
            String string = (String)((Reference)object).get(0).getContent();
            LOG.tracef("Resolved to UUID = %s", (Object)string);
            return INSTANCE.getSessionFactory(string);
        }
    }
}

