/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;

public class SessionFactoryObserverChain
implements SessionFactoryObserver {
    private List<SessionFactoryObserver> observers;

    public void addObserver(SessionFactoryObserver sessionFactoryObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList<SessionFactoryObserver>();
        }
        this.observers.add(sessionFactoryObserver);
    }

    public void sessionFactoryCreated(SessionFactory sessionFactory) {
        if (this.observers == null) {
            return;
        }
        for (SessionFactoryObserver sessionFactoryObserver : this.observers) {
            sessionFactoryObserver.sessionFactoryCreated(sessionFactory);
        }
    }

    public void sessionFactoryClosed(SessionFactory sessionFactory) {
        if (this.observers == null) {
            return;
        }
        int n = this.observers.size();
        for (int i = n - 1; i >= 0; --i) {
            this.observers.get(i).sessionFactoryClosed(sessionFactory);
        }
    }
}

