/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.context.internal.JTASessionContext;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryObserverChain;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.TransactionEnvironmentImpl;
import org.hibernate.internal.TypeLocatorImpl;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.jndi.spi.JndiService;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionFactoryImpl
implements SessionFactoryImplementor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SessionFactoryImpl.class.getName());
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private final String name;
    private final String uuid;
    private final transient Map<String, EntityPersister> entityPersisters;
    private final transient Map<String, ClassMetadata> classMetadata;
    private final transient Map<String, CollectionPersister> collectionPersisters;
    private final transient Map<String, CollectionMetadata> collectionMetadata;
    private final transient Map<String, Set<String>> collectionRolesByEntityParticipant;
    private final transient Map<String, IdentifierGenerator> identifierGenerators;
    private final transient Map<String, NamedQueryDefinition> namedQueries;
    private final transient Map<String, NamedSQLQueryDefinition> namedSqlQueries;
    private final transient Map<String, ResultSetMappingDefinition> sqlResultSetMappings;
    private final transient Map<String, FilterDefinition> filters;
    private final transient Map<String, FetchProfile> fetchProfiles;
    private final transient Map<String, String> imports;
    private final transient SessionFactoryServiceRegistry serviceRegistry;
    private final transient JdbcServices jdbcServices;
    private final transient Dialect dialect;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final transient SessionFactoryObserverChain observer = new SessionFactoryObserverChain();
    private final transient ConcurrentHashMap<EntityNameResolver, Object> entityNameResolvers = new ConcurrentHashMap();
    private final transient QueryPlanCache queryPlanCache;
    private final transient CacheImplementor cacheAccess;
    private transient boolean isClosed = false;
    private final transient TypeResolver typeResolver;
    private final transient TypeHelper typeHelper;
    private final transient TransactionEnvironment transactionEnvironment;
    private final transient SessionFactory.SessionFactoryOptions sessionFactoryOptions;
    private final transient CustomEntityDirtinessStrategy customEntityDirtinessStrategy;
    private final transient CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private static final Object ENTITY_NAME_RESOLVER_MAP_VALUE = new Object();

    public SessionFactoryImpl(final Configuration configuration, Mapping mapping, ServiceRegistry serviceRegistry, Settings settings, SessionFactoryObserver sessionFactoryObserver) throws HibernateException {
        Map<String, HibernateException> map;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Serializable serializable2;
        Object object7;
        LOG.debug("Building session factory");
        this.sessionFactoryOptions = new SessionFactory.SessionFactoryOptions(){
            private EntityNotFoundDelegate entityNotFoundDelegate;

            public Interceptor getInterceptor() {
                return configuration.getInterceptor();
            }

            public EntityNotFoundDelegate getEntityNotFoundDelegate() {
                if (this.entityNotFoundDelegate == null) {
                    this.entityNotFoundDelegate = configuration.getEntityNotFoundDelegate() != null ? configuration.getEntityNotFoundDelegate() : new EntityNotFoundDelegate(){

                        public void handleEntityNotFound(String string, Serializable serializable) {
                            throw new ObjectNotFoundException(serializable, string);
                        }
                    };
                }
                return this.entityNotFoundDelegate;
            }
        };
        this.settings = settings;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)configuration.getProperties());
        this.serviceRegistry = serviceRegistry.getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry((SessionFactoryImplementor)this, configuration);
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.dialect = this.jdbcServices.getDialect();
        this.cacheAccess = this.serviceRegistry.getService(CacheImplementor.class);
        RegionFactory regionFactory = this.cacheAccess.getRegionFactory();
        this.sqlFunctionRegistry = new SQLFunctionRegistry(this.getDialect(), configuration.getSqlFunctions());
        if (sessionFactoryObserver != null) {
            this.observer.addObserver(sessionFactoryObserver);
        }
        this.typeResolver = configuration.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap<String, FilterDefinition>();
        this.filters.putAll(configuration.getFilterDefinitions());
        LOG.debugf("Session factory constructed with filter configurations : %s", (Object)this.filters);
        LOG.debugf("Instantiating session factory with properties: %s", (Object)this.properties);
        this.queryPlanCache = new QueryPlanCache(this);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            public void sessionFactoryCreated(SessionFactory sessionFactory) {
            }

            public void sessionFactoryClosed(SessionFactory sessionFactory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        for (Integrator object102 : serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
            object102.integrate(configuration, (SessionFactoryImplementor)this, this.serviceRegistry);
            integratorObserver.integrators.add(object102);
        }
        this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
        Iterator<Object> iterator2 = configuration.getClassMappings();
        while (iterator2.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)iterator2.next();
            if (persistentClass.isInherited()) continue;
            object7 = persistentClass.getIdentifier().createIdentifierGenerator(configuration.getIdentifierGeneratorFactory(), this.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)persistentClass);
            this.identifierGenerators.put(persistentClass.getEntityName(), (IdentifierGenerator)object7);
        }
        String string = settings.getCacheRegionPrefix() == null ? "" : settings.getCacheRegionPrefix() + ".";
        object7 = serviceRegistry.getService(PersisterFactory.class);
        this.entityPersisters = new HashMap<String, EntityPersister>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<String, ClassMetadata> hashMap2 = new HashMap<String, ClassMetadata>();
        iterator2 = configuration.getClassMappings();
        while (iterator2.hasNext()) {
            String string2;
            serializable2 = (PersistentClass)iterator2.next();
            ((PersistentClass)serializable2).prepareTemporaryTables(mapping, this.getDialect());
            object6 = string + ((PersistentClass)serializable2).getRootClass().getCacheRegionName();
            object5 = (EntityRegionAccessStrategy)hashMap.get(object6);
            if (object5 == null && settings.isSecondLevelCacheEnabled() && (object4 = AccessType.fromExternalName(((PersistentClass)serializable2).getCacheConcurrencyStrategy())) != null) {
                LOG.tracef("Building shared cache region for entity data [%s]", (Object)((PersistentClass)serializable2).getEntityName());
                EntityRegion entityRegion = regionFactory.buildEntityRegion((String)object6, this.properties, CacheDataDescriptionImpl.decode((PersistentClass)serializable2));
                object5 = entityRegion.buildAccessStrategy((AccessType)((Object)object4));
                hashMap.put(object6, object5);
                this.cacheAccess.addCacheRegion((String)object6, entityRegion);
            }
            object4 = null;
            if (((PersistentClass)serializable2).hasNaturalId() && ((PersistentClass)serializable2).getNaturalIdCacheRegionName() != null && (object4 = (NaturalIdRegionAccessStrategy)hashMap.get(string2 = string + ((PersistentClass)serializable2).getNaturalIdCacheRegionName())) == null && settings.isSecondLevelCacheEnabled()) {
                CacheDataDescriptionImpl cacheDataDescriptionImpl = CacheDataDescriptionImpl.decode((PersistentClass)serializable2);
                object3 = null;
                try {
                    object3 = regionFactory.buildNaturalIdRegion(string2, this.properties, cacheDataDescriptionImpl);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    LOG.warnf("Shared cache region factory [%s] does not support natural id caching; shared NaturalId caching will be disabled for not be enabled for %s", (Object)regionFactory.getClass().getName(), (Object)((PersistentClass)serializable2).getEntityName());
                }
                if (object3 != null) {
                    object4 = object3.buildAccessStrategy(regionFactory.getDefaultAccessType());
                    hashMap.put(string2, object4);
                    this.cacheAccess.addCacheRegion(string2, (Region)object3);
                }
            }
            EntityPersister entityPersister = object7.createEntityPersister((PersistentClass)serializable2, (EntityRegionAccessStrategy)object5, (NaturalIdRegionAccessStrategy)object4, this, mapping);
            this.entityPersisters.put(((PersistentClass)serializable2).getEntityName(), entityPersister);
            hashMap2.put(((PersistentClass)serializable2).getEntityName(), entityPersister.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(hashMap2);
        serializable2 = new HashMap();
        this.collectionPersisters = new HashMap<String, CollectionPersister>();
        object6 = new HashMap();
        object5 = configuration.getCollectionMappings();
        while (object5.hasNext()) {
            Type type;
            object4 = (Collection)object5.next();
            String string3 = string + ((Collection)object4).getCacheRegionName();
            AccessType accessType = AccessType.fromExternalName(((Collection)object4).getCacheConcurrencyStrategy());
            object3 = null;
            if (accessType != null && settings.isSecondLevelCacheEnabled()) {
                LOG.tracev("Building shared cache region for collection data [{0}]", (Object)((Collection)object4).getRole());
                object2 = regionFactory.buildCollectionRegion(string3, this.properties, CacheDataDescriptionImpl.decode((Collection)object4));
                object3 = object2.buildAccessStrategy(accessType);
                hashMap.put(string3, object3);
                this.cacheAccess.addCacheRegion(string3, (Region)object2);
            }
            object2 = object7.createCollectionPersister(configuration, (Collection)object4, (CollectionRegionAccessStrategy)object3, (SessionFactoryImplementor)this);
            this.collectionPersisters.put(((Collection)object4).getRole(), (CollectionPersister)object2);
            object6.put(((Collection)object4).getRole(), object2.getCollectionMetadata());
            Type type2 = object2.getIndexType();
            if (type2 != null && type2.isAssociationType() && !type2.isAnyType()) {
                String string4 = ((AssociationType)type2).getAssociatedEntityName(this);
                object = (Set)serializable2.get(string4);
                if (object == null) {
                    object = new HashSet<String>();
                    serializable2.put(string4, object);
                }
                object.add(object2.getRole());
            }
            if (!(type = object2.getElementType()).isAssociationType() || type.isAnyType()) continue;
            object = ((AssociationType)type).getAssociatedEntityName(this);
            serializable = (HashSet<String>)serializable2.get(object);
            if (serializable == null) {
                serializable = new HashSet<String>();
                serializable2.put(object, serializable);
            }
            serializable.add(object2.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(object6);
        for (Map.Entry entry : serializable2.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(serializable2);
        this.namedQueries = new HashMap<String, NamedQueryDefinition>(configuration.getNamedQueries());
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>(configuration.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>(configuration.getSqlResultSetMappings());
        this.imports = new HashMap<String, String>(configuration.getImports());
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            entityPersister.postInstantiate();
            this.registerEntityNameResolvers(entityPersister);
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            collectionPersister.postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, settings.isSessionFactoryNameAlsoJndiName(), this, serviceRegistry.getService(JndiService.class));
        LOG.debug("Instantiated session factory");
        settings.getMultiTableBulkIdStrategy().prepare(this.jdbcServices, this.buildLocalConnectionAccess(), configuration.createMappings(), configuration.buildMapping(), this.properties);
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(serviceRegistry, configuration).setImportSqlCommandExtractor(serviceRegistry.getService(ImportSqlCommandExtractor.class)).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(serviceRegistry, configuration).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(serviceRegistry, configuration).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(serviceRegistry, configuration).setImportSqlCommandExtractor(serviceRegistry.getService(ImportSqlCommandExtractor.class));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isNamedQueryStartupCheckingEnabled() && !(map = this.checkNamedQueries()).isEmpty()) {
            object3 = new StringBuilder("Errors in named queries: ");
            object2 = "";
            for (Map.Entry<String, HibernateException> entry : map.entrySet()) {
                LOG.namedQueryError(entry.getKey(), entry.getValue());
                ((StringBuilder)object3).append((String)object2).append(entry.getKey());
                object2 = ", ";
            }
            throw new HibernateException(((StringBuilder)object3).toString());
        }
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        object4 = configuration.iterateFetchProfiles();
        while (object4.hasNext()) {
            org.hibernate.mapping.FetchProfile fetchProfile = (org.hibernate.mapping.FetchProfile)object4.next();
            object3 = new FetchProfile(fetchProfile.getName());
            for (FetchProfile.Fetch fetch : fetchProfile.getFetches()) {
                String string5 = this.getImportedClassName(fetch.getEntity());
                Object object8 = object = string5 == null ? null : this.entityPersisters.get(string5);
                if (object == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + fetch.getEntity() + "] in fetch profile [" + ((FetchProfile)object3).getName() + "]");
                }
                serializable = object.getPropertyType(fetch.getAssociation());
                if (serializable == null || !serializable.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + ((FetchProfile)object3).getName() + "] specified an invalid association");
                }
                Fetch.Style style = Fetch.Style.parse(fetch.getStyle());
                ((FetchProfile)object3).addFetch(new Association((EntityPersister)object, fetch.getAssociation()), style);
                ((Loadable)object).registerAffectingFetchProfile(((FetchProfile)object3).getName());
            }
            this.fetchProfiles.put(((FetchProfile)object3).getName(), (FetchProfile)object3);
        }
        this.customEntityDirtinessStrategy = this.determineCustomEntityDirtinessStrategy();
        this.currentTenantIdentifierResolver = this.determineCurrentTenantIdentifierResolver(configuration.getCurrentTenantIdentifierResolver());
        this.transactionEnvironment = new TransactionEnvironmentImpl(this);
        this.observer.sessionFactoryCreated(this);
    }

    private JdbcConnectionAccess buildLocalConnectionAccess() {
        return new JdbcConnectionAccess(){

            public Connection obtainConnection() throws SQLException {
                return SessionFactoryImpl.this.settings.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE ? SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).getConnection() : SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).getAnyConnection();
            }

            public void releaseConnection(Connection connection) throws SQLException {
                if (SessionFactoryImpl.this.settings.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE) {
                    SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).closeConnection(connection);
                } else {
                    SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).releaseAnyConnection(connection);
                }
            }

            public boolean supportsAggressiveRelease() {
                return false;
            }
        };
    }

    private CustomEntityDirtinessStrategy determineCustomEntityDirtinessStrategy() {
        CustomEntityDirtinessStrategy customEntityDirtinessStrategy = new CustomEntityDirtinessStrategy(){

            public boolean canDirtyCheck(Object object, EntityPersister entityPersister, Session session) {
                return false;
            }

            public boolean isDirty(Object object, EntityPersister entityPersister, Session session) {
                return false;
            }

            public void resetDirty(Object object, EntityPersister entityPersister, Session session) {
            }

            public void findDirty(Object object, EntityPersister entityPersister, Session session, CustomEntityDirtinessStrategy.DirtyCheckContext dirtyCheckContext) {
            }
        };
        return this.serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.entity_dirtiness_strategy", CustomEntityDirtinessStrategy.class, customEntityDirtinessStrategy);
    }

    private CurrentTenantIdentifierResolver determineCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver currentTenantIdentifierResolver) {
        if (currentTenantIdentifierResolver != null) {
            return currentTenantIdentifierResolver;
        }
        return this.serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.tenant_identifier_resolver", CurrentTenantIdentifierResolver.class, null);
    }

    /*
     * WARNING - void declaration
     */
    public SessionFactoryImpl(MetadataImplementor metadataImplementor, SessionFactory.SessionFactoryOptions sessionFactoryOptions, SessionFactoryObserver sessionFactoryObserver) throws HibernateException {
        Map<String, HibernateException> map;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator<Object> iterator;
        Object object5;
        boolean bl;
        boolean bl2 = LOG.isTraceEnabled();
        boolean bl3 = bl = bl2 || LOG.isDebugEnabled();
        if (bl) {
            LOG.debug("Building session factory");
        }
        this.sessionFactoryOptions = sessionFactoryOptions;
        this.properties = SessionFactoryImpl.createPropertiesFromMap(metadataImplementor.getServiceRegistry().getService(ConfigurationService.class).getSettings());
        this.settings = new SettingsFactory().buildSettings(this.properties, metadataImplementor.getServiceRegistry());
        this.serviceRegistry = metadataImplementor.getServiceRegistry().getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry((SessionFactoryImplementor)this, metadataImplementor);
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.dialect = this.jdbcServices.getDialect();
        this.cacheAccess = this.serviceRegistry.getService(CacheImplementor.class);
        this.sqlFunctionRegistry = new SQLFunctionRegistry(this.dialect, new HashMap<String, SQLFunction>());
        if (sessionFactoryObserver != null) {
            this.observer.addObserver(sessionFactoryObserver);
        }
        this.typeResolver = metadataImplementor.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap<String, FilterDefinition>();
        for (FilterDefinition object102 : metadataImplementor.getFilterDefinitions()) {
            this.filters.put(object102.getFilterName(), object102);
        }
        if (bl) {
            LOG.debugf("Session factory constructed with filter configurations : %s", (Object)this.filters);
            LOG.debugf("Instantiating session factory with properties: %s", (Object)this.properties);
        }
        this.queryPlanCache = new QueryPlanCache(this);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            public void sessionFactoryCreated(SessionFactory sessionFactory) {
            }

            public void sessionFactoryClosed(SessionFactory sessionFactory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
            integrator.integrate(metadataImplementor, (SessionFactoryImplementor)this, this.serviceRegistry);
            integratorObserver.integrators.add(integrator);
        }
        this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
        for (EntityBinding entityBinding : metadataImplementor.getEntityBindings()) {
            if (!entityBinding.isRoot()) continue;
            this.identifierGenerators.put(entityBinding.getEntity().getName(), entityBinding.getHierarchyDetails().getEntityIdentifier().getIdentifierGenerator());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.settings.getCacheRegionPrefix() != null) {
            stringBuilder.append(this.settings.getCacheRegionPrefix()).append('.');
        }
        String string = stringBuilder.toString();
        this.entityPersisters = new HashMap<String, EntityPersister>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, ClassMetadata> hashMap2 = new HashMap<String, ClassMetadata>();
        for (EntityBinding entityBinding : metadataImplementor.getEntityBindings()) {
            void var14_21;
            String string2;
            EntityRegionAccessStrategy entityRegionAccessStrategy;
            Iterator<Object> iterator2 = metadataImplementor.getRootEntityBinding(entityBinding.getEntity().getName());
            Object var14_22 = null;
            if (this.settings.isSecondLevelCacheEnabled() && ((EntityBinding)((Object)iterator2)).getHierarchyDetails().getCaching() != null && entityBinding.getHierarchyDetails().getCaching() != null && entityBinding.getHierarchyDetails().getCaching().getAccessType() != null && (entityRegionAccessStrategy = (EntityRegionAccessStrategy)EntityRegionAccessStrategy.class.cast(hashMap.get(string2 = string + ((EntityBinding)((Object)iterator2)).getHierarchyDetails().getCaching().getRegion()))) == null) {
                object5 = entityBinding.getHierarchyDetails().getCaching().getAccessType();
                if (bl2) {
                    LOG.tracev("Building cache for entity data [{0}]", (Object)entityBinding.getEntity().getName());
                }
                iterator = this.settings.getRegionFactory().buildEntityRegion(string2, this.properties, CacheDataDescriptionImpl.decode(entityBinding));
                EntityRegionAccessStrategy entityRegionAccessStrategy2 = iterator.buildAccessStrategy((AccessType)((Object)object5));
                hashMap.put(string2, entityRegionAccessStrategy2);
                this.cacheAccess.addCacheRegion(string2, (Region)((Object)iterator));
            }
            EntityPersister entityPersister = this.serviceRegistry.getService(PersisterFactory.class).createEntityPersister(entityBinding, (EntityRegionAccessStrategy)var14_21, this, metadataImplementor);
            this.entityPersisters.put(entityBinding.getEntity().getName(), entityPersister);
            hashMap2.put(entityBinding.getEntity().getName(), entityPersister.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(hashMap2);
        HashMap hashMap3 = new HashMap();
        this.collectionPersisters = new HashMap<String, CollectionPersister>();
        HashMap<String, CollectionMetadata> hashMap4 = new HashMap<String, CollectionMetadata>();
        for (PluralAttributeBinding pluralAttributeBinding : metadataImplementor.getCollectionBindings()) {
            if (pluralAttributeBinding.getAttribute() == null) {
                throw new IllegalStateException("No attribute defined for a AbstractPluralAttributeBinding: " + pluralAttributeBinding);
            }
            if (pluralAttributeBinding.getAttribute().isSingular()) {
                throw new IllegalStateException("AbstractPluralAttributeBinding has a Singular attribute defined: " + pluralAttributeBinding.getAttribute().getName());
            }
            String string3 = string + pluralAttributeBinding.getCaching().getRegion();
            object5 = pluralAttributeBinding.getCaching().getAccessType();
            iterator = null;
            if (object5 != null && this.settings.isSecondLevelCacheEnabled()) {
                if (bl2) {
                    LOG.tracev("Building cache for collection data [{0}]", (Object)pluralAttributeBinding.getAttribute().getRole());
                }
                CollectionRegion collectionRegion = this.settings.getRegionFactory().buildCollectionRegion(string3, this.properties, CacheDataDescriptionImpl.decode(pluralAttributeBinding));
                iterator = collectionRegion.buildAccessStrategy((AccessType)((Object)object5));
                hashMap.put(string3, iterator);
                this.cacheAccess.addCacheRegion(string3, collectionRegion);
            }
            CollectionPersister collectionPersister = this.serviceRegistry.getService(PersisterFactory.class).createCollectionPersister(metadataImplementor, pluralAttributeBinding, (CollectionRegionAccessStrategy)((Object)iterator), (SessionFactoryImplementor)this);
            this.collectionPersisters.put(pluralAttributeBinding.getAttribute().getRole(), collectionPersister);
            hashMap4.put(pluralAttributeBinding.getAttribute().getRole(), collectionPersister.getCollectionMetadata());
            object4 = collectionPersister.getIndexType();
            if (object4 != null && object4.isAssociationType() && !object4.isAnyType()) {
                object3 = ((AssociationType)object4).getAssociatedEntityName(this);
                object2 = (Set)hashMap3.get(object3);
                if (object2 == null) {
                    object2 = new HashSet<String>();
                    hashMap3.put(object3, object2);
                }
                object2.add(collectionPersister.getRole());
            }
            if (!(object3 = collectionPersister.getElementType()).isAssociationType() || object3.isAnyType()) continue;
            object2 = ((AssociationType)object3).getAssociatedEntityName(this);
            object = (HashSet<String>)hashMap3.get(object2);
            if (object == null) {
                object = new HashSet<String>();
                hashMap3.put(object2, object);
            }
            object.add(collectionPersister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(hashMap4);
        for (Map.Entry entry : hashMap3.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(hashMap3);
        this.namedQueries = new HashMap<String, NamedQueryDefinition>();
        for (NamedQueryDefinition namedQueryDefinition : metadataImplementor.getNamedQueryDefinitions()) {
            this.namedQueries.put(namedQueryDefinition.getName(), namedQueryDefinition);
        }
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>();
        for (NamedSQLQueryDefinition namedSQLQueryDefinition : metadataImplementor.getNamedNativeQueryDefinitions()) {
            this.namedSqlQueries.put(namedSQLQueryDefinition.getName(), namedSQLQueryDefinition);
        }
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
        for (ResultSetMappingDefinition resultSetMappingDefinition : metadataImplementor.getResultSetMappingDefinitions()) {
            this.sqlResultSetMappings.put(resultSetMappingDefinition.getName(), resultSetMappingDefinition);
        }
        this.imports = new HashMap<String, String>();
        for (Map.Entry entry : metadataImplementor.getImports()) {
            this.imports.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            entityPersister.postInstantiate();
            this.registerEntityNameResolvers(entityPersister);
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            collectionPersister.postInstantiate();
        }
        this.name = this.settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this, this.serviceRegistry.getService(JndiService.class));
        if (bl) {
            LOG.debug("Instantiated session factory");
        }
        if (this.settings.isAutoCreateSchema()) {
            new SchemaExport(metadataImplementor).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class)).create(false, true);
        }
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(metadataImplementor).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (this.settings.isNamedQueryStartupCheckingEnabled() && !(map = this.checkNamedQueries()).isEmpty()) {
            StringBuilder stringBuilder2 = new StringBuilder("Errors in named queries: ");
            object5 = "";
            for (Map.Entry<String, HibernateException> entry : map.entrySet()) {
                LOG.namedQueryError(entry.getKey(), entry.getValue());
                stringBuilder2.append(entry.getKey()).append((String)object5);
                object5 = ", ";
            }
            throw new HibernateException(stringBuilder2.toString());
        }
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        for (org.hibernate.metamodel.binding.FetchProfile fetchProfile : metadataImplementor.getFetchProfiles()) {
            object5 = new FetchProfile(fetchProfile.getName());
            for (FetchProfile.Fetch fetch : fetchProfile.getFetches()) {
                object4 = this.getImportedClassName(fetch.getEntity());
                Object object6 = object3 = object4 == null ? null : this.entityPersisters.get(object4);
                if (object3 == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + fetch.getEntity() + "] in fetch profile [" + ((FetchProfile)object5).getName() + "]");
                }
                object2 = object3.getPropertyType(fetch.getAssociation());
                if (object2 == null || !object2.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + ((FetchProfile)object5).getName() + "] specified an invalid association");
                }
                object = Fetch.Style.parse(fetch.getStyle());
                ((FetchProfile)object5).addFetch(new Association((EntityPersister)object3, fetch.getAssociation()), (Fetch.Style)((Object)object));
                ((Loadable)object3).registerAffectingFetchProfile(((FetchProfile)object5).getName());
            }
            this.fetchProfiles.put(((FetchProfile)object5).getName(), (FetchProfile)object5);
        }
        this.customEntityDirtinessStrategy = this.determineCustomEntityDirtinessStrategy();
        this.currentTenantIdentifierResolver = this.determineCurrentTenantIdentifierResolver(null);
        this.transactionEnvironment = new TransactionEnvironmentImpl(this);
        this.observer.sessionFactoryCreated(this);
    }

    private static Properties createPropertiesFromMap(Map map) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        return properties;
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.withOptions().openSession();
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return this.withOptions().autoClose(false).flushBeforeCompletion(false).connectionReleaseMode(ConnectionReleaseMode.AFTER_STATEMENT).openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public SessionBuilderImplementor withOptions() {
        return new SessionBuilderImpl(this);
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return new StatelessSessionBuilderImpl(this);
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.withStatelessOptions().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.withStatelessOptions().connection(connection).openStatelessSession();
    }

    @Override
    public void addObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.observer.addObserver(sessionFactoryObserver);
    }

    public TransactionEnvironment getTransactionEnvironment() {
        return this.transactionEnvironment;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    private void registerEntityNameResolvers(EntityPersister entityPersister) {
        if (entityPersister.getEntityMetamodel() == null || entityPersister.getEntityMetamodel().getTuplizer() == null) {
            return;
        }
        this.registerEntityNameResolvers(entityPersister.getEntityMetamodel().getTuplizer());
    }

    private void registerEntityNameResolvers(EntityTuplizer entityTuplizer) {
        EntityNameResolver[] entityNameResolverArray = entityTuplizer.getEntityNameResolvers();
        if (entityNameResolverArray == null) {
            return;
        }
        for (EntityNameResolver entityNameResolver : entityNameResolverArray) {
            this.registerEntityNameResolver(entityNameResolver);
        }
    }

    public void registerEntityNameResolver(EntityNameResolver entityNameResolver) {
        this.entityNameResolvers.put(entityNameResolver, ENTITY_NAME_RESOLVER_MAP_VALUE);
    }

    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.entityNameResolvers.keySet();
    }

    @Override
    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map<String, HibernateException> checkNamedQueries() throws HibernateException {
        NamedQueryDefinition namedQueryDefinition;
        String string;
        HashMap<String, HibernateException> hashMap = new HashMap<String, HibernateException>();
        boolean bl = LOG.isDebugEnabled();
        if (bl) {
            LOG.debugf("Checking %s named HQL queries", (Object)this.namedQueries.size());
        }
        for (Map.Entry<String, NamedQueryDefinition> entry : this.namedQueries.entrySet()) {
            string = entry.getKey();
            namedQueryDefinition = entry.getValue();
            try {
                if (bl) {
                    LOG.debugf("Checking named query: %s", (Object)string);
                }
                this.queryPlanCache.getHQLQueryPlan(namedQueryDefinition.getQueryString(), false, Collections.EMPTY_MAP);
            }
            catch (QueryException queryException) {
                hashMap.put(string, queryException);
            }
            catch (MappingException mappingException) {
                hashMap.put(string, mappingException);
            }
        }
        if (bl) {
            LOG.debugf("Checking %s named SQL queries", (Object)this.namedSqlQueries.size());
        }
        for (Map.Entry<String, NamedQueryDefinition> entry : this.namedSqlQueries.entrySet()) {
            string = entry.getKey();
            namedQueryDefinition = (NamedSQLQueryDefinition)entry.getValue();
            try {
                NativeSQLQuerySpecification mappingException;
                if (bl) {
                    LOG.debugf("Checking named SQL query: %s", (Object)string);
                }
                if (((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef() != null) {
                    ResultSetMappingDefinition resultSetMappingDefinition = this.sqlResultSetMappings.get(((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef());
                    if (resultSetMappingDefinition == null) {
                        throw new MappingException("Unable to find resultset-ref definition: " + ((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef());
                    }
                    mappingException = new NativeSQLQuerySpecification(namedQueryDefinition.getQueryString(), resultSetMappingDefinition.getQueryReturns(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQuerySpaces());
                } else {
                    mappingException = new NativeSQLQuerySpecification(namedQueryDefinition.getQueryString(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQueryReturns(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQuerySpaces());
                }
                this.queryPlanCache.getNativeSQLQueryPlan(mappingException);
            }
            catch (QueryException queryException) {
                hashMap.put(string, queryException);
            }
            catch (MappingException mappingException) {
                hashMap.put(string, mappingException);
            }
        }
        return hashMap;
    }

    @Override
    public EntityPersister getEntityPersister(String string) throws MappingException {
        EntityPersister entityPersister = this.entityPersisters.get(string);
        if (entityPersister == null) {
            throw new MappingException("Unknown entity: " + string);
        }
        return entityPersister;
    }

    @Override
    public Map<String, CollectionPersister> getCollectionPersisters() {
        return this.collectionPersisters;
    }

    @Override
    public Map<String, EntityPersister> getEntityPersisters() {
        return this.entityPersisters;
    }

    @Override
    public CollectionPersister getCollectionPersister(String string) throws MappingException {
        CollectionPersister collectionPersister = this.collectionPersisters.get(string);
        if (collectionPersister == null) {
            throw new MappingException("Unknown collection role: " + string);
        }
        return collectionPersister;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public Dialect getDialect() {
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("Cannot determine dialect because serviceRegistry is null.");
        }
        return this.dialect;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.sessionFactoryOptions.getInterceptor();
    }

    @Override
    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSQLExceptionHelper().getSqlExceptionConverter();
    }

    @Override
    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public Set<String> getCollectionRolesByEntityParticipant(String string) {
        return this.collectionRolesByEntityParticipant.get(string);
    }

    @Override
    public Reference getReference() {
        LOG.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    @Override
    public NamedQueryDefinition getNamedQuery(String string) {
        return this.namedQueries.get(string);
    }

    @Override
    public NamedSQLQueryDefinition getNamedSQLQuery(String string) {
        return this.namedSqlQueries.get(string);
    }

    @Override
    public ResultSetMappingDefinition getResultSetMapping(String string) {
        return this.sqlResultSetMappings.get(string);
    }

    @Override
    public Type getIdentifierType(String string) throws MappingException {
        return this.getEntityPersister(string).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String string) throws MappingException {
        return this.getEntityPersister(string).getIdentifierPropertyName();
    }

    @Override
    public Type[] getReturnTypes(String string) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(string, false, Collections.EMPTY_MAP).getReturnMetadata().getReturnTypes();
    }

    @Override
    public String[] getReturnAliases(String string) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(string, false, Collections.EMPTY_MAP).getReturnMetadata().getReturnAliases();
    }

    @Override
    public ClassMetadata getClassMetadata(Class clazz) throws HibernateException {
        return this.getClassMetadata(clazz.getName());
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String string) throws HibernateException {
        return this.collectionMetadata.get(string);
    }

    @Override
    public ClassMetadata getClassMetadata(String string) throws HibernateException {
        return this.classMetadata.get(string);
    }

    @Override
    public String[] getImplementors(String string) throws MappingException {
        Class clazz;
        try {
            clazz = this.serviceRegistry.getService(ClassLoaderService.class).classForName(string);
        }
        catch (ClassLoadingException classLoadingException) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            boolean bl;
            if (!Queryable.class.isInstance(entityPersister)) continue;
            Queryable queryable = (Queryable)Queryable.class.cast(entityPersister);
            String string2 = queryable.getEntityName();
            boolean bl2 = string.equals(string2);
            if (queryable.isExplicitPolymorphism()) {
                if (!bl2) continue;
                return new String[]{string};
            }
            if (bl2) {
                arrayList.add(string2);
                continue;
            }
            Class clazz2 = queryable.getMappedClass();
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            if (queryable.isInherited()) {
                Class clazz3 = this.getEntityPersister(queryable.getMappedSuperclass()).getMappedClass();
                bl = clazz.isAssignableFrom(clazz3);
            } else {
                bl = false;
            }
            if (bl) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String getImportedClassName(String string) {
        String string2 = this.imports.get(string);
        if (string2 == null) {
            try {
                this.serviceRegistry.getService(ClassLoaderService.class).classForName(string);
                return string;
            }
            catch (ClassLoadingException classLoadingException) {
                return null;
            }
        }
        return string2;
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    @Override
    public Type getReferencedPropertyType(String string, String string2) throws MappingException {
        return this.getEntityPersister(string).getPropertyType(string2);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.jdbcServices.getConnectionProvider();
    }

    @Override
    public void close() throws HibernateException {
        if (this.isClosed) {
            LOG.trace("Already closed");
            return;
        }
        LOG.closing();
        this.isClosed = true;
        this.settings.getMultiTableBulkIdStrategy().release(this.jdbcServices, this.buildLocalConnectionAccess());
        for (EntityPersister object : this.entityPersisters.values()) {
            if (!object.hasCache()) continue;
            object.getCacheAccessStrategy().getRegion().destroy();
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            if (!collectionPersister.hasCache()) continue;
            collectionPersister.getCacheAccessStrategy().getRegion().destroy();
        }
        this.cacheAccess.close();
        this.queryPlanCache.cleanup();
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
        SessionFactoryRegistry.INSTANCE.removeSessionFactory(this.uuid, this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this.serviceRegistry.getService(JndiService.class));
        this.observer.sessionFactoryClosed(this);
        this.serviceRegistry.destroy();
    }

    @Override
    public Cache getCache() {
        return this.cacheAccess;
    }

    @Override
    public void evictEntity(String string, Serializable serializable) throws HibernateException {
        this.getCache().evictEntity(string, serializable);
    }

    @Override
    public void evictEntity(String string) throws HibernateException {
        this.getCache().evictEntityRegion(string);
    }

    @Override
    public void evict(Class clazz, Serializable serializable) throws HibernateException {
        this.getCache().evictEntity(clazz, serializable);
    }

    @Override
    public void evict(Class clazz) throws HibernateException {
        this.getCache().evictEntityRegion(clazz);
    }

    @Override
    public void evictCollection(String string, Serializable serializable) throws HibernateException {
        this.getCache().evictCollection(string, serializable);
    }

    @Override
    public void evictCollection(String string) throws HibernateException {
        this.getCache().evictCollectionRegion(string);
    }

    @Override
    public void evictQueries() throws HibernateException {
        this.cacheAccess.evictQueries();
    }

    @Override
    public void evictQueries(String string) throws HibernateException {
        this.getCache().evictQueryRegion(string);
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.cacheAccess.getUpdateTimestampsCache();
    }

    @Override
    public QueryCache getQueryCache() {
        return this.cacheAccess.getQueryCache();
    }

    @Override
    public QueryCache getQueryCache(String string) throws HibernateException {
        return this.cacheAccess.getQueryCache(string);
    }

    @Override
    public Region getSecondLevelCacheRegion(String string) {
        return this.cacheAccess.getSecondLevelCacheRegion(string);
    }

    @Override
    public Region getNaturalIdCacheRegion(String string) {
        return this.cacheAccess.getNaturalIdCacheRegion(string);
    }

    @Override
    public Map getAllSecondLevelCacheRegions() {
        return this.cacheAccess.getAllSecondLevelCacheRegions();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statistics getStatistics() {
        return this.getStatisticsImplementor();
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.serviceRegistry.getService(StatisticsImplementor.class);
    }

    @Override
    public FilterDefinition getFilterDefinition(String string) throws HibernateException {
        FilterDefinition filterDefinition = this.filters.get(string);
        if (filterDefinition == null) {
            throw new HibernateException("No such filter configured [" + string + "]");
        }
        return filterDefinition;
    }

    @Override
    public boolean containsFetchProfileDefinition(String string) {
        return this.fetchProfiles.containsKey(string);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String string) {
        return this.identifierGenerators.get(string);
    }

    private TransactionFactory transactionFactory() {
        return this.serviceRegistry.getService(TransactionFactory.class);
    }

    private boolean canAccessTransactionManager() {
        try {
            return this.serviceRegistry.getService(JtaPlatform.class).retrieveTransactionManager() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String string = this.properties.getProperty("hibernate.current_session_context_class");
        if (string == null) {
            if (this.canAccessTransactionManager()) {
                string = "jta";
            } else {
                return null;
            }
        }
        if ("jta".equals(string)) {
            if (!this.transactionFactory().compatibleWithJtaSynchronization()) {
                LOG.autoFlushWillNotWork();
            }
            return new JTASessionContext(this);
        }
        if ("thread".equals(string)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(string)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class clazz = this.serviceRegistry.getService(ClassLoaderService.class).classForName(string);
            return (CurrentSessionContext)clazz.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable throwable) {
            LOG.unableToConstructCurrentSessionContext(string, throwable);
            return null;
        }
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.sessionFactoryOptions.getEntityNotFoundDelegate();
    }

    @Override
    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }

    @Override
    public FetchProfile getFetchProfile(String string) {
        return this.fetchProfiles.get(string);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.customEntityDirtinessStrategy;
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        LOG.debugf("Serializing: %s", (Object)this.uuid);
        objectOutputStream.defaultWriteObject();
        LOG.trace("Serialized");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing");
        objectInputStream.defaultReadObject();
        LOG.debugf("Deserialized: %s", (Object)this.uuid);
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SessionFactory");
        return SessionFactoryImpl.locateSessionFactoryOnDeserialization(this.uuid, this.name);
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String string, String string2) throws InvalidObjectException {
        SessionFactory sessionFactory;
        SessionFactory sessionFactory2 = SessionFactoryRegistry.INSTANCE.getSessionFactory(string);
        if (sessionFactory2 != null) {
            LOG.debugf("Resolved SessionFactory by UUID [%s]", (Object)string);
            return sessionFactory2;
        }
        if (string2 != null && (sessionFactory = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(string2)) != null) {
            LOG.debugf("Resolved SessionFactory by name [%s]", (Object)string2);
            return sessionFactory;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + string + ",name=" + string2 + "]");
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.uuid);
        objectOutputStream.writeBoolean(this.name != null);
        if (this.name != null) {
            objectOutputStream.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing SessionFactory from Session");
        String string = objectInputStream.readUTF();
        boolean bl = objectInputStream.readBoolean();
        String string2 = bl ? objectInputStream.readUTF() : null;
        return (SessionFactoryImpl)SessionFactoryImpl.locateSessionFactoryOnDeserialization(string, string2);
    }

    public static class StatelessSessionBuilderImpl
    implements StatelessSessionBuilder {
        private final SessionFactoryImpl sessionFactory;
        private Connection connection;
        private String tenantIdentifier;

        public StatelessSessionBuilderImpl(SessionFactoryImpl sessionFactoryImpl) {
            this.sessionFactory = sessionFactoryImpl;
            if (sessionFactoryImpl.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactoryImpl.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
        }

        public StatelessSession openStatelessSession() {
            return new StatelessSessionImpl(this.connection, this.tenantIdentifier, this.sessionFactory);
        }

        public StatelessSessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public StatelessSessionBuilder tenantIdentifier(String string) {
            this.tenantIdentifier = string;
            return this;
        }
    }

    static class SessionBuilderImpl
    implements SessionBuilderImplementor {
        private final SessionFactoryImpl sessionFactory;
        private SessionOwner sessionOwner;
        private Interceptor interceptor;
        private Connection connection;
        private ConnectionReleaseMode connectionReleaseMode;
        private boolean autoClose;
        private boolean autoJoinTransactions = true;
        private boolean flushBeforeCompletion;
        private String tenantIdentifier;

        SessionBuilderImpl(SessionFactoryImpl sessionFactoryImpl) {
            this.sessionFactory = sessionFactoryImpl;
            this.sessionOwner = null;
            Settings settings = sessionFactoryImpl.settings;
            this.interceptor = sessionFactoryImpl.getInterceptor();
            this.connectionReleaseMode = settings.getConnectionReleaseMode();
            this.autoClose = settings.isAutoCloseSessionEnabled();
            this.flushBeforeCompletion = settings.isFlushBeforeCompletionEnabled();
            if (sessionFactoryImpl.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactoryImpl.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
        }

        protected TransactionCoordinatorImpl getTransactionCoordinator() {
            return null;
        }

        public Session openSession() {
            return new SessionImpl(this.connection, this.sessionFactory, this.sessionOwner, this.getTransactionCoordinator(), this.autoJoinTransactions, this.sessionFactory.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.flushBeforeCompletion, this.autoClose, this.connectionReleaseMode, this.tenantIdentifier);
        }

        public SessionBuilder owner(SessionOwner sessionOwner) {
            this.sessionOwner = sessionOwner;
            return this;
        }

        public SessionBuilder interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        public SessionBuilder noInterceptor() {
            this.interceptor = EmptyInterceptor.INSTANCE;
            return this;
        }

        public SessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public SessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            this.connectionReleaseMode = connectionReleaseMode;
            return this;
        }

        public SessionBuilder autoJoinTransactions(boolean bl) {
            this.autoJoinTransactions = bl;
            return this;
        }

        public SessionBuilder autoClose(boolean bl) {
            this.autoClose = bl;
            return this;
        }

        public SessionBuilder flushBeforeCompletion(boolean bl) {
            this.flushBeforeCompletion = bl;
            return this;
        }

        public SessionBuilder tenantIdentifier(String string) {
            this.tenantIdentifier = string;
            return this;
        }
    }
}

