/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.HolderInstantiator;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;

public class ScrollableResultsImpl
extends AbstractScrollableResults
implements ScrollableResults {
    private Object[] currentRow;

    public ScrollableResultsImpl(ResultSet resultSet, PreparedStatement preparedStatement, SessionImplementor sessionImplementor, Loader loader, QueryParameters queryParameters, Type[] typeArray, HolderInstantiator holderInstantiator) throws MappingException {
        super(resultSet, preparedStatement, sessionImplementor, loader, queryParameters, typeArray, holderInstantiator);
    }

    protected Object[] getCurrentRow() {
        return this.currentRow;
    }

    public boolean scroll(int n) throws HibernateException {
        try {
            boolean bl = this.getResultSet().relative(n);
            this.prepareCurrentRow(bl);
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "could not advance using scroll()");
        }
    }

    public boolean first() throws HibernateException {
        try {
            boolean bl = this.getResultSet().first();
            this.prepareCurrentRow(bl);
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "could not advance using first()");
        }
    }

    public boolean last() throws HibernateException {
        try {
            boolean bl = this.getResultSet().last();
            this.prepareCurrentRow(bl);
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "could not advance using last()");
        }
    }

    public boolean next() throws HibernateException {
        try {
            boolean bl = this.getResultSet().next();
            this.prepareCurrentRow(bl);
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "could not advance using next()");
        }
    }

    public boolean previous() throws HibernateException {
        try {
            boolean bl = this.getResultSet().previous();
            this.prepareCurrentRow(bl);
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "could not advance using previous()");
        }
    }

    public void afterLast() throws HibernateException {
        try {
            this.getResultSet().afterLast();
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "exception calling afterLast()");
        }
    }

    public void beforeFirst() throws HibernateException {
        try {
            this.getResultSet().beforeFirst();
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "exception calling beforeFirst()");
        }
    }

    public boolean isFirst() throws HibernateException {
        try {
            return this.getResultSet().isFirst();
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "exception calling isFirst()");
        }
    }

    public boolean isLast() throws HibernateException {
        try {
            return this.getResultSet().isLast();
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "exception calling isLast()");
        }
    }

    public int getRowNumber() throws HibernateException {
        try {
            return this.getResultSet().getRow() - 1;
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "exception calling getRow()");
        }
    }

    public boolean setRowNumber(int n) throws HibernateException {
        if (n >= 0) {
            ++n;
        }
        try {
            boolean bl = this.getResultSet().absolute(n);
            this.prepareCurrentRow(bl);
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sQLException, "could not advance using absolute()");
        }
    }

    private void prepareCurrentRow(boolean bl) throws HibernateException {
        if (!bl) {
            this.currentRow = null;
            return;
        }
        Object object = this.getLoader().loadSingleRow(this.getResultSet(), this.getSession(), this.getQueryParameters(), false);
        this.currentRow = object != null && object.getClass().isArray() ? (Object[])object : new Object[]{object};
        if (this.getHolderInstantiator() != null) {
            this.currentRow = new Object[]{this.getHolderInstantiator().instantiate(this.currentRow)};
        }
        this.afterScrollOperation();
    }
}

