/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.NonFlushedChanges;
import org.hibernate.event.spi.EventSource;
import org.jboss.logging.Logger;

public final class NonFlushedChangesImpl
implements NonFlushedChanges,
Serializable {
    private static final Logger LOG = Logger.getLogger(NonFlushedChangesImpl.class.getName());
    private transient ActionQueue actionQueue;
    private transient StatefulPersistenceContext persistenceContext;

    public NonFlushedChangesImpl(EventSource eventSource) {
        this.actionQueue = eventSource.getActionQueue();
        this.persistenceContext = (StatefulPersistenceContext)eventSource.getPersistenceContext();
    }

    ActionQueue getActionQueue() {
        return this.actionQueue;
    }

    StatefulPersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void clear() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing NonFlushedChangesImpl");
        objectInputStream.defaultReadObject();
        this.persistenceContext = StatefulPersistenceContext.deserialize(objectInputStream, null);
        this.actionQueue = ActionQueue.deserialize(objectInputStream, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        LOG.trace("Serializing NonFlushedChangesImpl");
        objectOutputStream.defaultWriteObject();
        this.persistenceContext.serialize(objectOutputStream);
        this.actionQueue.serialize(objectOutputStream);
    }
}

