/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.HolderInstantiator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class IteratorImpl
implements HibernateIterator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IteratorImpl.class.getName());
    private ResultSet rs;
    private final EventSource session;
    private boolean readOnly;
    private final Type[] types;
    private final boolean single;
    private Object currentResult;
    private boolean hasNext;
    private final String[][] names;
    private PreparedStatement ps;
    private HolderInstantiator holderInstantiator;

    public IteratorImpl(ResultSet resultSet, PreparedStatement preparedStatement, EventSource eventSource, boolean bl, Type[] typeArray, String[][] stringArray, HolderInstantiator holderInstantiator) throws HibernateException, SQLException {
        this.rs = resultSet;
        this.ps = preparedStatement;
        this.session = eventSource;
        this.readOnly = bl;
        this.types = typeArray;
        this.names = stringArray;
        this.holderInstantiator = holderInstantiator;
        this.single = typeArray.length == 1;
        this.postNext();
    }

    public void close() throws JDBCException {
        if (this.ps != null) {
            LOG.debug("Closing iterator");
            this.session.getTransactionCoordinator().getJdbcCoordinator().release(this.ps);
            this.ps = null;
            this.rs = null;
            this.hasNext = false;
            try {
                this.session.getPersistenceContext().getLoadContexts().cleanup(this.rs);
            }
            catch (Throwable throwable) {
                LOG.debugf("Exception trying to cleanup load context : %s", (Object)throwable.getMessage());
            }
        }
    }

    private void postNext() throws SQLException {
        LOG.debug("Attempting to retrieve next results");
        this.hasNext = this.rs.next();
        if (!this.hasNext) {
            LOG.debug("Exhausted results");
            this.close();
        } else {
            LOG.debug("Retrieved next results");
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() throws HibernateException {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more results");
        }
        boolean bl = this.session.isDefaultReadOnly();
        this.session.setDefaultReadOnly(this.readOnly);
        try {
            Object object;
            boolean bl2 = this.holderInstantiator.isRequired();
            LOG.debugf("Assembling results", new Object[0]);
            if (this.single && !bl2) {
                this.currentResult = this.types[0].nullSafeGet(this.rs, this.names[0], (SessionImplementor)this.session, null);
            } else {
                object = new Object[this.types.length];
                for (int i = 0; i < this.types.length; ++i) {
                    object[i] = this.types[i].nullSafeGet(this.rs, this.names[i], (SessionImplementor)this.session, null);
                }
                this.currentResult = bl2 ? this.holderInstantiator.instantiate((Object[])object) : object;
            }
            this.postNext();
            LOG.debugf("Returning current results", new Object[0]);
            object = this.currentResult;
            return object;
        }
        catch (SQLException sQLException) {
            throw this.session.getFactory().getSQLExceptionHelper().convert(sQLException, "could not get next iterator result");
        }
        finally {
            this.session.setDefaultReadOnly(bl);
        }
    }

    public void remove() {
        if (!this.single) {
            throw new UnsupportedOperationException("Not a single column hibernate query result set");
        }
        if (this.currentResult == null) {
            throw new IllegalStateException("Called Iterator.remove() before next()");
        }
        if (!(this.types[0] instanceof EntityType)) {
            throw new UnsupportedOperationException("Not an entity");
        }
        this.session.delete(((EntityType)this.types[0]).getAssociatedEntityName(), this.currentResult, false, null);
    }
}

