/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterImpl
implements Filter,
Serializable {
    public static final String MARKER = "$FILTER_PLACEHOLDER$";
    private transient FilterDefinition definition;
    private String filterName;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    void afterDeserialize(SessionFactoryImpl sessionFactoryImpl) {
        this.definition = sessionFactoryImpl.getFilterDefinition(this.filterName);
        this.validate();
    }

    public FilterImpl(FilterDefinition filterDefinition) {
        this.definition = filterDefinition;
        this.filterName = this.definition.getFilterName();
    }

    @Override
    public FilterDefinition getFilterDefinition() {
        return this.definition;
    }

    @Override
    public String getName() {
        return this.definition.getFilterName();
    }

    public Map<String, ?> getParameters() {
        return this.parameters;
    }

    @Override
    public Filter setParameter(String string, Object object) throws IllegalArgumentException {
        Type type = this.definition.getParameterType(string);
        if (type == null) {
            throw new IllegalArgumentException("Undefined filter parameter [" + string + "]");
        }
        if (object != null && !type.getReturnedClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Incorrect type for parameter [" + string + "]");
        }
        this.parameters.put(string, object);
        return this;
    }

    @Override
    public Filter setParameterList(String string, Collection collection) throws HibernateException {
        if (collection == null) {
            throw new IllegalArgumentException("Collection must be not null!");
        }
        Type type = this.definition.getParameterType(string);
        if (type == null) {
            throw new HibernateException("Undefined filter parameter [" + string + "]");
        }
        if (collection.size() > 0) {
            Class<?> clazz = collection.iterator().next().getClass();
            if (!type.getReturnedClass().isAssignableFrom(clazz)) {
                throw new HibernateException("Incorrect type for parameter [" + string + "]");
            }
        }
        this.parameters.put(string, collection);
        return this;
    }

    @Override
    public Filter setParameterList(String string, Object[] objectArray) throws IllegalArgumentException {
        return this.setParameterList(string, Arrays.asList(objectArray));
    }

    public Object getParameter(String string) {
        return this.parameters.get(string);
    }

    @Override
    public void validate() throws HibernateException {
        for (String string : this.definition.getParameterNames()) {
            if (this.parameters.get(string) != null) continue;
            throw new HibernateException("Filter [" + this.getName() + "] parameter [" + string + "] value not set");
        }
    }
}

