/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.FilterConfiguration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.sql.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterHelper {
    private final String[] filterNames;
    private final String[] filterConditions;
    private final boolean[] filterAutoAliasFlags;
    private final Map<String, String>[] filterAliasTableMaps;

    public FilterHelper(List list, SessionFactoryImplementor sessionFactoryImplementor) {
        int n = list.size();
        this.filterNames = new String[n];
        this.filterConditions = new String[n];
        this.filterAutoAliasFlags = new boolean[n];
        this.filterAliasTableMaps = new Map[n];
        Iterator iterator = list.iterator();
        n = 0;
        while (iterator.hasNext()) {
            this.filterAutoAliasFlags[n] = false;
            FilterConfiguration filterConfiguration = (FilterConfiguration)iterator.next();
            this.filterNames[n] = filterConfiguration.getName();
            this.filterConditions[n] = filterConfiguration.getCondition();
            this.filterAliasTableMaps[n] = filterConfiguration.getAliasTableMap(sessionFactoryImplementor);
            if ((this.filterAliasTableMaps[n].isEmpty() || FilterHelper.isTableFromPersistentClass(this.filterAliasTableMaps[n])) && filterConfiguration.useAutoAliasInjection()) {
                this.filterConditions[n] = Template.renderWhereStringTemplate(filterConfiguration.getCondition(), "$FILTER_PLACEHOLDER$", sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
                this.filterAutoAliasFlags[n] = true;
            }
            this.filterConditions[n] = StringHelper.replace(this.filterConditions[n], ":", ":" + this.filterNames[n] + ".");
            ++n;
        }
    }

    private static boolean isTableFromPersistentClass(Map<String, String> map) {
        return map.size() == 1 && map.containsKey(null);
    }

    public boolean isAffectedBy(Map map) {
        int n = this.filterNames.length;
        for (int i = 0; i < n; ++i) {
            if (!map.containsKey(this.filterNames[i])) continue;
            return true;
        }
        return false;
    }

    public String render(FilterAliasGenerator filterAliasGenerator, Map map) {
        StringBuilder stringBuilder = new StringBuilder();
        this.render(stringBuilder, filterAliasGenerator, map);
        return stringBuilder.toString();
    }

    public void render(StringBuilder stringBuilder, FilterAliasGenerator filterAliasGenerator, Map map) {
        if (this.filterNames != null && this.filterNames.length > 0) {
            int n = this.filterNames.length;
            for (int i = 0; i < n; ++i) {
                String string;
                if (!map.containsKey(this.filterNames[i]) || !StringHelper.isNotEmpty(string = this.filterConditions[i])) continue;
                stringBuilder.append(" and ").append(this.render(filterAliasGenerator, i));
            }
        }
    }

    private String render(FilterAliasGenerator filterAliasGenerator, int n) {
        Map<String, String> map = this.filterAliasTableMaps[n];
        String string = this.filterConditions[n];
        if (this.filterAutoAliasFlags[n]) {
            return StringHelper.replace(string, "$FILTER_PLACEHOLDER$", filterAliasGenerator.getAlias(map.get(null)));
        }
        if (FilterHelper.isTableFromPersistentClass(map)) {
            return string.replace("{alias}", filterAliasGenerator.getAlias(map.get(null)));
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string = string.replace("{" + entry.getKey() + "}", filterAliasGenerator.getAlias(entry.getValue()));
        }
        return string;
    }
}

