/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.entity.Joinable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterConfiguration {
    private final String name;
    private final String condition;
    private final boolean autoAliasInjection;
    private final Map<String, String> aliasTableMap;
    private final Map<String, String> aliasEntityMap;
    private final PersistentClass persistentClass;

    public FilterConfiguration(String string, String string2, boolean bl, Map<String, String> map, Map<String, String> map2, PersistentClass persistentClass) {
        this.name = string;
        this.condition = string2;
        this.autoAliasInjection = bl;
        this.aliasTableMap = map;
        this.aliasEntityMap = map2;
        this.persistentClass = persistentClass;
    }

    public String getName() {
        return this.name;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean useAutoAliasInjection() {
        return this.autoAliasInjection;
    }

    public Map<String, String> getAliasTableMap(SessionFactoryImplementor sessionFactoryImplementor) {
        Map<String, String> map = this.mergeAliasMaps(sessionFactoryImplementor);
        if (!map.isEmpty()) {
            return map;
        }
        if (this.persistentClass != null) {
            String string = this.persistentClass.getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            return Collections.singletonMap(null, string);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> mergeAliasMaps(SessionFactoryImplementor sessionFactoryImplementor) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.aliasTableMap != null) {
            hashMap.putAll(this.aliasTableMap);
        }
        if (this.aliasEntityMap != null) {
            for (Map.Entry<String, String> entry : this.aliasEntityMap.entrySet()) {
                hashMap.put(entry.getKey(), ((Joinable)Joinable.class.cast(sessionFactoryImplementor.getEntityPersister(entry.getValue()))).getTableName());
            }
        }
        return hashMap;
    }
}

