/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.QueryImpl;
import org.hibernate.type.Type;

public class CollectionFilterImpl
extends QueryImpl {
    private Object collection;

    public CollectionFilterImpl(String string, Object object, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        super(string, sessionImplementor, parameterMetadata);
        this.collection = object;
    }

    public Iterator iterate() throws HibernateException {
        this.verifyParameters();
        Map map = this.getNamedParams();
        return this.getSession().iterateFilter(this.collection, this.expandParameterLists(map), this.getQueryParameters(map));
    }

    public List list() throws HibernateException {
        this.verifyParameters();
        Map map = this.getNamedParams();
        return this.getSession().listFilter(this.collection, this.expandParameterLists(map), this.getQueryParameters(map));
    }

    public ScrollableResults scroll() throws HibernateException {
        throw new UnsupportedOperationException("Can't scroll filters");
    }

    public Type[] typeArray() {
        List list = this.getTypes();
        int n = list.size();
        Type[] typeArray = new Type[n + 1];
        for (int i = 0; i < n; ++i) {
            typeArray[i + 1] = (Type)list.get(i);
        }
        return typeArray;
    }

    public Object[] valueArray() {
        List list = this.getValues();
        int n = list.size();
        Object[] objectArray = new Object[n + 1];
        for (int i = 0; i < n; ++i) {
            objectArray[i + 1] = list.get(i);
        }
        return objectArray;
    }
}

