/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheImpl
implements CacheImplementor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, CacheImpl.class.getName());
    private final SessionFactoryImplementor sessionFactory;
    private final Settings settings;
    private final transient QueryCache queryCache;
    private final transient RegionFactory regionFactory;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient ConcurrentMap<String, QueryCache> queryCaches;
    private final transient ConcurrentMap<String, Region> allCacheRegions = new ConcurrentHashMap<String, Region>();

    public CacheImpl(SessionFactoryImplementor sessionFactoryImplementor) {
        this.sessionFactory = sessionFactoryImplementor;
        this.settings = sessionFactoryImplementor.getSettings();
        this.regionFactory = this.settings.getRegionFactory();
        this.regionFactory.start(this.settings, sessionFactoryImplementor.getProperties());
        if (this.settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(this.settings, sessionFactoryImplementor.getProperties(), sessionFactoryImplementor);
            this.queryCache = this.settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, this.settings, sessionFactoryImplementor.getProperties());
            this.queryCaches = new ConcurrentHashMap<String, QueryCache>();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            this.allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
    }

    @Override
    public boolean containsEntity(Class clazz, Serializable serializable) {
        return this.containsEntity(clazz.getName(), serializable);
    }

    @Override
    public boolean containsEntity(String string, Serializable serializable) {
        EntityPersister entityPersister = this.sessionFactory.getEntityPersister(string);
        return entityPersister.hasCache() && entityPersister.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(serializable, entityPersister));
    }

    @Override
    public void evictEntity(Class clazz, Serializable serializable) {
        this.evictEntity(clazz.getName(), serializable);
    }

    @Override
    public void evictEntity(String string, Serializable serializable) {
        EntityPersister entityPersister = this.sessionFactory.getEntityPersister(string);
        if (entityPersister.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", (Object)MessageHelper.infoString(entityPersister, serializable, this.sessionFactory));
            }
            entityPersister.getCacheAccessStrategy().evict(this.buildCacheKey(serializable, entityPersister));
        }
    }

    private CacheKey buildCacheKey(Serializable serializable, EntityPersister entityPersister) {
        return new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), null, this.sessionFactory);
    }

    @Override
    public void evictEntityRegion(Class clazz) {
        this.evictEntityRegion(clazz.getName());
    }

    @Override
    public void evictEntityRegion(String string) {
        EntityPersister entityPersister = this.sessionFactory.getEntityPersister(string);
        if (entityPersister.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", (Object)entityPersister.getEntityName());
            }
            entityPersister.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictEntityRegions() {
        for (String string : this.sessionFactory.getEntityPersisters().keySet()) {
            this.evictEntityRegion(string);
        }
    }

    @Override
    public void evictNaturalIdRegion(Class clazz) {
        this.evictNaturalIdRegion(clazz.getName());
    }

    @Override
    public void evictNaturalIdRegion(String string) {
        EntityPersister entityPersister = this.sessionFactory.getEntityPersister(string);
        if (entityPersister.hasNaturalIdCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting natural-id cache: %s", (Object)entityPersister.getEntityName());
            }
            entityPersister.getNaturalIdCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictNaturalIdRegions() {
        for (String string : this.sessionFactory.getEntityPersisters().keySet()) {
            this.evictNaturalIdRegion(string);
        }
    }

    @Override
    public boolean containsCollection(String string, Serializable serializable) {
        CollectionPersister collectionPersister = this.sessionFactory.getCollectionPersister(string);
        return collectionPersister.hasCache() && collectionPersister.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(serializable, collectionPersister));
    }

    @Override
    public void evictCollection(String string, Serializable serializable) {
        CollectionPersister collectionPersister = this.sessionFactory.getCollectionPersister(string);
        if (collectionPersister.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", (Object)MessageHelper.collectionInfoString(collectionPersister, serializable, this.sessionFactory));
            }
            CacheKey cacheKey = this.buildCacheKey(serializable, collectionPersister);
            collectionPersister.getCacheAccessStrategy().evict(cacheKey);
        }
    }

    private CacheKey buildCacheKey(Serializable serializable, CollectionPersister collectionPersister) {
        return new CacheKey(serializable, collectionPersister.getKeyType(), collectionPersister.getRole(), null, this.sessionFactory);
    }

    @Override
    public void evictCollectionRegion(String string) {
        CollectionPersister collectionPersister = this.sessionFactory.getCollectionPersister(string);
        if (collectionPersister.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", (Object)collectionPersister.getRole());
            }
            collectionPersister.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictCollectionRegions() {
        for (String string : this.sessionFactory.getCollectionPersisters().keySet()) {
            this.evictCollectionRegion(string);
        }
    }

    @Override
    public boolean containsQuery(String string) {
        return this.queryCaches.containsKey(string);
    }

    @Override
    public void evictDefaultQueryRegion() {
        if (this.sessionFactory.getSettings().isQueryCacheEnabled()) {
            this.sessionFactory.getQueryCache().clear();
        }
    }

    @Override
    public void evictQueryRegion(String string) {
        QueryCache queryCache;
        if (string == null) {
            throw new NullPointerException("Region-name cannot be null (use Cache#evictDefaultQueryRegion to evict the default query cache)");
        }
        if (this.sessionFactory.getSettings().isQueryCacheEnabled() && (queryCache = (QueryCache)this.queryCaches.get(string)) != null) {
            queryCache.clear();
        }
    }

    @Override
    public void evictQueryRegions() {
        if (CollectionHelper.isEmpty(this.queryCaches)) {
            return;
        }
        for (QueryCache queryCache : this.queryCaches.values()) {
            queryCache.clear();
        }
    }

    @Override
    public void close() {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            for (QueryCache queryCache : this.queryCaches.values()) {
                queryCache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.regionFactory.stop();
    }

    @Override
    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCache getQueryCache(String string) throws HibernateException {
        if (string == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        QueryCache queryCache = (QueryCache)this.queryCaches.get(string);
        if (queryCache == null) {
            ConcurrentMap<String, Region> concurrentMap = this.allCacheRegions;
            synchronized (concurrentMap) {
                queryCache = (QueryCache)this.queryCaches.get(string);
                if (queryCache != null) {
                    return queryCache;
                }
                queryCache = this.settings.getQueryCacheFactory().getQueryCache(string, this.updateTimestampsCache, this.settings, this.sessionFactory.getProperties());
                this.queryCaches.put(string, queryCache);
                this.allCacheRegions.put(queryCache.getRegion().getName(), queryCache.getRegion());
            }
        }
        return queryCache;
    }

    @Override
    public void addCacheRegion(String string, Region region) {
        this.allCacheRegions.put(string, region);
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    @Override
    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    @Override
    public Region getSecondLevelCacheRegion(String string) {
        return (Region)this.allCacheRegions.get(string);
    }

    @Override
    public Region getNaturalIdCacheRegion(String string) {
        return (Region)this.allCacheRegions.get(string);
    }

    @Override
    public Map<String, Region> getAllSecondLevelCacheRegions() {
        return new HashMap<String, Region>(this.allCacheRegions);
    }

    @Override
    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }
}

