/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionContract;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.internal.QueryImpl;
import org.hibernate.internal.SQLQueryImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionImpl
implements Serializable,
SharedSessionContract,
SessionImplementor,
TransactionContext {
    protected transient SessionFactoryImpl factory;
    private final String tenantIdentifier;
    private boolean closed = false;
    private transient JdbcConnectionAccess jdbcConnectionAccess;
    private UUID sessionIdentifier;

    protected AbstractSessionImpl(SessionFactoryImpl sessionFactoryImpl, String string) {
        this.factory = sessionFactoryImpl;
        this.tenantIdentifier = string;
        if (MultiTenancyStrategy.NONE == sessionFactoryImpl.getSettings().getMultiTenancyStrategy()) {
            if (string != null) {
                throw new HibernateException("SessionFactory was not configured for multi-tenancy");
            }
        } else if (string == null) {
            throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
        }
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public TransactionEnvironment getTransactionEnvironment() {
        return this.factory.getTransactionEnvironment();
    }

    @Override
    public <T> T execute(final LobCreationContext.Callback<T> callback) {
        return this.getTransactionCoordinator().getJdbcCoordinator().coordinateWork(new WorkExecutorVisitable<T>(){

            @Override
            public T accept(WorkExecutor<T> workExecutor, Connection connection) throws SQLException {
                try {
                    return callback.executeOnConnection(connection);
                }
                catch (SQLException sQLException) {
                    throw AbstractSessionImpl.this.getFactory().getSQLExceptionHelper().convert(sQLException, "Error creating contextual LOB : " + sQLException.getMessage());
                }
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void setClosed() {
        this.closed = true;
    }

    protected void errorIfClosed() {
        if (this.closed) {
            throw new SessionException("Session is closed!");
        }
    }

    @Override
    public Query getNamedQuery(String string) throws MappingException {
        AbstractQueryImpl abstractQueryImpl;
        this.errorIfClosed();
        NamedQueryDefinition namedQueryDefinition = this.factory.getNamedQuery(string);
        if (namedQueryDefinition != null) {
            String string2 = namedQueryDefinition.getQueryString();
            abstractQueryImpl = new QueryImpl(string2, namedQueryDefinition.getFlushMode(), this, this.getHQLQueryPlan(string2, false).getParameterMetadata());
            abstractQueryImpl.setComment("named HQL query " + string);
            if (namedQueryDefinition.getLockTimeout() != null) {
                ((QueryImpl)abstractQueryImpl).getLockOptions().setTimeOut(namedQueryDefinition.getLockTimeout());
            }
        } else {
            NamedSQLQueryDefinition namedSQLQueryDefinition = this.factory.getNamedSQLQuery(string);
            if (namedSQLQueryDefinition == null) {
                throw new MappingException("Named query not known: " + string);
            }
            ParameterMetadata parameterMetadata = this.factory.getQueryPlanCache().getSQLParameterMetadata(namedSQLQueryDefinition.getQueryString());
            abstractQueryImpl = new SQLQueryImpl(namedSQLQueryDefinition, (SessionImplementor)this, parameterMetadata);
            abstractQueryImpl.setComment("named native SQL query " + string);
            namedQueryDefinition = namedSQLQueryDefinition;
        }
        this.initQuery(abstractQueryImpl, namedQueryDefinition);
        return abstractQueryImpl;
    }

    @Override
    public Query getNamedSQLQuery(String string) throws MappingException {
        this.errorIfClosed();
        NamedSQLQueryDefinition namedSQLQueryDefinition = this.factory.getNamedSQLQuery(string);
        if (namedSQLQueryDefinition == null) {
            throw new MappingException("Named SQL query not known: " + string);
        }
        SQLQueryImpl sQLQueryImpl = new SQLQueryImpl(namedSQLQueryDefinition, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(namedSQLQueryDefinition.getQueryString()));
        sQLQueryImpl.setComment("named native SQL query " + string);
        this.initQuery(sQLQueryImpl, namedSQLQueryDefinition);
        return sQLQueryImpl;
    }

    private void initQuery(Query query, NamedQueryDefinition namedQueryDefinition) {
        query.setCacheable(namedQueryDefinition.isCacheable());
        query.setCacheRegion(namedQueryDefinition.getCacheRegion());
        if (namedQueryDefinition.getTimeout() != null) {
            query.setTimeout(namedQueryDefinition.getTimeout());
        }
        if (namedQueryDefinition.getFetchSize() != null) {
            query.setFetchSize(namedQueryDefinition.getFetchSize());
        }
        if (namedQueryDefinition.getCacheMode() != null) {
            query.setCacheMode(namedQueryDefinition.getCacheMode());
        }
        query.setReadOnly(namedQueryDefinition.isReadOnly());
        if (namedQueryDefinition.getComment() != null) {
            query.setComment(namedQueryDefinition.getComment());
        }
    }

    @Override
    public Query createQuery(String string) {
        this.errorIfClosed();
        QueryImpl queryImpl = new QueryImpl(string, this, this.getHQLQueryPlan(string, false).getParameterMetadata());
        queryImpl.setComment(string);
        return queryImpl;
    }

    @Override
    public SQLQuery createSQLQuery(String string) {
        this.errorIfClosed();
        SQLQueryImpl sQLQueryImpl = new SQLQueryImpl(string, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(string));
        sQLQueryImpl.setComment("dynamic native SQL query");
        return sQLQueryImpl;
    }

    protected HQLQueryPlan getHQLQueryPlan(String string, boolean bl) throws HibernateException {
        return this.factory.getQueryPlanCache().getHQLQueryPlan(string, bl, this.getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification nativeSQLQuerySpecification) throws HibernateException {
        return this.factory.getQueryPlanCache().getNativeSQLQueryPlan(nativeSQLQuerySpecification);
    }

    @Override
    public List list(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.getNativeSQLQueryPlan(nativeSQLQuerySpecification).getCustomQuery(), queryParameters);
    }

    @Override
    public ScrollableResults scroll(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        return this.scrollCustomQuery(this.getNativeSQLQueryPlan(nativeSQLQuerySpecification).getCustomQuery(), queryParameters);
    }

    @Override
    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    @Override
    public EntityKey generateEntityKey(Serializable serializable, EntityPersister entityPersister) {
        return new EntityKey(serializable, entityPersister, this.getTenantIdentifier());
    }

    @Override
    public CacheKey generateCacheKey(Serializable serializable, Type type, String string) {
        return new CacheKey(serializable, type, string, this.getTenantIdentifier(), this.getFactory());
    }

    @Override
    public JdbcConnectionAccess getJdbcConnectionAccess() {
        if (this.jdbcConnectionAccess == null) {
            this.jdbcConnectionAccess = MultiTenancyStrategy.NONE == this.factory.getSettings().getMultiTenancyStrategy() ? new NonContextualJdbcConnectionAccess(this.factory.getServiceRegistry().getService(ConnectionProvider.class)) : new ContextualJdbcConnectionAccess(this.factory.getServiceRegistry().getService(MultiTenantConnectionProvider.class));
        }
        return this.jdbcConnectionAccess;
    }

    public UUID getSessionIdentifier() {
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = StandardRandomStrategy.INSTANCE.generateUUID(this);
        }
        return this.sessionIdentifier;
    }

    private class ContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final MultiTenantConnectionProvider connectionProvider;

        private ContextualJdbcConnectionAccess(MultiTenantConnectionProvider multiTenantConnectionProvider) {
            this.connectionProvider = multiTenantConnectionProvider;
        }

        public Connection obtainConnection() throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            return this.connectionProvider.getConnection(AbstractSessionImpl.this.tenantIdentifier);
        }

        public void releaseConnection(Connection connection) throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            this.connectionProvider.releaseConnection(AbstractSessionImpl.this.tenantIdentifier, connection);
        }

        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    private static class NonContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final ConnectionProvider connectionProvider;

        private NonContextualJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

