/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.HolderInstantiator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.Loader;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class AbstractScrollableResults
implements ScrollableResults {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractScrollableResults.class.getName());
    private final ResultSet resultSet;
    private final PreparedStatement ps;
    private final SessionImplementor session;
    private final Loader loader;
    private final QueryParameters queryParameters;
    private final Type[] types;
    private HolderInstantiator holderInstantiator;

    public AbstractScrollableResults(ResultSet resultSet, PreparedStatement preparedStatement, SessionImplementor sessionImplementor, Loader loader, QueryParameters queryParameters, Type[] typeArray, HolderInstantiator holderInstantiator) throws MappingException {
        this.resultSet = resultSet;
        this.ps = preparedStatement;
        this.session = sessionImplementor;
        this.loader = loader;
        this.queryParameters = queryParameters;
        this.types = typeArray;
        this.holderInstantiator = holderInstantiator != null && holderInstantiator.isRequired() ? holderInstantiator : null;
    }

    protected abstract Object[] getCurrentRow();

    protected ResultSet getResultSet() {
        return this.resultSet;
    }

    protected PreparedStatement getPs() {
        return this.ps;
    }

    protected SessionImplementor getSession() {
        return this.session;
    }

    protected Loader getLoader() {
        return this.loader;
    }

    protected QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    protected Type[] getTypes() {
        return this.types;
    }

    protected HolderInstantiator getHolderInstantiator() {
        return this.holderInstantiator;
    }

    public final void close() throws HibernateException {
        block2: {
            this.session.getTransactionCoordinator().getJdbcCoordinator().release(this.ps);
            try {
                this.session.getPersistenceContext().getLoadContexts().cleanup(this.resultSet);
            }
            catch (Throwable throwable) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.tracev("Exception trying to cleanup load context : {0}", (Object)throwable.getMessage());
            }
        }
    }

    public final Object[] get() throws HibernateException {
        return this.getCurrentRow();
    }

    public final Object get(int n) throws HibernateException {
        return this.getCurrentRow()[n];
    }

    protected final Object getFinal(int n, Type type) throws HibernateException {
        if (this.holderInstantiator != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (type.getReturnedClass() == this.types[n].getReturnedClass()) {
            return this.get(n);
        }
        return this.throwInvalidColumnTypeException(n, this.types[n], type);
    }

    protected final Object getNonFinal(int n, Type type) throws HibernateException {
        if (this.holderInstantiator != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (type.getReturnedClass().isAssignableFrom(this.types[n].getReturnedClass())) {
            return this.get(n);
        }
        return this.throwInvalidColumnTypeException(n, this.types[n], type);
    }

    public final BigDecimal getBigDecimal(int n) throws HibernateException {
        return (BigDecimal)this.getFinal(n, StandardBasicTypes.BIG_DECIMAL);
    }

    public final BigInteger getBigInteger(int n) throws HibernateException {
        return (BigInteger)this.getFinal(n, StandardBasicTypes.BIG_INTEGER);
    }

    public final byte[] getBinary(int n) throws HibernateException {
        return (byte[])this.getFinal(n, StandardBasicTypes.BINARY);
    }

    public final String getText(int n) throws HibernateException {
        return (String)this.getFinal(n, StandardBasicTypes.TEXT);
    }

    public final Blob getBlob(int n) throws HibernateException {
        return (Blob)this.getNonFinal(n, StandardBasicTypes.BLOB);
    }

    public final Clob getClob(int n) throws HibernateException {
        return (Clob)this.getNonFinal(n, StandardBasicTypes.CLOB);
    }

    public final Boolean getBoolean(int n) throws HibernateException {
        return (Boolean)this.getFinal(n, StandardBasicTypes.BOOLEAN);
    }

    public final Byte getByte(int n) throws HibernateException {
        return (Byte)this.getFinal(n, StandardBasicTypes.BYTE);
    }

    public final Character getCharacter(int n) throws HibernateException {
        return (Character)this.getFinal(n, StandardBasicTypes.CHARACTER);
    }

    public final Date getDate(int n) throws HibernateException {
        return (Date)this.getNonFinal(n, StandardBasicTypes.TIMESTAMP);
    }

    public final Calendar getCalendar(int n) throws HibernateException {
        return (Calendar)this.getNonFinal(n, StandardBasicTypes.CALENDAR);
    }

    public final Double getDouble(int n) throws HibernateException {
        return (Double)this.getFinal(n, StandardBasicTypes.DOUBLE);
    }

    public final Float getFloat(int n) throws HibernateException {
        return (Float)this.getFinal(n, StandardBasicTypes.FLOAT);
    }

    public final Integer getInteger(int n) throws HibernateException {
        return (Integer)this.getFinal(n, StandardBasicTypes.INTEGER);
    }

    public final Long getLong(int n) throws HibernateException {
        return (Long)this.getFinal(n, StandardBasicTypes.LONG);
    }

    public final Short getShort(int n) throws HibernateException {
        return (Short)this.getFinal(n, StandardBasicTypes.SHORT);
    }

    public final String getString(int n) throws HibernateException {
        return (String)this.getFinal(n, StandardBasicTypes.STRING);
    }

    public final Locale getLocale(int n) throws HibernateException {
        return (Locale)this.getFinal(n, StandardBasicTypes.LOCALE);
    }

    public final TimeZone getTimeZone(int n) throws HibernateException {
        return (TimeZone)this.getNonFinal(n, StandardBasicTypes.TIMEZONE);
    }

    public final Type getType(int n) {
        return this.types[n];
    }

    private Object throwInvalidColumnTypeException(int n, Type type, Type type2) throws HibernateException {
        throw new HibernateException("incompatible column types: " + type.getName() + ", " + type2.getName());
    }

    protected void afterScrollOperation() {
        this.session.afterScrollOperation();
    }
}

