/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.integrator.internal;

import java.util.LinkedHashSet;
import org.hibernate.cfg.beanvalidation.BeanValidationIntegrator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegratorServiceImpl
implements IntegratorService {
    private static final Logger LOG = Logger.getLogger(IntegratorServiceImpl.class.getName());
    private final LinkedHashSet<Integrator> integrators = new LinkedHashSet();

    public IntegratorServiceImpl(LinkedHashSet<Integrator> linkedHashSet, ClassLoaderService classLoaderService) {
        this.addIntegrator(new BeanValidationIntegrator());
        for (Integrator integrator : linkedHashSet) {
            this.addIntegrator(integrator);
        }
        for (Integrator integrator : classLoaderService.loadJavaServices(Integrator.class)) {
            this.addIntegrator(integrator);
        }
    }

    private void addIntegrator(Integrator integrator) {
        LOG.debugf("Adding Integrator [%s].", (Object)integrator.getClass().getName());
        this.integrators.add(integrator);
    }

    @Override
    public Iterable<Integrator> getIntegrators() {
        return this.integrators;
    }
}

