/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractSelectingDelegate
implements InsertGeneratedIdentifierDelegate {
    private final PostInsertIdentityPersister persister;

    protected AbstractSelectingDelegate(PostInsertIdentityPersister postInsertIdentityPersister) {
        this.persister = postInsertIdentityPersister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public final Serializable performInsert(String string, SessionImplementor sessionImplementor, Binder binder) {
        Object object;
        try {
            object = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, 2);
            try {
                binder.bindValues((PreparedStatement)object);
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate((PreparedStatement)object);
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release((Statement)object);
            }
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not insert: " + MessageHelper.infoString(this.persister), string);
        }
        object = this.getSelectSQL();
        try {
            PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)object, false);
            try {
                this.bindParameters(sessionImplementor, preparedStatement, binder.getEntity());
                ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
                try {
                    Serializable serializable = this.getResult(sessionImplementor, resultSet, binder.getEntity());
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                    return serializable;
                }
                catch (Throwable throwable) {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                    throw throwable;
                }
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not retrieve generated id after insert: " + MessageHelper.infoString(this.persister), string);
        }
    }

    protected abstract String getSelectSQL();

    protected void bindParameters(SessionImplementor sessionImplementor, PreparedStatement preparedStatement, Object object) throws SQLException {
    }

    protected abstract Serializable getResult(SessionImplementor var1, ResultSet var2, Object var3) throws SQLException;
}

