/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractReturningWork;
import org.jboss.logging.Logger;

public class TableStructure
implements DatabaseStructure {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TableStructure.class.getName());
    private final String tableName;
    private final String valueColumnName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private final String selectQuery;
    private final String updateQuery;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(Dialect dialect, String string, String string2, int n, int n2, Class clazz) {
        this.tableName = string;
        this.initialValue = n;
        this.incrementSize = n2;
        this.valueColumnName = string2;
        this.numberType = clazz;
        this.selectQuery = "select " + string2 + " as id_val" + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, string) + dialect.getForUpdateString();
        this.updateQuery = "update " + string + " set " + string2 + "= ?" + " where " + string2 + "=?";
    }

    public String getName() {
        return this.tableName;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public AccessCallback buildCallback(final SessionImplementor sessionImplementor) {
        return new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return sessionImplementor.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

                    @Override
                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int n;
                        SqlStatementLogger sqlStatementLogger = sessionImplementor.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlStatementLogger();
                        IntegralDataTypeHolder integralDataTypeHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(TableStructure.this.numberType);
                        do {
                            AutoCloseable autoCloseable;
                            sqlStatementLogger.logStatement(TableStructure.this.selectQuery, FormatStyle.BASIC.getFormatter());
                            PreparedStatement preparedStatement = connection.prepareStatement(TableStructure.this.selectQuery);
                            try {
                                autoCloseable = preparedStatement.executeQuery();
                                if (!autoCloseable.next()) {
                                    String string = "could not read a hi value - you need to populate the table: " + TableStructure.this.tableName;
                                    LOG.error(string);
                                    throw new IdentifierGenerationException(string);
                                }
                                integralDataTypeHolder.initialize((ResultSet)autoCloseable, 1L);
                                autoCloseable.close();
                            }
                            catch (SQLException sQLException) {
                                LOG.error("could not read a hi value", sQLException);
                                throw sQLException;
                            }
                            finally {
                                preparedStatement.close();
                            }
                            sqlStatementLogger.logStatement(TableStructure.this.updateQuery, FormatStyle.BASIC.getFormatter());
                            autoCloseable = connection.prepareStatement(TableStructure.this.updateQuery);
                            try {
                                int n2 = TableStructure.this.applyIncrementSizeToSourceValues ? TableStructure.this.incrementSize : 1;
                                IntegralDataTypeHolder integralDataTypeHolder2 = integralDataTypeHolder.copy().add(n2);
                                integralDataTypeHolder2.bind((PreparedStatement)autoCloseable, 1);
                                integralDataTypeHolder.bind((PreparedStatement)autoCloseable, 2);
                                n = autoCloseable.executeUpdate();
                            }
                            catch (SQLException sQLException) {
                                LOG.unableToUpdateQueryHiValue(TableStructure.this.tableName, sQLException);
                                throw sQLException;
                            }
                            finally {
                                autoCloseable.close();
                            }
                        } while (n == 0);
                        TableStructure.this.accessCounter++;
                        return integralDataTypeHolder;
                    }
                }, true);
            }
        };
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.valueColumnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( " + this.initialValue + " )"};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getDropTableString(this.tableName)};
    }

    public boolean isPhysicalSequence() {
        return false;
    }
}

