/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SequenceStyleGenerator.class.getName());
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String DEF_SEQUENCE_NAME = "hibernate_sequence";
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String CONFIG_PREFER_SEQUENCE_PER_ENTITY = "prefer_sequence_per_entity";
    public static final String CONFIG_SEQUENCE_PER_ENTITY_SUFFIX = "sequence_per_entity_suffix";
    public static final String DEF_SEQUENCE_SUFFIX = "_SEQ";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.identifierType = type;
        boolean bl = ConfigurationHelper.getBoolean(FORCE_TBL_PARAM, properties, false);
        String string = this.determineSequenceName(properties, dialect);
        int n = this.determineInitialValue(properties);
        int n2 = this.determineIncrementSize(properties);
        String string2 = this.determineOptimizationStrategy(properties, n2);
        n2 = this.determineAdjustedIncrementSize(string2, n2);
        if (dialect.supportsSequences() && !bl && !dialect.supportsPooledSequences() && OptimizerFactory.isPooledOptimizer(string2)) {
            bl = true;
            LOG.forcingTableUse();
        }
        this.databaseStructure = this.buildDatabaseStructure(type, properties, dialect, bl, string, n, n2);
        this.optimizer = OptimizerFactory.buildOptimizer(string2, this.identifierType.getReturnedClass(), n2, ConfigurationHelper.getInt(INITIAL_PARAM, properties, -1));
        this.databaseStructure.prepare(this.optimizer);
    }

    protected String determineSequenceName(Properties properties, Dialect dialect) {
        String string = ConfigurationHelper.getString(CONFIG_SEQUENCE_PER_ENTITY_SUFFIX, properties, DEF_SEQUENCE_SUFFIX);
        String string2 = ConfigurationHelper.getBoolean(CONFIG_PREFER_SEQUENCE_PER_ENTITY, properties, false) ? properties.getProperty("jpa_entity_name") + string : DEF_SEQUENCE_NAME;
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        if ((string2 = ConfigurationHelper.getString(SEQUENCE_PARAM, properties, string2)).indexOf(46) < 0) {
            string2 = objectNameNormalizer.normalizeIdentifierQuoting(string2);
            String string3 = properties.getProperty("schema");
            String string4 = properties.getProperty("catalog");
            string2 = Table.qualify(dialect.quote(string4), dialect.quote(string3), dialect.quote(string2));
        }
        return string2;
    }

    protected String determineValueColumnName(Properties properties, Dialect dialect) {
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        String string = ConfigurationHelper.getString(VALUE_COLUMN_PARAM, properties, DEF_VALUE_COLUMN);
        return dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(string));
    }

    protected int determineInitialValue(Properties properties) {
        return ConfigurationHelper.getInt(INITIAL_PARAM, properties, 1);
    }

    protected int determineIncrementSize(Properties properties) {
        return ConfigurationHelper.getInt(INCREMENT_PARAM, properties, 1);
    }

    protected String determineOptimizationStrategy(Properties properties, int n) {
        String string = ConfigurationHelper.getBoolean("hibernate.id.optimizer.pooled.prefer_lo", properties, false) ? OptimizerFactory.StandardOptimizerDescriptor.POOLED_LO.getExternalName() : OptimizerFactory.StandardOptimizerDescriptor.POOLED.getExternalName();
        String string2 = n <= 1 ? OptimizerFactory.StandardOptimizerDescriptor.NONE.getExternalName() : string;
        return ConfigurationHelper.getString(OPT_PARAM, properties, string2);
    }

    protected int determineAdjustedIncrementSize(String string, int n) {
        if (n > 1 && OptimizerFactory.StandardOptimizerDescriptor.NONE.getExternalName().equals(string)) {
            LOG.honoringOptimizerSetting(OptimizerFactory.StandardOptimizerDescriptor.NONE.getExternalName(), INCREMENT_PARAM, n);
            n = 1;
        }
        return n;
    }

    protected DatabaseStructure buildDatabaseStructure(Type type, Properties properties, Dialect dialect, boolean bl, String string, int n, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = dialect.supportsSequences() && !bl;
        if (bl2) {
            return new SequenceStructure(dialect, string, n, n2, type.getReturnedClass());
        }
        String string2 = this.determineValueColumnName(properties, dialect);
        return new TableStructure(dialect, string, string2, n, n2, type.getReturnedClass());
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(sessionImplementor));
    }

    public Object generatorKey() {
        return this.databaseStructure.getName();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlCreateStrings(dialect);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlDropStrings(dialect);
    }

    public boolean supportsBulkInsertionIdentifierGeneration() {
        return OptimizerFactory.NoopOptimizer.class.isInstance(this.getOptimizer()) && this.getDatabaseStructure().isPhysicalSequence();
    }

    public String determineBulkInsertionIdentifierGenerationSelectFragment(Dialect dialect) {
        return dialect.getSelectSequenceNextValString(this.getDatabaseStructure().getName());
    }
}

