/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SequenceStructure
implements DatabaseStructure {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SequenceStructure.class.getName());
    private final String sequenceName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private final String sql;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public SequenceStructure(Dialect dialect, String string, int n, int n2, Class clazz) {
        this.sequenceName = string;
        this.initialValue = n;
        this.incrementSize = n2;
        this.numberType = clazz;
        this.sql = dialect.getSequenceNextValString(string);
    }

    public String getName() {
        return this.sequenceName;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public AccessCallback buildCallback(final SessionImplementor sessionImplementor) {
        return new AccessCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public IntegralDataTypeHolder getNextValue() {
                SequenceStructure.this.accessCounter++;
                try {
                    PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(SequenceStructure.this.sql);
                    try {
                        IntegralDataTypeHolder integralDataTypeHolder;
                        ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
                        try {
                            resultSet.next();
                            IntegralDataTypeHolder integralDataTypeHolder2 = IdentifierGeneratorHelper.getIntegralDataTypeHolder(SequenceStructure.this.numberType);
                            integralDataTypeHolder2.initialize(resultSet, 1L);
                            if (LOG.isDebugEnabled()) {
                                LOG.debugf("Sequence value obtained: %s", (Object)integralDataTypeHolder2.makeValue());
                            }
                            integralDataTypeHolder = integralDataTypeHolder2;
                        }
                        catch (Throwable throwable) {
                            try {
                                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return integralDataTypeHolder;
                    }
                    finally {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                    }
                }
                catch (SQLException sQLException) {
                    throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not get next sequence value", SequenceStructure.this.sql);
                }
            }
        };
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        int n = this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
        return dialect.getCreateSequenceStrings(this.sequenceName, this.initialValue, n);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public boolean isPhysicalSequence() {
        return true;
    }
}

